/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils.tls;

import java.time.Instant;

class ValidityPeriod {
    private final Instant _from;
    private final Instant _to;

    ValidityPeriod(Instant from, Instant to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Both 'to' and 'from' parameters cannot be null");
        }
        if (to.compareTo(from) < 0) {
            throw new IllegalArgumentException("Parameter 'to' cannot be less than 'from' value");
        }
        this._from = from;
        this._to = to;
    }

    public Instant getFrom() {
        return this._from;
    }

    public Instant getTo() {
        return this._to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidityPeriod that = (ValidityPeriod)o;
        if (!this._from.equals(that._from)) {
            return false;
        }
        return this._to.equals(that._to);
    }

    public int hashCode() {
        int result = this._from.hashCode();
        result = 31 * result + this._to.hashCode();
        return result;
    }

    public String toString() {
        return "ValidityPeriod{_from=" + String.valueOf(this._from) + ", _to=" + String.valueOf(this._to) + "}";
    }
}

