/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils.tls;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import org.apache.qpid.test.utils.tls.AlternativeName;
import org.apache.qpid.test.utils.tls.KeyCertificatePair;
import org.apache.qpid.test.utils.tls.ValidityPeriod;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class TlsResourceBuilder {
    private static final int RSA_KEY_SIZE = 2048;
    private static final int VALIDITY_DURATION = 365;
    private static final String SIGNATURE_ALGORITHM_SHA_512_WITH_RSA = "SHA512WithRSA";

    private TlsResourceBuilder() {
    }

    public static KeyPair createRSAKeyPair() {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("RSA generator is not found");
        }
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.genKeyPair();
    }

    public static KeyCertificatePair createKeyPairAndRootCA(String dn) throws CertificateException {
        return TlsResourceBuilder.createKeyPairAndRootCA(dn, TlsResourceBuilder.createValidityPeriod());
    }

    public static KeyCertificatePair createKeyPairAndIntermediateCA(String dn, KeyCertificatePair rootCA, String crlUri) throws CertificateException {
        return TlsResourceBuilder.createKeyPairAndIntermediateCA(dn, TlsResourceBuilder.createValidityPeriod(), rootCA, crlUri);
    }

    public static KeyCertificatePair createSelfSigned(String dn, Instant validFrom, Instant validTo, AlternativeName ... alternativeName) throws CertificateException {
        return TlsResourceBuilder.createSelfSigned(dn, new ValidityPeriod(validFrom, validTo), alternativeName);
    }

    public static KeyCertificatePair createSelfSigned(String dn, AlternativeName ... alternativeName) throws CertificateException {
        return TlsResourceBuilder.createSelfSigned(dn, TlsResourceBuilder.createValidityPeriod(), alternativeName);
    }

    public static KeyCertificatePair createKeyPairAndCertificate(String dn, KeyCertificatePair ca, AlternativeName ... alternativeName) throws CertificateException {
        return TlsResourceBuilder.createKeyPairAndCertificate(dn, TlsResourceBuilder.createValidityPeriod(), ca, alternativeName);
    }

    public static X509Certificate createCertificate(KeyPair keyPair, KeyCertificatePair ca, String dn, Instant from, Instant to, AlternativeName ... alternativeNames) throws CertificateException {
        return TlsResourceBuilder.createCertificate(keyPair, ca, dn, new ValidityPeriod(from, to), alternativeNames, TlsResourceBuilder.createKeyUsageExtension());
    }

    public static X509Certificate createCertificateForClientAuthorization(KeyPair keyPair, KeyCertificatePair ca, String dn, AlternativeName ... alternativeNames) throws CertificateException {
        return TlsResourceBuilder.createCertificate(keyPair, ca, dn, TlsResourceBuilder.createValidityPeriod(), alternativeNames, TlsResourceBuilder.createExtendedUsageExtension(new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth})), TlsResourceBuilder.createAuthorityKeyExtension(ca.getCertificate().getPublicKey()), TlsResourceBuilder.createSubjectKeyExtension(keyPair.getPublic()));
    }

    public static X509Certificate createCertificateForServerAuthorization(KeyPair keyPair, KeyCertificatePair ca, String dn, AlternativeName ... alternativeNames) throws CertificateException {
        return TlsResourceBuilder.createCertificate(keyPair, ca, dn, TlsResourceBuilder.createValidityPeriod(), alternativeNames, TlsResourceBuilder.createExtendedUsageExtension(new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth})), TlsResourceBuilder.createAuthorityKeyExtension(ca.getCertificate().getPublicKey()), TlsResourceBuilder.createSubjectKeyExtension(keyPair.getPublic()));
    }

    public static X509Certificate createCertificateWithCrlDistributionPoint(KeyPair keyPair, KeyCertificatePair caPair, String dn, String crlUri) throws CertificateException {
        return TlsResourceBuilder.createCertificate(keyPair, caPair, dn, TlsResourceBuilder.createValidityPeriod(), null, TlsResourceBuilder.createKeyUsageExtension(), TlsResourceBuilder.createDistributionPointExtension(crlUri));
    }

    private static X509Certificate createCertificate(KeyPair keyPair, KeyCertificatePair ca, String dn, ValidityPeriod validityPeriod, AlternativeName[] alternativeNames, Extension ... extensions) throws CertificateException {
        try {
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(ca.getCertificate(), TlsResourceBuilder.generateSerialNumber(), new Date(validityPeriod.getFrom().toEpochMilli()), new Date(validityPeriod.getTo().toEpochMilli()), new X500Name(RFC4519Style.INSTANCE, dn), keyPair.getPublic());
            builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
            for (Extension e : extensions) {
                builder.addExtension(e);
            }
            if (alternativeNames != null && alternativeNames.length > 0) {
                builder.addExtension(TlsResourceBuilder.createAlternateNamesExtension(alternativeNames));
            }
            return TlsResourceBuilder.buildX509Certificate((X509v3CertificateBuilder)builder, ca.getPrivateKey());
        }
        catch (IOException | OperatorException e) {
            throw new CertificateException(e);
        }
    }

    private static X509Certificate createSelfSignedCertificate(KeyPair keyPair, String dn, ValidityPeriod period, AlternativeName ... alternativeName) throws CertificateException {
        try {
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(new X500Name(RFC4519Style.INSTANCE, dn), TlsResourceBuilder.generateSerialNumber(), new Date(period.getFrom().toEpochMilli()), new Date(period.getTo().toEpochMilli()), new X500Name(RFC4519Style.INSTANCE, dn), keyPair.getPublic());
            builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
            builder.addExtension(TlsResourceBuilder.createKeyUsageExtension());
            builder.addExtension(TlsResourceBuilder.createSubjectKeyExtension(keyPair.getPublic()));
            if (alternativeName != null && alternativeName.length > 0) {
                builder.addExtension(TlsResourceBuilder.createAlternateNamesExtension(alternativeName));
            }
            return TlsResourceBuilder.buildX509Certificate((X509v3CertificateBuilder)builder, keyPair.getPrivate());
        }
        catch (IOException | OperatorException e) {
            throw new CertificateException(e);
        }
    }

    static X509CRL createCertificateRevocationList(KeyCertificatePair ca, X509Certificate ... certificate) throws CRLException {
        try {
            X500Name issuerName = X500Name.getInstance((X500NameStyle)RFC4519Style.INSTANCE, (Object)ca.getCertificate().getSubjectX500Principal().getEncoded());
            Instant nextUpdate = Instant.now().plus(10L, ChronoUnit.DAYS);
            Date now = new Date();
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(issuerName, now);
            crlBuilder.setNextUpdate(new Date(nextUpdate.toEpochMilli()));
            for (X509Certificate c : certificate) {
                crlBuilder.addCRLEntry(c.getSerialNumber(), now, 9);
            }
            crlBuilder.addExtension(TlsResourceBuilder.createAuthorityKeyExtension(ca.getCertificate().getPublicKey()));
            crlBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(TlsResourceBuilder.generateSerialNumber()));
            ContentSigner contentSigner = TlsResourceBuilder.createContentSigner(ca.getPrivateKey());
            X509CRLHolder crl = crlBuilder.build(contentSigner);
            return new JcaX509CRLConverter().getCRL(crl);
        }
        catch (IOException | CertificateException | OperatorException e) {
            throw new CRLException(e);
        }
    }

    private static X509Certificate createRootCACertificate(KeyPair keyPair, String dn, ValidityPeriod validityPeriod) throws CertificateException {
        try {
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(new X500Name(RFC4519Style.INSTANCE, dn), TlsResourceBuilder.generateSerialNumber(), new Date(validityPeriod.getFrom().toEpochMilli()), new Date(validityPeriod.getTo().toEpochMilli()), new X500Name(RFC4519Style.INSTANCE, dn), keyPair.getPublic());
            builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
            builder.addExtension(TlsResourceBuilder.createSubjectKeyExtension(keyPair.getPublic()));
            builder.addExtension(TlsResourceBuilder.createAuthorityKeyExtension(keyPair.getPublic()));
            return TlsResourceBuilder.buildX509Certificate((X509v3CertificateBuilder)builder, keyPair.getPrivate());
        }
        catch (IOException | OperatorException e) {
            throw new CertificateException(e);
        }
    }

    private static X509Certificate generateIntermediateCertificate(KeyPair keyPair, KeyCertificatePair rootCA, String dn, ValidityPeriod validityPeriod, String crlUri) throws CertificateException {
        try {
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(rootCA.getCertificate(), TlsResourceBuilder.generateSerialNumber(), new Date(validityPeriod.getFrom().toEpochMilli()), new Date(validityPeriod.getTo().toEpochMilli()), new X500Name(RFC4519Style.INSTANCE, dn), keyPair.getPublic());
            builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
            builder.addExtension(TlsResourceBuilder.createSubjectKeyExtension(keyPair.getPublic()));
            builder.addExtension(TlsResourceBuilder.createAuthorityKeyExtension(rootCA.getCertificate().getPublicKey()));
            if (crlUri != null) {
                builder.addExtension(TlsResourceBuilder.createDistributionPointExtension(crlUri));
            }
            return TlsResourceBuilder.buildX509Certificate((X509v3CertificateBuilder)builder, rootCA.getPrivateKey());
        }
        catch (IOException | OperatorException e) {
            throw new CertificateException(e);
        }
    }

    private static KeyCertificatePair createKeyPairAndRootCA(String dn, ValidityPeriod validityPeriod) throws CertificateException {
        KeyPair keyPair = TlsResourceBuilder.createRSAKeyPair();
        X509Certificate rootCA = TlsResourceBuilder.createRootCACertificate(keyPair, dn, validityPeriod);
        return new KeyCertificatePair(keyPair.getPrivate(), rootCA);
    }

    private static KeyCertificatePair createKeyPairAndIntermediateCA(String dn, ValidityPeriod validityPeriod, KeyCertificatePair rootCA, String crlUri) throws CertificateException {
        KeyPair keyPair = TlsResourceBuilder.createRSAKeyPair();
        X509Certificate intermediateCA = TlsResourceBuilder.generateIntermediateCertificate(keyPair, rootCA, dn, validityPeriod, crlUri);
        return new KeyCertificatePair(keyPair.getPrivate(), intermediateCA);
    }

    private static KeyCertificatePair createKeyPairAndCertificate(String dn, ValidityPeriod validityPeriod, KeyCertificatePair ca, AlternativeName ... alternativeName) throws CertificateException {
        KeyPair keyPair = TlsResourceBuilder.createRSAKeyPair();
        X509Certificate certificate = TlsResourceBuilder.createCertificate(keyPair, ca, dn, validityPeriod, alternativeName);
        return new KeyCertificatePair(keyPair.getPrivate(), certificate);
    }

    private static X509Certificate createCertificate(KeyPair keyPair, KeyCertificatePair ca, String dn, ValidityPeriod validityPeriod, AlternativeName ... alternativeNames) throws CertificateException {
        return TlsResourceBuilder.createCertificate(keyPair, ca, dn, validityPeriod, alternativeNames, TlsResourceBuilder.createKeyUsageExtension());
    }

    private static KeyCertificatePair createSelfSigned(String dn, ValidityPeriod validityPeriod, AlternativeName ... alternativeName) throws CertificateException {
        KeyPair keyPair = TlsResourceBuilder.createRSAKeyPair();
        X509Certificate certificate = TlsResourceBuilder.createSelfSignedCertificate(keyPair, dn, validityPeriod, alternativeName);
        return new KeyCertificatePair(keyPair.getPrivate(), certificate);
    }

    private static ValidityPeriod createValidityPeriod() {
        Instant from = Instant.now().minus(1L, ChronoUnit.DAYS);
        Instant to = from.plus(365L, ChronoUnit.DAYS);
        return new ValidityPeriod(from, to);
    }

    private static Extension createAuthorityKeyExtension(PublicKey publicKey) throws CertificateException {
        try {
            return new Extension(Extension.authorityKeyIdentifier, false, new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(publicKey).getEncoded());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new CertificateException(e);
        }
    }

    private static Extension createSubjectKeyExtension(PublicKey publicKey) throws CertificateException {
        try {
            return new Extension(Extension.subjectKeyIdentifier, false, new JcaX509ExtensionUtils().createSubjectKeyIdentifier(publicKey).getEncoded());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new CertificateException(e);
        }
    }

    private static Extension createExtendedUsageExtension(ExtendedKeyUsage extendedKeyUsage) throws CertificateException {
        try {
            return new Extension(Extension.extendedKeyUsage, false, extendedKeyUsage.getEncoded());
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    private static Extension createKeyUsageExtension() {
        return new Extension(Extension.keyUsage, false, new KeyUsage(224).getBytes());
    }

    private static Extension createDistributionPointExtension(String crlUri) throws CertificateException {
        try {
            GeneralName generalName = new GeneralName(6, crlUri);
            DistributionPointName pointName = new DistributionPointName(new GeneralNames(generalName));
            DistributionPoint[] points = new DistributionPoint[]{new DistributionPoint(pointName, null, null)};
            return new Extension(Extension.cRLDistributionPoints, false, new CRLDistPoint(points).getEncoded());
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    private static Extension createAlternateNamesExtension(AlternativeName[] alternativeName) throws CertificateException {
        try {
            GeneralName[] generalNames = (GeneralName[])Arrays.stream(alternativeName).map(an -> new GeneralName(an.getType().ordinal(), an.getName())).toArray(GeneralName[]::new);
            return new Extension(Extension.subjectAlternativeName, false, new GeneralNames(generalNames).getEncoded());
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    private static BigInteger generateSerialNumber() {
        return new BigInteger(64, new SecureRandom());
    }

    private static X509Certificate buildX509Certificate(X509v3CertificateBuilder builder, PrivateKey pk) throws OperatorCreationException, CertificateException {
        ContentSigner contentSigner = TlsResourceBuilder.createContentSigner(pk);
        return new JcaX509CertificateConverter().getCertificate(builder.build(contentSigner));
    }

    private static ContentSigner createContentSigner(PrivateKey privateKey) throws OperatorCreationException {
        return new JcaContentSignerBuilder(SIGNATURE_ALGORITHM_SHA_512_WITH_RSA).setProvider("BC").build(privateKey);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

