/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.message.AMQMessageDelegate_0_8;
import org.apache.qpid.client.message.AbstractAMQMessageDelegate;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.AbstractJMSMessageFactory;
import org.apache.qpid.client.message.MessageFactoryRegistry;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encrypted091MessageFactory
extends AbstractJMSMessageFactory {
    public static final String ENCRYPTED_0_9_1_CONTENT_TYPE = "application/qpid-0-9-1-encrypted";
    private static final Logger LOGGER = LoggerFactory.getLogger(Encrypted091MessageFactory.class);
    private final MessageFactoryRegistry _messageFactoryRegistry;

    public Encrypted091MessageFactory(MessageFactoryRegistry messageFactoryRegistry) {
        this._messageFactoryRegistry = messageFactoryRegistry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected AbstractJMSMessage createMessage(AbstractAMQMessageDelegate delegate, ByteBuffer data) throws QpidException {
        try {
            try {
                int length;
                int offset;
                byte[] encryptedData;
                byte[] initVector;
                if (!delegate.hasProperty("x-qpid-encryption-algorithm")) throw new QpidException("Encrypted message must carry the encryption algorithm in the property 'x-qpid-encrypted-keys'");
                String algorithm = delegate.getProperty("x-qpid-encryption-algorithm").toString();
                if (delegate.hasProperty("x-qpid-key-init-vector")) {
                    Object ivObj = delegate.getProperty("x-qpid-key-init-vector");
                    if (!(ivObj instanceof byte[])) throw new QpidException("If the property 'x-qpid-key-init-vector' is present, it must contain a byte array");
                    initVector = (byte[])ivObj;
                } else {
                    initVector = null;
                }
                if (!delegate.hasProperty("x-qpid-encrypted-keys")) throw new QpidException("An encrypted message must contain the property 'x-qpid-encrypted-keys'");
                Object keyInfoObj = delegate.getProperty("x-qpid-encrypted-keys");
                if (!(keyInfoObj instanceof Collection)) {
                    throw new QpidException("An encrypted message must contain the property 'x-qpid-encrypted-keys'");
                }
                SecretKeySpec secretKeySpec = this.getContentEncryptionKey((Collection)keyInfoObj, algorithm, this._messageFactoryRegistry.getSession());
                Cipher cipher = Cipher.getInstance(algorithm);
                cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(initVector));
                if (data.hasArray()) {
                    encryptedData = data.array();
                    offset = data.arrayOffset() + data.position();
                    length = data.remaining();
                } else {
                    encryptedData = new byte[data.remaining()];
                    data.duplicate().get(encryptedData);
                    offset = 0;
                    length = encryptedData.length;
                }
                byte[] unencryptedBytes = this.decryptData(cipher, encryptedData, offset, length);
                BasicContentHeaderProperties properties = new BasicContentHeaderProperties();
                QpidByteBuffer dataInput = QpidByteBuffer.wrap((byte[])unencryptedBytes);
                int payloadOffset = properties.read(dataInput);
                ByteBuffer unencryptedData = ByteBuffer.wrap(unencryptedBytes, payloadOffset, unencryptedBytes.length - payloadOffset);
                AMQMessageDelegate_0_8 newDelegate = new AMQMessageDelegate_0_8(properties, delegate.getDeliveryTag());
                newDelegate.setJMSDestination(delegate.getJMSDestination());
                AbstractJMSMessageFactory unencryptedMessageFactory = this._messageFactoryRegistry.getMessageFactory(properties.getContentTypeAsString());
                return unencryptedMessageFactory.createMessage(newDelegate, unencryptedData);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new QpidException("Could not decode encrypted message", (Throwable)e);
            }
        }
        catch (QpidException e) {
            LOGGER.error("Error when attempting to decrypt message " + delegate.getDeliveryTag() + " to address (" + delegate.getJMSDestination() + ").  Message will be delivered to the client encrypted", (Throwable)e);
            return this._messageFactoryRegistry.getDefaultFactory().createMessage(delegate, data);
        }
    }

    private byte[] decryptData(Cipher cipher, byte[] encryptedData, int offset, int length) throws IOException {
        byte[] unencryptedBytes;
        try (CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(encryptedData, offset, length), cipher);){
            int read;
            byte[] buf = new byte[512];
            int pos = 0;
            while ((read = cipherInputStream.read(buf, pos, buf.length - pos)) != -1) {
                if ((pos += read) != buf.length) continue;
                byte[] tmp = buf;
                buf = new byte[buf.length + 512];
                System.arraycopy(tmp, 0, buf, 0, tmp.length);
            }
            unencryptedBytes = new byte[pos];
            System.arraycopy(buf, 0, unencryptedBytes, 0, pos);
        }
        return unencryptedBytes;
    }

    private SecretKeySpec getContentEncryptionKey(Collection keyInfoObjList, String algorithm, AMQSession<?, ?> session) throws QpidException, GeneralSecurityException, IOException {
        block5: for (Object keyInfoObject : keyInfoObjList) {
            try {
                Iterator iter = ((Collection)keyInfoObject).iterator();
                int type = ((Number)iter.next()).intValue();
                switch (type) {
                    case 1: {
                        String keyEncryptionAlgorithm = (String)iter.next();
                        X500Principal issuer = new X500Principal((String)iter.next());
                        BigInteger serialNumber = new BigInteger((String)iter.next());
                        byte[] encryptedKey = (byte[])iter.next();
                        PrivateKey privateKey = this.getPrivateKey(session, issuer, serialNumber);
                        if (privateKey == null) continue block5;
                        Cipher cipher = Cipher.getInstance(keyEncryptionAlgorithm);
                        cipher.init(2, privateKey);
                        byte[] decryptedData = this.decryptData(cipher, encryptedKey, 0, encryptedKey.length);
                        SecretKeySpec keySpec = new SecretKeySpec(decryptedData, algorithm.split("/")[0]);
                        return keySpec;
                    }
                    default: {
                        throw new QpidException("Invalid format of 'x-qpid-encrypted-keys' - unknown key info type: " + type);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new QpidException("Invalid format of 'x-qpid-encrypted-keys'");
            }
        }
        return null;
    }

    private PrivateKey getPrivateKey(AMQSession<?, ?> session, X500Principal issuer, BigInteger serialNumber) throws GeneralSecurityException, IOException {
        return session.getMessageEncryptionHelper().getEncryptionPrivateKey(issuer, serialNumber);
    }
}

