/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.filter;

import javax.jms.JMSException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.client.filter.MessageFilter;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.filter.BooleanExpression;
import org.apache.qpid.filter.FilterableMessage;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.SelectorParser;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSSelectorFilter
implements MessageFilter {
    private static final Logger _logger = LoggerFactory.getLogger(JMSSelectorFilter.class);
    private final String _selector;
    private final BooleanExpression _matcher;

    public JMSSelectorFilter(String selector) throws AMQInternalException {
        if (selector == null || "".equals(selector)) {
            throw new IllegalArgumentException("Cannot create a JMSSelectorFilter with a null or empty selector string");
        }
        this._selector = selector;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Created JMSSelectorFilter with selector:" + this._selector);
        }
        try {
            this._matcher = new SelectorParser().parse(selector);
        }
        catch (ParseException e) {
            throw new AMQInternalException("Unable to parse selector \"" + selector + "\"", (Throwable)e);
        }
        catch (SelectorParsingException e) {
            throw new AMQInternalException("Unable to parse selector \"" + selector + "\"", (Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new AMQInternalException("Unable to parse selector \"" + selector + "\"", (Throwable)e);
        }
    }

    @Override
    public boolean matches(AbstractJMSMessage message) {
        try {
            boolean match = this._matcher.matches(this.wrap(message));
            if (_logger.isDebugEnabled()) {
                _logger.debug(message + " match(" + match + ") selector(" + this._selector + "): " + this._selector);
            }
            return match;
        }
        catch (SelectorParsingException e) {
            _logger.warn("Caught exception when evaluating message selector for message  " + message, (Throwable)e);
            return false;
        }
    }

    private FilterableMessage wrap(final AbstractJMSMessage message) {
        return new FilterableMessage(){

            public boolean isPersistent() {
                try {
                    return message.getJMSDeliveryMode() == 2;
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public boolean isRedelivered() {
                try {
                    return message.getJMSRedelivered();
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public Object getHeader(String name) {
                try {
                    return message.getObjectProperty(name);
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public String getReplyTo() {
                return message.getReplyToString();
            }

            public String getType() {
                try {
                    return message.getJMSType();
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public byte getPriority() {
                try {
                    return (byte)message.getJMSPriority();
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public String getMessageId() {
                try {
                    return message.getJMSMessageID();
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public long getTimestamp() {
                try {
                    return message.getJMSTimestamp();
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public String getCorrelationId() {
                try {
                    return message.getJMSCorrelationID();
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }

            public long getExpiration() {
                try {
                    return message.getJMSExpiration();
                }
                catch (JMSException e) {
                    throw new SelectorParsingException((Throwable)e);
                }
            }
        };
    }

    @Override
    public String getSelector() {
        return this._selector;
    }
}

