/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.preferences;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.model.preferences.PreferenceValue;

public class QueryPreferenceValue
implements PreferenceValue {
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String CATEGORY_ATTRIBUTE = "category";
    public static final String SELECT_ATTRIBUTE = "select";
    public static final String WHERE_ATTRIBUTE = "where";
    public static final String ORDER_BY_ATTRIBUTE = "orderBy";
    public static final String DEFAULT_SCOPE = "";
    public static final String DEFAULT_CATEGORY = "queue";
    private final String _scope;
    private final String _category;
    private final String _select;
    private final String _where;
    private final String _orderBy;
    private final Map<String, Object> _originalAttributeMap;

    public QueryPreferenceValue(Map<String, Object> preferenceValueAttributes) {
        try {
            this._scope = this.getValue(preferenceValueAttributes, SCOPE_ATTRIBUTE, DEFAULT_SCOPE);
            this._category = this.getValue(preferenceValueAttributes, CATEGORY_ATTRIBUTE, DEFAULT_CATEGORY);
            this._select = this.getValue(preferenceValueAttributes, SELECT_ATTRIBUTE, null);
            this._where = this.getValue(preferenceValueAttributes, WHERE_ATTRIBUTE, null);
            this._orderBy = this.getValue(preferenceValueAttributes, ORDER_BY_ATTRIBUTE, null);
            this._originalAttributeMap = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(preferenceValueAttributes));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to create QueryPreference", e);
        }
    }

    public Map<String, Object> getAttributes() {
        return this._originalAttributeMap;
    }

    public String getScope() {
        return this._scope;
    }

    public String getCategory() {
        return this._category;
    }

    public String getSelect() {
        return this._select;
    }

    public String getWhere() {
        return this._where;
    }

    public String getOrderBy() {
        return this._orderBy;
    }

    private <T> T getValue(Map<String, Object> attributes, String attributeName, T defaultValue) {
        if (attributes.containsKey(attributeName)) {
            return (T)attributes.get(attributeName);
        }
        return defaultValue;
    }
}

