/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugin;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.qpid.server.License;
import org.apache.qpid.server.plugin.PluggableService;

public class PluggableProcessor
extends AbstractProcessor {
    private final Map<String, Set<String>> factoryImplementations = new HashMap<String, Set<String>>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(PluggableService.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateServiceFiles(this.processingEnv.getFiler());
            return true;
        }
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(PluggableService.class)) {
                if (element.getKind() != ElementKind.CLASS) continue;
                TypeElement classElement = (TypeElement)element;
                Set<String> pluggableTypes = this.getPluggableTypes(classElement);
                for (String pluggableType : pluggableTypes) {
                    Set<String> existingFactories = this.factoryImplementations.get(pluggableType);
                    if (existingFactories == null) {
                        existingFactories = new HashSet<String>();
                        this.factoryImplementations.put(pluggableType, existingFactories);
                    }
                    existingFactories.add(classElement.getQualifiedName().toString());
                }
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error: " + e.getLocalizedMessage());
        }
        return true;
    }

    private Set<String> getPluggableTypes(TypeElement classElement) {
        HashSet<String> types = new HashSet<String>();
        List<? extends TypeMirror> interfaces = classElement.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            TypeElement interfaceElt = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
            if (interfaceElt.getQualifiedName().toString().equals("org.apache.qpid.server.plugin.Pluggable")) {
                types.add(classElement.getQualifiedName().toString());
                continue;
            }
            types.addAll(this.getPluggableTypes(interfaceElt));
        }
        TypeMirror superClass = classElement.getSuperclass();
        if (!(superClass instanceof NoType)) {
            types.addAll(this.getPluggableTypes((TypeElement)this.processingEnv.getTypeUtils().asElement(superClass)));
        }
        return types;
    }

    private void generateServiceFiles(Filer filer) {
        for (String serviceName : this.factoryImplementations.keySet()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating service file for " + serviceName);
            String relativeName = "META-INF/services/" + serviceName;
            this.loadExistingServicesFile(filer, serviceName);
            try {
                FileObject serviceFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", relativeName, new Element[0]);
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(serviceFile.openOutputStream(), "UTF-8"));){
                    for (String headerLine : License.LICENSE) {
                        pw.println("#" + headerLine);
                    }
                    pw.println("#");
                    pw.println("# Note: Parts of this file are auto-generated from annotations.");
                    pw.println("#");
                    for (String implementation : this.factoryImplementations.get(serviceName)) {
                        pw.println(implementation);
                    }
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write services file: " + relativeName + " - " + e.getLocalizedMessage());
            }
        }
    }

    private String loadExistingServicesFile(Filer filer, String serviceName) {
        String relativeName = "META-INF/services/" + serviceName;
        try {
            FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", relativeName);
            try (BufferedReader r = new BufferedReader(new InputStreamReader(existingFile.openInputStream(), "UTF-8"));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.matches(" *#")) continue;
                    this.factoryImplementations.get(serviceName).add(line);
                }
            }
        }
        catch (FileNotFoundException | NoSuchFileException existingFile) {
        }
        catch (IOException e) {
            String errorMessage;
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                e.printStackTrace(pw);
                errorMessage = sw.toString();
            }
            catch (IOException ioe) {
                errorMessage = e.getLocalizedMessage();
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error loading existing services file: " + relativeName + " - " + errorMessage);
        }
        return relativeName;
    }
}

