/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.qpid.server.model.validation.AttributeAnnotationValidator;

@SupportedAnnotationTypes(value={"org.apache.qpid.server.model.ManagedOperation", "org.apache.qpid.server.model.Param"})
public class OperationAnnotationValidator
extends AbstractProcessor {
    public static final String MANAGED_OPERATION_CLASS_NAME = "org.apache.qpid.server.model.ManagedOperation";
    public static final String OPERATION_PARAM_CLASS_NAME = "org.apache.qpid.server.model.Param";
    private static final Set<TypeKind> VALID_PRIMITIVE_TYPES = new HashSet<TypeKind>(Arrays.asList(TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(MANAGED_OPERATION_CLASS_NAME);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            this.checkAnnotationIsOnMethodInInterface(annotationElement, element);
            ExecutableElement methodElement = (ExecutableElement)element;
            this.checkInterfaceExtendsConfiguredObject(annotationElement, methodElement);
            this.checkMethodArgsAreValid(annotationElement, methodElement);
            this.checkMethodReturnType(annotationElement, methodElement);
        }
        return false;
    }

    public void checkMethodReturnType(TypeElement annotationElement, ExecutableElement methodElement) {
        TypeMirror returnType = methodElement.getReturnType();
        if (returnType.getKind() != TypeKind.VOID && !this.isValidType(returnType, true)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " cannot be applied to methods with return type " + returnType.toString(), methodElement);
        }
    }

    public void checkMethodArgsAreValid(TypeElement annotationElement, ExecutableElement methodElement) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement paramElement = elementUtils.getTypeElement(OPERATION_PARAM_CLASS_NAME);
        for (VariableElement variableElement : methodElement.getParameters()) {
            if (!this.isValidType(variableElement.asType(), false)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(paramElement.getSimpleName()) + " cannot be applied to variables of type " + variableElement.asType().toString(), methodElement);
            }
            String name = variableElement.getSimpleName().toString();
            List<? extends AnnotationMirror> annotationMirrors = variableElement.getAnnotationMirrors();
            AnnotationMirror paramAnnotation = null;
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!annotationMirror.getAnnotationType().asElement().equals(paramElement)) continue;
                paramAnnotation = annotationMirror;
                break;
            }
            if (paramAnnotation == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Argument " + name + " of " + String.valueOf(methodElement.getSimpleName()) + " must be annotated with @" + String.valueOf(paramElement.getSimpleName()) + " or the method should not be annotated with @" + String.valueOf(annotationElement.getSimpleName()));
                continue;
            }
            String paramName = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : paramAnnotation.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("name")) continue;
                paramName = String.valueOf(entry.getValue().getValue());
            }
            if (name.equals(paramName)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Argument " + name + " of " + String.valueOf(methodElement.getSimpleName()) + " is annotated with @" + String.valueOf(paramElement.getSimpleName()) + "( name = \"" + paramName + "\") the name must match the actual parameter name, i.e. it should read @" + String.valueOf(paramElement.getSimpleName()) + "( name = \"" + name + "\")");
        }
    }

    public void checkInterfaceExtendsConfiguredObject(TypeElement annotationElement, Element e) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror configuredObjectType = this.getErasure("org.apache.qpid.server.model.ConfiguredObject");
        TypeElement parent = (TypeElement)e.getEnclosingElement();
        if (!typeUtils.isAssignable(typeUtils.erasure(parent.asType()), configuredObjectType)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods within an interface which extends " + configuredObjectType.toString() + " which does not apply to " + parent.asType().toString(), e);
        }
    }

    public void checkAnnotationIsOnMethodInInterface(TypeElement annotationElement, Element e) {
        if (e.getKind() != ElementKind.METHOD || e.getEnclosingElement().getKind() != ElementKind.INTERFACE) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods within an interface", e);
        }
    }

    boolean isValidType(TypeMirror type, boolean allowAbstractManagedTypes) {
        return AttributeAnnotationValidator.isValidType(this.processingEnv, type, allowAbstractManagedTypes);
    }

    private TypeMirror getErasure(String className) {
        return OperationAnnotationValidator.getErasure(this.processingEnv, className);
    }

    private static TypeMirror getErasure(ProcessingEnvironment processingEnv, String className) {
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        return typeUtils.erasure(elementUtils.getTypeElement(className).asType());
    }
}

