/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.apache.qpid.server.model.validation.AttributeAnnotationValidator;

@SupportedAnnotationTypes(value={"org.apache.qpid.server.model.ManagedAttributeValueType"})
public class ManagedAttributeValueTypeValidator
extends AbstractProcessor {
    public static final String MANAGED_ATTRIBUTE_VALUE_TYPE_CLASS_NAME = "org.apache.qpid.server.model.ManagedAttributeValueType";
    public static final String MANAGED_ATTRIBUTE_VALUE_CLASS_NAME = "org.apache.qpid.server.model.ManagedAttributeValue";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(MANAGED_ATTRIBUTE_VALUE_TYPE_CLASS_NAME);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            boolean isAbstract = this.isAbstract(annotationElement, element);
            if (!isAbstract) {
                this.checkAnnotationIsOnInterface(annotationElement, element);
            }
            if (this.isContent(element)) continue;
            this.checkAllMethodsAreAccessors(element, isAbstract);
        }
        return false;
    }

    private boolean isContent(Element e) {
        return e.equals(this.processingEnv.getElementUtils().getTypeElement("org.apache.qpid.server.model.Content"));
    }

    private void checkAllMethodsAreAccessors(Element e, boolean isAbstract) {
        this.checkAllMethodsAreAccessors(e, new HashSet<Element>(), isAbstract);
    }

    private void checkAllMethodsAreAccessors(Element e, Set<Element> checked, boolean isAbstract) {
        if (!checked.add(e)) {
            return;
        }
        Name annotationName = this.processingEnv.getElementUtils().getTypeElement(MANAGED_ATTRIBUTE_VALUE_TYPE_CLASS_NAME).getSimpleName();
        for (Element element : e.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            AttributeAnnotationValidator.isValidType(this.processingEnv, executableElement.getReturnType(), false);
            if (!this.isNotAccessorMethod(executableElement) || this.isValidFactoryMethod(executableElement, e, isAbstract) || executableElement.getKind() == ElementKind.CONSTRUCTOR) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Methods in an @" + String.valueOf(annotationName) + " interface can only be applied to methods which of the form getXXX(), isXXX() or hasXXX()", executableElement);
        }
        List<? extends TypeMirror> interfaces = ((TypeElement)e).getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            this.checkAllMethodsAreAccessors(this.processingEnv.getTypeUtils().asElement(typeMirror), checked, isAbstract);
        }
    }

    private boolean isNotAccessorMethod(ExecutableElement methodElement) {
        String methodName = methodElement.getSimpleName().toString();
        return methodName.length() < 3 || methodName.length() < 4 && !methodName.startsWith("is") || !methodName.startsWith("is") && !methodName.startsWith("get") && !methodName.startsWith("has") || !methodElement.getTypeParameters().isEmpty();
    }

    private boolean isValidFactoryMethod(ExecutableElement methodElement, Element typeElement, boolean isAbstract) {
        if (!isAbstract && methodElement.getSimpleName().toString().equals("newInstance") && methodElement.getModifiers().contains((Object)Modifier.STATIC) && this.processingEnv.getTypeUtils().asElement(methodElement.getReturnType()) != null && this.processingEnv.getTypeUtils().asElement(methodElement.getReturnType()).equals(typeElement) && methodElement.getParameters().size() == 1 && this.processingEnv.getTypeUtils().asElement(methodElement.getParameters().iterator().next().asType()).equals(typeElement)) {
            TypeElement annotationElement = this.processingEnv.getElementUtils().getTypeElement("org.apache.qpid.server.model.ManagedAttributeValueTypeFactoryMethod");
            return methodElement.getAnnotationMirrors().stream().anyMatch(a -> this.processingEnv.getTypeUtils().isSameType(a.getAnnotationType(), annotationElement.asType()));
        }
        return false;
    }

    private void checkAnnotationIsOnInterface(TypeElement annotationElement, Element e) {
        if (e.getKind() != ElementKind.INTERFACE) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to an interface", e);
        }
        if (!this.processingEnv.getTypeUtils().isAssignable(e.asType(), this.processingEnv.getElementUtils().getTypeElement(MANAGED_ATTRIBUTE_VALUE_CLASS_NAME).asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to an interface which extends org.apache.qpid.server.model.ManagedAttributeValue", e);
        }
    }

    private boolean isAbstract(TypeElement annotationElement, Element typeElement) {
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().equals(annotationElement)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> element : annotationValues.entrySet()) {
                if (!"isAbstract".contentEquals(element.getKey().getSimpleName())) continue;
                return element.getValue().getValue().equals(Boolean.TRUE);
            }
        }
        return false;
    }
}

