/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.BlockAwareSegmentInputStreamImpl;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.StreamingDataBlockHeaderImpl;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedOffloadStream
extends InputStream {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BufferedOffloadStream.class);
    static final int[] BLOCK_END_PADDING = BlockAwareSegmentInputStreamImpl.BLOCK_END_PADDING;
    private final long ledgerId;
    private final long beginEntryId;
    private volatile long endEntryId;
    static final int ENTRY_HEADER_SIZE = 12;
    private final long blockSize;
    private final List<Entry> entryBuffer;
    private final InputStream blockHead;
    int offset = 0;
    static final int NOT_INITIALIZED = -1;
    int validDataOffset = -1;
    CompositeByteBuf currentEntry;

    public BufferedOffloadStream(int blockSize, List<Entry> entries, long ledgerId, long beginEntryId) {
        this.ledgerId = ledgerId;
        this.beginEntryId = beginEntryId;
        this.endEntryId = beginEntryId;
        this.blockSize = blockSize;
        this.entryBuffer = entries;
        this.blockHead = StreamingDataBlockHeaderImpl.of(blockSize, ledgerId, beginEntryId).toStream();
    }

    public long getEndEntryId() {
        return this.endEntryId;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getBeginEntryId() {
        return this.beginEntryId;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int read() throws IOException {
        if (this.blockHead.available() > 0) {
            ++this.offset;
            return this.blockHead.read();
        }
        if (this.currentEntry != null) {
            if (this.currentEntry.readableBytes() > 0) {
                ++this.offset;
                return this.currentEntry.readUnsignedByte();
            }
            this.currentEntry.release();
            this.currentEntry = null;
        }
        if (this.blockSize <= (long)this.offset) {
            return -1;
        }
        if (this.validDataOffset != -1) {
            return BLOCK_END_PADDING[(this.offset++ - this.validDataOffset) % BLOCK_END_PADDING.length];
        }
        if (this.entryBuffer.isEmpty()) {
            this.validDataOffset = this.offset;
            return this.read();
        }
        Entry headEntry = this.entryBuffer.remove(0);
        if (headEntry.getLedgerId() != this.ledgerId) {
            throw new RuntimeException(String.format("there should not be multi ledger in a block %s %s", headEntry.getLedgerId(), this.ledgerId));
        }
        int entryLength = headEntry.getLength();
        long entryId = headEntry.getEntryId();
        CompositeByteBuf entryBuf = PulsarByteBufAllocator.DEFAULT.compositeBuffer(2);
        ByteBuf entryHeaderBuf = PulsarByteBufAllocator.DEFAULT.buffer(12, 12);
        entryHeaderBuf.writeInt(entryLength).writeLong(entryId);
        entryBuf.addComponents(true, new ByteBuf[]{entryHeaderBuf, headEntry.getDataBuffer().retain()});
        this.endEntryId = headEntry.getEntryId();
        headEntry.release();
        this.currentEntry = entryBuf;
        return this.read();
    }

    @Override
    public void close() throws IOException {
        this.blockHead.close();
    }

    public static int calculateBlockSize(int streamingBlockSize, int entryCount, int entrySize) {
        int validDataSize = entryCount * 12 + entrySize + StreamingDataBlockHeaderImpl.getDataStartOffset();
        return Math.max(streamingBlockSize, validDataSize);
    }
}

