/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.GeneralSecurityException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.client.PulsarMockReadHandle;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarMockLedgerHandle
extends LedgerHandle {
    final List<LedgerEntryImpl> entries = Collections.synchronizedList(new ArrayList());
    final PulsarMockBookKeeper bk;
    final long id;
    final BookKeeper.DigestType digest;
    final byte[] passwd;
    final ReadHandle readHandle;
    long lastEntry = -1L;
    @VisibleForTesting
    boolean fenced = false;
    final AtomicLong totalLengthCounter = new AtomicLong(0L);
    private static final Logger log = LoggerFactory.getLogger(PulsarMockLedgerHandle.class);

    public PulsarMockLedgerHandle(PulsarMockBookKeeper bk, long id, BookKeeper.DigestType digest, byte[] passwd) throws GeneralSecurityException {
        super(bk.getClientCtx(), id, new Versioned((Object)PulsarMockLedgerHandle.createMetadata(id, digest, passwd), (Version)new LongVersion(0L)), digest, passwd, WriteFlag.NONE);
        this.bk = bk;
        this.id = id;
        this.digest = digest;
        this.passwd = Arrays.copyOf(passwd, passwd.length);
        this.readHandle = new PulsarMockReadHandle(bk, id, this.getLedgerMetadata(), this.entries, bk::getReadHandleInterceptor, this.totalLengthCounter);
    }

    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) {
        ((CompletableFuture)this.bk.getProgrammedFailure().thenComposeAsync(res -> {
            this.fenced = true;
            Versioned current = this.getVersionedLedgerMetadata();
            Versioned newMetadata = new Versioned((Object)LedgerMetadataBuilder.from((LedgerMetadata)((LedgerMetadata)current.getValue())).withClosedState().withLastEntryId(this.getLastAddConfirmed()).withLength(this.getLength()).build(), (Version)new LongVersion(((LongVersion)current.getVersion()).getLongVersion() + 1L));
            this.setLedgerMetadata(current, newMetadata);
            return FutureUtils.value(null);
        }, (Executor)this.bk.executor)).whenCompleteAsync((res, exception) -> {
            if (exception != null) {
                cb.closeComplete(PulsarMockBookKeeper.getExceptionCode(exception), null, ctx);
            } else {
                cb.closeComplete(0, (LedgerHandle)this, ctx);
            }
        }, (Executor)this.bk.executor);
    }

    public void asyncReadEntries(long firstEntry, long lastEntry, AsyncCallback.ReadCallback cb, Object ctx) {
        ((CompletableFuture)this.bk.getProgrammedFailure().thenComposeAsync(res -> {
            log.debug("readEntries: first={} last={} total={}", new Object[]{firstEntry, lastEntry, this.entries.size()});
            final ArrayDeque<LedgerEntry> seq = new ArrayDeque<LedgerEntry>();
            long entryId = firstEntry;
            while (entryId <= lastEntry && entryId < (long)this.entries.size()) {
                seq.add(new LedgerEntry(this.entries.get((int)entryId++).duplicate()));
            }
            log.debug("Entries read: {}", seq);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Enumeration<LedgerEntry> entries = new Enumeration<LedgerEntry>(){

                @Override
                public boolean hasMoreElements() {
                    return !seq.isEmpty();
                }

                @Override
                public LedgerEntry nextElement() {
                    return (LedgerEntry)seq.remove();
                }
            };
            return FutureUtils.value((Object)entries);
        })).whenCompleteAsync((res, exception) -> {
            if (exception != null) {
                cb.readComplete(PulsarMockBookKeeper.getExceptionCode(exception), (LedgerHandle)this, null, ctx);
            } else {
                cb.readComplete(0, (LedgerHandle)this, res, ctx);
            }
        }, (Executor)this.bk.executor);
    }

    public long addEntry(byte[] data) throws InterruptedException, BKException {
        try {
            this.bk.checkProgrammedFail();
        }
        catch (BKException e) {
            this.fenced = true;
            throw e;
        }
        if (this.fenced) {
            throw BKException.create((int)-101);
        }
        this.lastEntry = this.entries.size();
        this.totalLengthCounter.addAndGet(data.length);
        this.entries.add(LedgerEntryImpl.create((long)this.ledgerId, (long)this.lastEntry, (long)data.length, (ByteBuf)Unpooled.wrappedBuffer((byte[])data)));
        return this.lastEntry;
    }

    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, cb, ctx);
    }

    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length), cb, ctx);
    }

    public void asyncAddEntry(ByteBuf data, AsyncCallback.AddCallback cb, Object ctx) {
        ((CompletableFuture)this.bk.getAddEntryFailure().thenComposeAsync(res -> {
            Long delayMillis = this.bk.addEntryDelaysMillis.poll();
            if (delayMillis == null) {
                delayMillis = 1L;
            }
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.fenced) {
                return FutureUtils.exception((Throwable)new BKException.BKLedgerFencedException());
            }
            this.lastEntry = this.entries.size();
            byte[] storedData = new byte[data.readableBytes()];
            data.readBytes(storedData);
            this.totalLengthCounter.addAndGet(storedData.length);
            this.entries.add(LedgerEntryImpl.create((long)this.ledgerId, (long)this.lastEntry, (long)storedData.length, (ByteBuf)Unpooled.wrappedBuffer((byte[])storedData)));
            return FutureUtils.value((Object)this.lastEntry);
        }, (Executor)this.bk.executor)).whenCompleteAsync((entryId, exception) -> {
            data.release();
            if (exception != null) {
                this.fenced = true;
                cb.addComplete(PulsarMockBookKeeper.getExceptionCode(exception), (LedgerHandle)this, -1L, ctx);
            } else {
                Long responseDelayMillis = this.bk.addEntryResponseDelaysMillis.poll();
                if (responseDelayMillis != null) {
                    try {
                        Thread.sleep(responseDelayMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                cb.addComplete(0, (LedgerHandle)this, entryId.longValue(), ctx);
            }
        }, (Executor)this.bk.executor);
    }

    public long getId() {
        return this.ledgerId;
    }

    public long getLastAddConfirmed() {
        if (this.bk.checkReturnEmptyLedger()) {
            return -1L;
        }
        return this.lastEntry;
    }

    public long getLength() {
        return this.totalLengthCounter.get();
    }

    public CompletableFuture<LedgerEntries> readAsync(long firstEntry, long lastEntry) {
        return this.readHandle.readAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<LedgerEntries> readUnconfirmedAsync(long firstEntry, long lastEntry) {
        return this.readHandle.readUnconfirmedAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<Long> readLastAddConfirmedAsync() {
        return this.readHandle.readLastAddConfirmedAsync();
    }

    public CompletableFuture<Long> tryReadLastAddConfirmedAsync() {
        return this.readHandle.tryReadLastAddConfirmedAsync();
    }

    public boolean isClosed() {
        return this.readHandle.isClosed();
    }

    public CompletableFuture<LastConfirmedAndEntry> readLastAddConfirmedAndEntryAsync(long entryId, long timeOutInMillis, boolean parallel) {
        return this.readHandle.readLastAddConfirmedAndEntryAsync(entryId, timeOutInMillis, parallel);
    }

    private static LedgerMetadata createMetadata(long id, BookKeeper.DigestType digest, byte[] passwd) {
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>(PulsarMockBookKeeper.getMockEnsemble());
        return LedgerMetadataBuilder.create().withDigestType(digest.toApiDigestType()).withPassword(passwd).withId(id).newEnsembleEntry(0L, ensemble).build();
    }

    @Generated
    public boolean isFenced() {
        return this.fenced;
    }
}

