/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.common.configuration.Category;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.configuration.PropertiesContext;
import org.apache.pulsar.common.configuration.PropertyContext;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.DefaultPulsarSslFactory;

public class ProxyConfiguration
implements PulsarConfiguration {
    @Category
    private static final String CATEGORY_SERVER = "Server";
    @Category
    private static final String CATEGORY_BROKER_DISCOVERY = "Broker Discovery";
    @Category
    private static final String CATEGORY_BROKER_PROXY = "Broker Proxy";
    @Category
    private static final String CATEGORY_AUTHENTICATION = "Proxy Authentication";
    @Category
    private static final String CATEGORY_AUTHORIZATION = "Proxy Authorization";
    @Category(description="the settings are for configuring how proxies authenticates with Pulsar brokers")
    private static final String CATEGORY_CLIENT_AUTHENTICATION = "Broker Client Authorization";
    @Category
    private static final String CATEGORY_RATE_LIMITING = "RateLimiting";
    @Category
    private static final String CATEGORY_TLS = "TLS";
    @Category
    private static final String CATEGORY_KEYSTORE_TLS = "KeyStoreTLS";
    @Category
    private static final String CATEGORY_TOKEN_AUTH = "Token Authentication Provider";
    @Category
    private static final String CATEGORY_HTTP = "HTTP";
    @Category
    private static final String CATEGORY_SASL_AUTH = "SASL Authentication Provider";
    @Category
    private static final String CATEGORY_PLUGIN = "proxy plugin";
    @Category
    private static final String CATEGORY_WEBSOCKET = "WebSocket";
    @FieldContext(category="Broker Discovery", deprecated=true, doc="The ZooKeeper quorum connection string (as a comma-separated list)")
    @Deprecated
    private String zookeeperServers;
    @FieldContext(category="Broker Discovery", required=false, doc="The metadata store URL. \n Examples: \n  * zk:my-zk-1:2181,my-zk-2:2181,my-zk-3:2181\n  * my-zk-1:2181,my-zk-2:2181,my-zk-3:2181 (will default to ZooKeeper when the schema is not specified)\n  * zk:my-zk-1:2181,my-zk-2:2181,my-zk-3:2181/my-chroot-path (to add a ZK chroot path)\n")
    private String metadataStoreUrl;
    @FieldContext(category="Broker Discovery", deprecated=true, doc="Configuration store connection string (as a comma-separated list). Deprecated in favor of `configurationMetadataStoreUrl`")
    @Deprecated
    private String configurationStoreServers;
    @FieldContext(category="Broker Discovery", deprecated=true, doc="Global ZooKeeper quorum connection string (as a comma-separated list)")
    @Deprecated
    private String globalZookeeperServers;
    @FieldContext(category="Broker Discovery", required=false, doc="The metadata store URL for the configuration data. If empty, we fall back to use metadataStoreUrl")
    private String configurationMetadataStoreUrl;
    @FieldContext(category="Server", doc="Metadata store session timeout in milliseconds.")
    private int metadataStoreSessionTimeoutMillis = 30000;
    @FieldContext(category="Server", doc="Metadata store cache expiry time in seconds.")
    private int metadataStoreCacheExpirySeconds = 300;
    @FieldContext(category="Server", doc="Is metadata store read-only operations.")
    private boolean metadataStoreAllowReadOnlyOperations;
    @FieldContext(category="Server", doc="Max size of messages.", maxValue=0x7FFFD7FFL)
    private int maxMessageSize = 0x500000;
    @Deprecated
    @FieldContext(category="Broker Discovery", deprecated=true, doc="ZooKeeper session timeout in milliseconds. @deprecated - Use metadataStoreSessionTimeoutMillis instead.")
    private int zookeeperSessionTimeoutMs = -1;
    @Deprecated
    @FieldContext(category="Broker Discovery", deprecated=true, doc="ZooKeeper cache expiry time in seconds. @deprecated - Use metadataStoreCacheExpirySeconds instead.")
    private int zooKeeperCacheExpirySeconds = -1;
    @Deprecated
    @FieldContext(category="Server", deprecated=true, doc="Is zooKeeper allow read-only operations.")
    private boolean zooKeeperAllowReadOnlyOperations;
    @FieldContext(category="Broker Discovery", doc="If does not set metadataStoreUrl or configurationMetadataStoreUrl, this url should point to the discovery service provider. URL must have the pulsar:// prefix. And does not support multi url yet.")
    private String brokerServiceURL;
    @FieldContext(category="Broker Discovery", doc="If does not set metadataStoreUrl or configurationMetadataStoreUrl, this url should point to the discovery service provider. URL must have the pulsar+ssl:// prefix. And does not support multi url yet.")
    private String brokerServiceURLTLS;
    @FieldContext(category="Broker Discovery", doc="The web service url points to the discovery service provider of the broker cluster, and does not support multi url yet.")
    private String brokerWebServiceURL;
    @FieldContext(category="Broker Discovery", doc="The tls web service url points to the discovery service provider of the broker cluster, and does not support multi url yet.")
    private String brokerWebServiceURLTLS;
    @FieldContext(category="Broker Discovery", doc="The web service url points to the discovery service provider of the function worker cluster, and does not support multi url yet. Only configure it when you setup function workers in a separate cluster")
    private String functionWorkerWebServiceURL;
    @FieldContext(category="Broker Discovery", doc="The tls web service url points to the discovery service provider of the function worker cluster, and does not support multi url yet. Only configure it when you setup function workers in a separate cluster")
    private String functionWorkerWebServiceURLTLS;
    @FieldContext(category="Broker Proxy", doc="When enabled, checks that the target broker is active before connecting. zookeeperServers and configurationStoreServers must be configured in proxy configuration for retrieving the active brokers.")
    private boolean checkActiveBrokers = false;
    @FieldContext(category="Broker Proxy", doc="Broker proxy connect timeout.\nThe timeout value for Broker proxy connect timeout is in millisecond. Set to 0 to disable.")
    private int brokerProxyConnectTimeoutMs = 10000;
    @FieldContext(category="Broker Proxy", doc="Broker proxy read timeout.\nThe timeout value for Broker proxy read timeout is in millisecond. Set to 0 to disable.")
    private int brokerProxyReadTimeoutMs = 75000;
    @FieldContext(category="Broker Proxy", doc="Allowed broker target host names. Supports multiple comma separated entries and a wildcard.")
    private String brokerProxyAllowedHostNames = "*";
    @FieldContext(category="Broker Proxy", doc="Allowed broker target ip addresses or ip networks / netmasks. Supports multiple comma separated entries.")
    private String brokerProxyAllowedIPAddresses = "*";
    @FieldContext(category="Broker Proxy", doc="Allowed broker target ports")
    private String brokerProxyAllowedTargetPorts = "6650,6651";
    @FieldContext(category="Server", doc="Hostname or IP address the service binds on")
    private String bindAddress = "0.0.0.0";
    @FieldContext(category="Server", doc="Hostname or IP address the service advertises to the outside world. If not set, the value of `InetAddress.getLocalHost().getCanonicalHostName()` is used.")
    private String advertisedAddress;
    @FieldContext(category="Server", doc="Specifies the interval (in seconds) for sending ping messages to the client. Set to 0 to disable ping messages. This setting applies to client connections used for topic lookups and partition metadata requests. When a client establishes a broker connection via the proxy, the client and broker will communicate directly without the proxy intercepting the messages. In that case, the broker's keepAliveIntervalSeconds configuration becomes relevant.")
    private int keepAliveIntervalSeconds = 30;
    @FieldContext(category="Server", doc="Enable or disable the proxy protocol.")
    private boolean haProxyProtocolEnabled;
    @FieldContext(category="Server", doc="Enable or disable the use of HA proxy protocol for resolving the client IP for http/https requests. Default is false.")
    private boolean webServiceHaProxyProtocolEnabled = false;
    @FieldContext(category="Server", doc="Trust X-Forwarded-For header for resolving the client IP for http/https requests.\nDefault is false.")
    private boolean webServiceTrustXForwardedFor = false;
    @FieldContext(category="Server", doc="Add detailed client/remote and server/local addresses and ports to http/https request logging.\nDefaults to true when either webServiceHaProxyProtocolEnabled or webServiceTrustXForwardedFor is enabled.")
    private Boolean webServiceLogDetailedAddresses;
    @FieldContext(category="Server", doc="Defines how the broker will anonymize the role and originalAuthRole before logging. Possible values are: NONE (no anonymization), REDACTED (replaces with '[REDACTED]'), hash:SHA256 (hashes using SHA-256), and hash:MD5 (hashes using MD5). Default is NONE.")
    private String authenticationRoleLoggingAnonymizer = "NONE";
    @FieldContext(category="Server", doc="Enables zero-copy transport of data across network interfaces using the spice. Zero copy mode cannot be used when TLS is enabled or when proxyLogLevel is > 0.")
    private boolean proxyZeroCopyModeEnabled = true;
    @FieldContext(category="Server", doc="The port for serving binary protobuf request")
    private Optional<Integer> servicePort = Optional.ofNullable(6650);
    @FieldContext(category="Server", doc="The port for serving tls secured binary protobuf request")
    private Optional<Integer> servicePortTls = Optional.empty();
    @FieldContext(category="Server", doc="The port for serving http requests")
    private Optional<Integer> webServicePort = Optional.ofNullable(8080);
    @FieldContext(category="Server", doc="The port for serving https requests")
    private Optional<Integer> webServicePortTls = Optional.empty();
    @FieldContext(category="KeyStoreTLS", doc="Specify the TLS provider for the web service, available values can be SunJSSE, Conscrypt and etc.")
    private String webServiceTlsProvider = "Conscrypt";
    @FieldContext(category="TLS", doc="Specify the tls protocols the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLSv1.3, TLSv1.2]")
    private Set<String> webServiceTlsProtocols = new TreeSet<String>();
    @FieldContext(category="TLS", doc="Specify the tls cipher the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> webServiceTlsCiphers = new TreeSet<String>();
    @FieldContext(category="Server", doc="The directory where nar Extraction happens")
    private String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
    @FieldContext(category="Server", doc="Proxy log level, default is 0. 0: Do not log any tcp channel info 1: Parse and log any tcp channel info and command info without message body 2: Parse and log channel info, command info and message body")
    private Optional<Integer> proxyLogLevel = Optional.ofNullable(0);
    @FieldContext(category="Server", doc="Path for the file used to determine the rotation status for the proxy instance when responding to service discovery health checks")
    private String statusFilePath;
    @FieldContext(category="Proxy Authorization", doc="A list of role names (a comma-separated list of strings) that are treated as `super-user`, meaning they will be able to do all admin operations and publish & consume from all topics")
    private Set<String> superUserRoles = new TreeSet<String>();
    @FieldContext(category="Proxy Authentication", doc="Whether authentication is enabled for the Pulsar proxy")
    private boolean authenticationEnabled = false;
    @FieldContext(category="Proxy Authentication", doc="Authentication provider name list (a comma-separated list of class names")
    private Set<String> authenticationProviders = new TreeSet<String>();
    @FieldContext(category="Proxy Authorization", doc="Whether authorization is enforced by the Pulsar proxy")
    private boolean authorizationEnabled = false;
    @FieldContext(category="Proxy Authorization", doc="Authorization provider as a fully qualified class name")
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @FieldContext(category="Proxy Authorization", doc="Whether client authorization credentials are forwarded to the broker for re-authorization.Authentication must be enabled via configuring `authenticationEnabled` to be true for thisto take effect")
    private boolean forwardAuthorizationCredentials = false;
    @FieldContext(category="Proxy Authentication", doc="Interval of time for checking for expired authentication credentials. Disable by setting to 0.")
    private int authenticationRefreshCheckSeconds = 60;
    @FieldContext(category="HTTP", doc="Whether to enable the proxy's /metrics and /proxy-stats http endpoints")
    private boolean enableProxyStatsEndpoints = true;
    @FieldContext(category="Proxy Authentication", doc="Whether the '/metrics' endpoint requires authentication. Defaults to true.'authenticationEnabled' must also be set for this to take effect.")
    private boolean authenticateMetricsEndpoint = true;
    @FieldContext(category="HTTP", doc="Time in milliseconds that metrics endpoint would time out. Default is 30s.\n Set it to 0 to disable timeout.")
    private long metricsServletTimeoutMs = 30000L;
    @FieldContext(category="SASL Authentication Provider", doc="This is a regexp, which limits the range of possible ids which can connect to the Broker using SASL.\n Default value is: \".*pulsar.*\", so only clients whose id contains 'pulsar' are allowed to connect.")
    private String saslJaasClientAllowedIds = ".*pulsar.*";
    @FieldContext(category="SASL Authentication Provider", doc="Service Principal, for login context name. Default value is \"PulsarProxy\".")
    private String saslJaasServerSectionName = "PulsarProxy";
    @FieldContext(category="SASL Authentication Provider", doc="Path to file containing the secret to be used to SaslRoleTokenSigner\nThe secret can be specified like:\nsaslJaasServerRoleTokenSignerSecretPath=file:///my/saslRoleTokenSignerSecret.key.")
    private String saslJaasServerRoleTokenSignerSecretPath;
    @FieldContext(category="SASL Authentication Provider", doc="kerberos kinit command.")
    private String kinitCommand = "/usr/bin/kinit";
    @FieldContext(category="RateLimiting", doc="Max concurrent inbound connections. The proxy will reject requests beyond that")
    private int maxConcurrentInboundConnections = 10000;
    @FieldContext(category="RateLimiting", doc="The maximum number of connections per IP. If it exceeds, new connections are rejected.")
    private int maxConcurrentInboundConnectionsPerIp = 0;
    @FieldContext(category="RateLimiting", doc="Max concurrent lookup requests. The proxy will reject requests beyond that")
    private int maxConcurrentLookupRequests = 50000;
    @FieldContext(category="RateLimiting", doc="Maximum heap memory for inflight topic list operations (MB).\nDefault: 100 MB (supports ~1M topic names assuming 100 bytes each)")
    private int maxTopicListInFlightHeapMemSizeMB = 100;
    @FieldContext(category="RateLimiting", doc="Maximum direct memory for inflight topic list responses (MB).\nDefault: 100 MB (network buffers for serialized responses)")
    private int maxTopicListInFlightDirectMemSizeMB = 100;
    @FieldContext(category="RateLimiting", doc="Timeout for acquiring heap memory permits (milliseconds).\nDefault: 25000 (25 seconds)")
    private int maxTopicListInFlightHeapMemSizePermitsAcquireTimeoutMillis = 25000;
    @FieldContext(category="RateLimiting", doc="Maximum queue size for heap memory permit requests.\nDefault: 10000 (prevent unbounded queueing)")
    private int maxTopicListInFlightHeapMemSizePermitsAcquireQueueSize = 10000;
    @FieldContext(category="RateLimiting", doc="Timeout for acquiring direct memory permits (milliseconds).\nDefault: 25000 (25 seconds)")
    private int maxTopicListInFlightDirectMemSizePermitsAcquireTimeoutMillis = 25000;
    @FieldContext(category="RateLimiting", doc="Maximum queue size for direct memory permit requests.\nDefault: 10000 (prevent unbounded queueing)")
    private int maxTopicListInFlightDirectMemSizePermitsAcquireQueueSize = 10000;
    @FieldContext(category="Broker Client Authorization", doc="The authentication plugin used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientAuthenticationPlugin;
    @FieldContext(category="Broker Client Authorization", doc="The authentication parameters used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientAuthenticationParameters;
    @FieldContext(category="Broker Client Authorization", doc="The path to trusted certificates used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTrustCertsFilePath;
    @FieldContext(category="Broker Client Authorization", doc="The path to TLS private key used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientKeyFilePath;
    @FieldContext(category="Broker Client Authorization", doc="The path to the TLS certificate used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientCertificateFilePath;
    @FieldContext(category="Broker Client Authorization", doc="Whether TLS is enabled when communicating with Pulsar brokers")
    private boolean tlsEnabledWithBroker = false;
    @FieldContext(category="Proxy Authorization", doc="When this parameter is not empty, unauthenticated users perform as anonymousUserRole")
    private String anonymousUserRole = null;
    @Deprecated
    private boolean tlsEnabledInProxy = false;
    @FieldContext(category="TLS", doc="Tls cert refresh duration in seconds (set 0 to check on every new connection)")
    private long tlsCertRefreshCheckDurationSec = 300L;
    @FieldContext(category="TLS", doc="Path for the TLS certificate file")
    private String tlsCertificateFilePath;
    @FieldContext(category="TLS", doc="Path for the TLS private key file")
    private String tlsKeyFilePath;
    @FieldContext(category="TLS", doc="Path for the trusted TLS certificate file.\n\nThis cert is used to verify that any certs presented by connecting clients are signed by a certificate authority. If this verification fails, then the certs are untrusted and the connections are dropped")
    private String tlsTrustCertsFilePath;
    @FieldContext(category="TLS", doc="Accept untrusted TLS certificate from client.\n\nIf true, a client with a cert which cannot be verified with the `tlsTrustCertsFilePath` cert will be allowed to connect to the server, though the cert will not be used for client authentication")
    private boolean tlsAllowInsecureConnection = false;
    @FieldContext(category="TLS", doc="Whether the hostname is validated when the proxy creates a TLS connection with brokers")
    private boolean tlsHostnameVerificationEnabled = false;
    @FieldContext(category="TLS", doc="Specify the tls protocols the broker will use to negotiate during TLS handshake (a comma-separated list of protocol names).\n\nExamples:- [TLSv1.3, TLSv1.2]")
    private Set<String> tlsProtocols = new TreeSet<String>();
    @FieldContext(category="TLS", doc="Specify the tls cipher the proxy will use to negotiate during TLS Handshake (a comma-separated list of ciphers).\n\nExamples:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> tlsCiphers = new TreeSet<String>();
    @FieldContext(category="TLS", doc="Whether client certificates are required for TLS.\n\n Connections are rejected if the client certificate isn't trusted")
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    @FieldContext(category="KeyStoreTLS", doc="Enable TLS with KeyStore type configuration for proxy")
    private boolean tlsEnabledWithKeyStore = false;
    @FieldContext(category="KeyStoreTLS", doc="Specify the TLS provider for the broker service: \nWhen using TLS authentication with CACert, the valid value is either OPENSSL or JDK.\nWhen using TLS authentication with KeyStore, available values can be SunJSSE, Conscrypt and etc.")
    private String tlsProvider = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore type configuration for proxy: JKS, PKCS12")
    private String tlsKeyStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore path for proxy")
    private String tlsKeyStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore password for proxy")
    private String tlsKeyStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore type configuration for proxy: JKS, PKCS12")
    private String tlsTrustStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore path for proxy")
    private String tlsTrustStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore password for proxy, null means empty password.")
    private String tlsTrustStorePassword = null;
    @FieldContext(category="TLS", doc="SSL Factory Plugin class to provide SSLEngine and SSLContext objects. The default  class used is DefaultSslFactory.")
    private String sslFactoryPlugin = DefaultPulsarSslFactory.class.getName();
    @FieldContext(category="TLS", doc="SSL Factory plugin configuration parameters.")
    private String sslFactoryPluginParams = "";
    @FieldContext(category="KeyStoreTLS", doc="Whether the Pulsar proxy use KeyStore type to authenticate with Pulsar brokers")
    private boolean brokerClientTlsEnabledWithKeyStore = false;
    @FieldContext(category="KeyStoreTLS", doc="The TLS Provider used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientSslProvider = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore type configuration for proxy: JKS, PKCS12  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsKeyStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore path for internal client,  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsKeyStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore password for proxy,  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsKeyStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore type configuration for proxy: JKS, PKCS12  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore path for proxy,  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore password for proxy,  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="Specify the tls cipher the proxy will use to negotiate during TLS Handshake (a comma-separated list of ciphers).\n\nExamples:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256].\n used by the Pulsar proxy to authenticate with Pulsar brokers")
    private Set<String> brokerClientTlsCiphers = new TreeSet<String>();
    @FieldContext(category="KeyStoreTLS", doc="Specify the tls protocols the broker will use to negotiate during TLS handshake (a comma-separated list of protocol names).\n\nExamples:- [TLSv1.3, TLSv1.2] \n used by the Pulsar proxy to authenticate with Pulsar brokers")
    private Set<String> brokerClientTlsProtocols = new TreeSet<String>();
    @FieldContext(category="TLS", doc="SSL Factory Plugin class used by internal client to provide SSLEngine and SSLContext objects. The default class used is DefaultSslFactory.")
    private String brokerClientSslFactoryPlugin = DefaultPulsarSslFactory.class.getName();
    @FieldContext(category="TLS", doc="SSL Factory plugin configuration parameters used by internal client.")
    private String brokerClientSslFactoryPluginParams = "";
    @FieldContext(category="HTTP", doc="Http directs to redirect to non-pulsar services")
    private Set<HttpReverseProxyConfig> httpReverseProxyConfigs = new HashSet<HttpReverseProxyConfig>();
    @FieldContext(minValue=1L, category="HTTP", doc="Http output buffer size.\n\nThe amount of data that will be buffered for http requests before it is flushed to the channel. A larger buffer size may result in higher http throughput though it may take longer for the client to see data. If using HTTP streaming via the reverse proxy, this should be set to the minimum value, 1, so that clients see the data as soon as possible.")
    private int httpOutputBufferSize = 32768;
    @FieldContext(minValue=1L, category="HTTP", doc="  The maximum size in bytes of the request header.\n  Larger headers will allow for more and/or larger cookies plus larger form content encoded in a URL.\n  However, larger headers consume more memory and can make a server more vulnerable to denial of service\n  attacks.\n")
    private int httpMaxRequestHeaderSize = 8192;
    @FieldContext(minValue=1L, category="HTTP", doc="Http input buffer max size.\n\nThe maximum amount of data that will be buffered for incoming http requests so that the request body can be replayed when the backend broker issues a redirect response.")
    private int httpInputMaxReplayBufferSize = 0x500000;
    @FieldContext(minValue=1L, category="HTTP", doc="Http proxy timeout.\n\nThe timeout value for HTTP proxy is in millisecond.")
    private int httpProxyTimeout = 300000;
    @FieldContext(minValue=1L, category="HTTP", doc="Number of threads to use for HTTP requests processing")
    private int httpNumThreads = Math.max(8, 2 * Runtime.getRuntime().availableProcessors());
    @FieldContext(category="Server", doc="Max concurrent web requests")
    private int maxConcurrentHttpRequests = 1024;
    @FieldContext(category="Server", doc="Capacity for thread pool queue in the HTTP server Default is set to 8192.")
    private int httpServerThreadPoolQueueSize = 8192;
    @FieldContext(category="Server", doc="Capacity for accept queue in the HTTP server Default is set to 8192.")
    private int httpServerAcceptQueueSize = 8192;
    @FieldContext(category="Server", doc="Maximum number of inbound http connections. (0 to disable limiting)")
    private int maxHttpServerConnections = 2048;
    @FieldContext(category="Server", doc="Number of threads used for Netty IO. Default is set to `2 * Runtime.getRuntime().availableProcessors()`")
    private int numIOThreads = 2 * Runtime.getRuntime().availableProcessors();
    @FieldContext(category="Server", doc="Number of threads used for Netty Acceptor. Default is set to `1`")
    private int numAcceptorThreads = 1;
    @Deprecated
    @FieldContext(category="proxy plugin", doc="The directory to locate proxy additional servlet")
    private String proxyAdditionalServletDirectory = "./proxyAdditionalServlet";
    @FieldContext(category="proxy plugin", doc="The directory to locate proxy additional servlet")
    private String additionalServletDirectory = "./proxyAdditionalServlet";
    @Deprecated
    @FieldContext(category="proxy plugin", doc="List of proxy additional servlet to load, which is a list of proxy additional servlet names")
    private Set<String> proxyAdditionalServlets = new TreeSet<String>();
    @FieldContext(category="proxy plugin", doc="Default http header map to add into http-proxy for the any security requirements eg: { \"header1\": \"val1\", \"header2\": \"val2\" }")
    private String proxyHttpResponseHeadersJson;
    @FieldContext(category="proxy plugin", doc="List of proxy additional servlet to load, which is a list of proxy additional servlet names")
    private Set<String> additionalServlets = new TreeSet<String>();
    @FieldContext(category="HTTP", doc="Enable the enforcement of limits on the incoming HTTP requests")
    private boolean httpRequestsLimitEnabled = false;
    @FieldContext(category="HTTP", doc="Max HTTP requests per seconds allowed. The excess of requests will be rejected with HTTP code 429 (Too many requests)")
    private double httpRequestsMaxPerSecond = 100.0;
    @FieldContext(category="proxy plugin", doc="The directory to locate proxy extensions")
    @PropertiesContext(properties={@PropertyContext(key="tokenPublicKey", doc=@FieldContext(category="Token Authentication Provider", doc="Asymmetric public/private key pair.\n\nConfigure the public key to be used to validate auth tokens The key can be specified like:\n\ntokenPublicKey=data:;base64,xxxxxxxxx\ntokenPublicKey=file:///my/public.key  ( Note: key file must be DER-encoded )")), @PropertyContext(key="tokenSecretKey", doc=@FieldContext(category="Token Authentication Provider", doc="Symmetric key.\n\nConfigure the secret key to be used to validate auth tokensThe key can be specified like:\n\ntokenSecretKey=data:;base64,xxxxxxxxx\ntokenSecretKey=file:///my/secret.key  ( Note: key file must be DER-encoded )"))})
    private String proxyExtensionsDirectory = "./proxyextensions";
    @FieldContext(category="proxy plugin", doc="List of messaging protocols to load, which is a list of extension names")
    private Set<String> proxyExtensions = new TreeSet<String>();
    @FieldContext(category="proxy plugin", doc="Use a separate ThreadPool for each Proxy Extension")
    private boolean useSeparateThreadPoolForProxyExtensions = true;
    @FieldContext(category="WebSocket", doc="Enable or disable the WebSocket servlet")
    private boolean webSocketServiceEnabled = false;
    @FieldContext(category="WebSocket", doc="Interval of time to sending the ping to keep alive in WebSocket proxy. This value greater than 0 means enabled")
    private int webSocketPingDurationSeconds = -1;
    @FieldContext(category="WebSocket", doc="Name of the cluster to which this broker belongs to")
    private String clusterName;
    private Properties properties = new Properties();

    public String getMetadataStoreUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.metadataStoreUrl)) {
            return this.metadataStoreUrl;
        }
        return this.zookeeperServers;
    }

    public String getConfigurationMetadataStoreUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.configurationMetadataStoreUrl)) {
            return this.configurationMetadataStoreUrl;
        }
        if (StringUtils.isNotBlank((CharSequence)this.configurationStoreServers)) {
            return this.configurationStoreServers;
        }
        if (StringUtils.isNotBlank((CharSequence)this.globalZookeeperServers)) {
            return this.globalZookeeperServers;
        }
        return this.getMetadataStoreUrl();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Optional<Integer> getServicePort() {
        return this.servicePort;
    }

    public Optional<Integer> getServicePortTls() {
        return this.servicePortTls;
    }

    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        HashMap redirects = new HashMap();
        Pattern redirectPattern = Pattern.compile("^httpReverseProxy\\.([^\\.]*)\\.(.+)$");
        Map<String, List<Matcher>> groups = properties.stringPropertyNames().stream().map(s -> redirectPattern.matcher((CharSequence)s)).filter(Matcher::matches).collect(Collectors.groupingBy(m -> m.group(1)));
        groups.entrySet().forEach(e -> {
            Map<String, String> keyToFullKey = ((List)e.getValue()).stream().collect(Collectors.toMap(m -> m.group(2), m -> m.group(0)));
            if (!keyToFullKey.containsKey("path")) {
                throw new IllegalArgumentException(String.format("httpReverseProxy.%s.path must be specified exactly once", e.getKey()));
            }
            if (!keyToFullKey.containsKey("proxyTo")) {
                throw new IllegalArgumentException(String.format("httpReverseProxy.%s.proxyTo must be specified exactly once", e.getKey()));
            }
            this.httpReverseProxyConfigs.add(new HttpReverseProxyConfig((String)e.getKey(), properties.getProperty(keyToFullKey.get("path")), properties.getProperty(keyToFullKey.get("proxyTo"))));
        });
    }

    public int getMetadataStoreSessionTimeoutMillis() {
        return this.zookeeperSessionTimeoutMs > 0 ? this.zookeeperSessionTimeoutMs : this.metadataStoreSessionTimeoutMillis;
    }

    public int getMetadataStoreCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds > 0 ? this.zooKeeperCacheExpirySeconds : this.metadataStoreCacheExpirySeconds;
    }

    public boolean isMetadataStoreAllowReadOnlyOperations() {
        return this.zooKeeperAllowReadOnlyOperations || this.metadataStoreAllowReadOnlyOperations;
    }

    @Deprecated
    @Generated
    public String getZookeeperServers() {
        return this.zookeeperServers;
    }

    @Deprecated
    @Generated
    public String getConfigurationStoreServers() {
        return this.configurationStoreServers;
    }

    @Deprecated
    @Generated
    public String getGlobalZookeeperServers() {
        return this.globalZookeeperServers;
    }

    @Generated
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Deprecated
    @Generated
    public int getZookeeperSessionTimeoutMs() {
        return this.zookeeperSessionTimeoutMs;
    }

    @Deprecated
    @Generated
    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    @Deprecated
    @Generated
    public boolean isZooKeeperAllowReadOnlyOperations() {
        return this.zooKeeperAllowReadOnlyOperations;
    }

    @Generated
    public String getBrokerServiceURL() {
        return this.brokerServiceURL;
    }

    @Generated
    public String getBrokerServiceURLTLS() {
        return this.brokerServiceURLTLS;
    }

    @Generated
    public String getBrokerWebServiceURL() {
        return this.brokerWebServiceURL;
    }

    @Generated
    public String getBrokerWebServiceURLTLS() {
        return this.brokerWebServiceURLTLS;
    }

    @Generated
    public String getFunctionWorkerWebServiceURL() {
        return this.functionWorkerWebServiceURL;
    }

    @Generated
    public String getFunctionWorkerWebServiceURLTLS() {
        return this.functionWorkerWebServiceURLTLS;
    }

    @Generated
    public boolean isCheckActiveBrokers() {
        return this.checkActiveBrokers;
    }

    @Generated
    public int getBrokerProxyConnectTimeoutMs() {
        return this.brokerProxyConnectTimeoutMs;
    }

    @Generated
    public int getBrokerProxyReadTimeoutMs() {
        return this.brokerProxyReadTimeoutMs;
    }

    @Generated
    public String getBrokerProxyAllowedHostNames() {
        return this.brokerProxyAllowedHostNames;
    }

    @Generated
    public String getBrokerProxyAllowedIPAddresses() {
        return this.brokerProxyAllowedIPAddresses;
    }

    @Generated
    public String getBrokerProxyAllowedTargetPorts() {
        return this.brokerProxyAllowedTargetPorts;
    }

    @Generated
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Generated
    public String getAdvertisedAddress() {
        return this.advertisedAddress;
    }

    @Generated
    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    @Generated
    public boolean isHaProxyProtocolEnabled() {
        return this.haProxyProtocolEnabled;
    }

    @Generated
    public boolean isWebServiceHaProxyProtocolEnabled() {
        return this.webServiceHaProxyProtocolEnabled;
    }

    @Generated
    public boolean isWebServiceTrustXForwardedFor() {
        return this.webServiceTrustXForwardedFor;
    }

    @Generated
    public Boolean getWebServiceLogDetailedAddresses() {
        return this.webServiceLogDetailedAddresses;
    }

    @Generated
    public String getAuthenticationRoleLoggingAnonymizer() {
        return this.authenticationRoleLoggingAnonymizer;
    }

    @Generated
    public boolean isProxyZeroCopyModeEnabled() {
        return this.proxyZeroCopyModeEnabled;
    }

    @Generated
    public String getWebServiceTlsProvider() {
        return this.webServiceTlsProvider;
    }

    @Generated
    public Set<String> getWebServiceTlsProtocols() {
        return this.webServiceTlsProtocols;
    }

    @Generated
    public Set<String> getWebServiceTlsCiphers() {
        return this.webServiceTlsCiphers;
    }

    @Generated
    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    @Generated
    public Optional<Integer> getProxyLogLevel() {
        return this.proxyLogLevel;
    }

    @Generated
    public String getStatusFilePath() {
        return this.statusFilePath;
    }

    @Generated
    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    @Generated
    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    @Generated
    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    @Generated
    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    @Generated
    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    @Generated
    public boolean isForwardAuthorizationCredentials() {
        return this.forwardAuthorizationCredentials;
    }

    @Generated
    public int getAuthenticationRefreshCheckSeconds() {
        return this.authenticationRefreshCheckSeconds;
    }

    @Generated
    public boolean isEnableProxyStatsEndpoints() {
        return this.enableProxyStatsEndpoints;
    }

    @Generated
    public boolean isAuthenticateMetricsEndpoint() {
        return this.authenticateMetricsEndpoint;
    }

    @Generated
    public long getMetricsServletTimeoutMs() {
        return this.metricsServletTimeoutMs;
    }

    @Generated
    public String getSaslJaasClientAllowedIds() {
        return this.saslJaasClientAllowedIds;
    }

    @Generated
    public String getSaslJaasServerSectionName() {
        return this.saslJaasServerSectionName;
    }

    @Generated
    public String getSaslJaasServerRoleTokenSignerSecretPath() {
        return this.saslJaasServerRoleTokenSignerSecretPath;
    }

    @Generated
    public String getKinitCommand() {
        return this.kinitCommand;
    }

    @Generated
    public int getMaxConcurrentInboundConnections() {
        return this.maxConcurrentInboundConnections;
    }

    @Generated
    public int getMaxConcurrentInboundConnectionsPerIp() {
        return this.maxConcurrentInboundConnectionsPerIp;
    }

    @Generated
    public int getMaxConcurrentLookupRequests() {
        return this.maxConcurrentLookupRequests;
    }

    @Generated
    public int getMaxTopicListInFlightHeapMemSizeMB() {
        return this.maxTopicListInFlightHeapMemSizeMB;
    }

    @Generated
    public int getMaxTopicListInFlightDirectMemSizeMB() {
        return this.maxTopicListInFlightDirectMemSizeMB;
    }

    @Generated
    public int getMaxTopicListInFlightHeapMemSizePermitsAcquireTimeoutMillis() {
        return this.maxTopicListInFlightHeapMemSizePermitsAcquireTimeoutMillis;
    }

    @Generated
    public int getMaxTopicListInFlightHeapMemSizePermitsAcquireQueueSize() {
        return this.maxTopicListInFlightHeapMemSizePermitsAcquireQueueSize;
    }

    @Generated
    public int getMaxTopicListInFlightDirectMemSizePermitsAcquireTimeoutMillis() {
        return this.maxTopicListInFlightDirectMemSizePermitsAcquireTimeoutMillis;
    }

    @Generated
    public int getMaxTopicListInFlightDirectMemSizePermitsAcquireQueueSize() {
        return this.maxTopicListInFlightDirectMemSizePermitsAcquireQueueSize;
    }

    @Generated
    public String getBrokerClientAuthenticationPlugin() {
        return this.brokerClientAuthenticationPlugin;
    }

    @Generated
    public String getBrokerClientAuthenticationParameters() {
        return this.brokerClientAuthenticationParameters;
    }

    @Generated
    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    @Generated
    public String getBrokerClientKeyFilePath() {
        return this.brokerClientKeyFilePath;
    }

    @Generated
    public String getBrokerClientCertificateFilePath() {
        return this.brokerClientCertificateFilePath;
    }

    @Generated
    public boolean isTlsEnabledWithBroker() {
        return this.tlsEnabledWithBroker;
    }

    @Generated
    public String getAnonymousUserRole() {
        return this.anonymousUserRole;
    }

    @Deprecated
    @Generated
    public boolean isTlsEnabledInProxy() {
        return this.tlsEnabledInProxy;
    }

    @Generated
    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    @Generated
    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    @Generated
    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    @Generated
    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    @Generated
    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    @Generated
    public boolean isTlsHostnameVerificationEnabled() {
        return this.tlsHostnameVerificationEnabled;
    }

    @Generated
    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    @Generated
    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    @Generated
    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    @Generated
    public boolean isTlsEnabledWithKeyStore() {
        return this.tlsEnabledWithKeyStore;
    }

    @Generated
    public String getTlsProvider() {
        return this.tlsProvider;
    }

    @Generated
    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    @Generated
    public String getTlsKeyStore() {
        return this.tlsKeyStore;
    }

    @Generated
    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    @Generated
    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    @Generated
    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    @Generated
    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    @Generated
    public String getSslFactoryPlugin() {
        return this.sslFactoryPlugin;
    }

    @Generated
    public String getSslFactoryPluginParams() {
        return this.sslFactoryPluginParams;
    }

    @Generated
    public boolean isBrokerClientTlsEnabledWithKeyStore() {
        return this.brokerClientTlsEnabledWithKeyStore;
    }

    @Generated
    public String getBrokerClientSslProvider() {
        return this.brokerClientSslProvider;
    }

    @Generated
    public String getBrokerClientTlsKeyStoreType() {
        return this.brokerClientTlsKeyStoreType;
    }

    @Generated
    public String getBrokerClientTlsKeyStore() {
        return this.brokerClientTlsKeyStore;
    }

    @Generated
    public String getBrokerClientTlsKeyStorePassword() {
        return this.brokerClientTlsKeyStorePassword;
    }

    @Generated
    public String getBrokerClientTlsTrustStoreType() {
        return this.brokerClientTlsTrustStoreType;
    }

    @Generated
    public String getBrokerClientTlsTrustStore() {
        return this.brokerClientTlsTrustStore;
    }

    @Generated
    public String getBrokerClientTlsTrustStorePassword() {
        return this.brokerClientTlsTrustStorePassword;
    }

    @Generated
    public Set<String> getBrokerClientTlsCiphers() {
        return this.brokerClientTlsCiphers;
    }

    @Generated
    public Set<String> getBrokerClientTlsProtocols() {
        return this.brokerClientTlsProtocols;
    }

    @Generated
    public String getBrokerClientSslFactoryPlugin() {
        return this.brokerClientSslFactoryPlugin;
    }

    @Generated
    public String getBrokerClientSslFactoryPluginParams() {
        return this.brokerClientSslFactoryPluginParams;
    }

    @Generated
    public Set<HttpReverseProxyConfig> getHttpReverseProxyConfigs() {
        return this.httpReverseProxyConfigs;
    }

    @Generated
    public int getHttpOutputBufferSize() {
        return this.httpOutputBufferSize;
    }

    @Generated
    public int getHttpMaxRequestHeaderSize() {
        return this.httpMaxRequestHeaderSize;
    }

    @Generated
    public int getHttpInputMaxReplayBufferSize() {
        return this.httpInputMaxReplayBufferSize;
    }

    @Generated
    public int getHttpProxyTimeout() {
        return this.httpProxyTimeout;
    }

    @Generated
    public int getHttpNumThreads() {
        return this.httpNumThreads;
    }

    @Generated
    public int getMaxConcurrentHttpRequests() {
        return this.maxConcurrentHttpRequests;
    }

    @Generated
    public int getHttpServerThreadPoolQueueSize() {
        return this.httpServerThreadPoolQueueSize;
    }

    @Generated
    public int getHttpServerAcceptQueueSize() {
        return this.httpServerAcceptQueueSize;
    }

    @Generated
    public int getMaxHttpServerConnections() {
        return this.maxHttpServerConnections;
    }

    @Generated
    public int getNumIOThreads() {
        return this.numIOThreads;
    }

    @Generated
    public int getNumAcceptorThreads() {
        return this.numAcceptorThreads;
    }

    @Deprecated
    @Generated
    public String getProxyAdditionalServletDirectory() {
        return this.proxyAdditionalServletDirectory;
    }

    @Generated
    public String getAdditionalServletDirectory() {
        return this.additionalServletDirectory;
    }

    @Deprecated
    @Generated
    public Set<String> getProxyAdditionalServlets() {
        return this.proxyAdditionalServlets;
    }

    @Generated
    public String getProxyHttpResponseHeadersJson() {
        return this.proxyHttpResponseHeadersJson;
    }

    @Generated
    public Set<String> getAdditionalServlets() {
        return this.additionalServlets;
    }

    @Generated
    public boolean isHttpRequestsLimitEnabled() {
        return this.httpRequestsLimitEnabled;
    }

    @Generated
    public double getHttpRequestsMaxPerSecond() {
        return this.httpRequestsMaxPerSecond;
    }

    @Generated
    public String getProxyExtensionsDirectory() {
        return this.proxyExtensionsDirectory;
    }

    @Generated
    public Set<String> getProxyExtensions() {
        return this.proxyExtensions;
    }

    @Generated
    public boolean isUseSeparateThreadPoolForProxyExtensions() {
        return this.useSeparateThreadPoolForProxyExtensions;
    }

    @Generated
    public boolean isWebSocketServiceEnabled() {
        return this.webSocketServiceEnabled;
    }

    @Generated
    public int getWebSocketPingDurationSeconds() {
        return this.webSocketPingDurationSeconds;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Deprecated
    @Generated
    public void setZookeeperServers(String zookeeperServers) {
        this.zookeeperServers = zookeeperServers;
    }

    @Generated
    public void setMetadataStoreUrl(String metadataStoreUrl) {
        this.metadataStoreUrl = metadataStoreUrl;
    }

    @Deprecated
    @Generated
    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    @Deprecated
    @Generated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    @Generated
    public void setConfigurationMetadataStoreUrl(String configurationMetadataStoreUrl) {
        this.configurationMetadataStoreUrl = configurationMetadataStoreUrl;
    }

    @Generated
    public void setMetadataStoreSessionTimeoutMillis(int metadataStoreSessionTimeoutMillis) {
        this.metadataStoreSessionTimeoutMillis = metadataStoreSessionTimeoutMillis;
    }

    @Generated
    public void setMetadataStoreCacheExpirySeconds(int metadataStoreCacheExpirySeconds) {
        this.metadataStoreCacheExpirySeconds = metadataStoreCacheExpirySeconds;
    }

    @Generated
    public void setMetadataStoreAllowReadOnlyOperations(boolean metadataStoreAllowReadOnlyOperations) {
        this.metadataStoreAllowReadOnlyOperations = metadataStoreAllowReadOnlyOperations;
    }

    @Generated
    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    @Deprecated
    @Generated
    public void setZookeeperSessionTimeoutMs(int zookeeperSessionTimeoutMs) {
        this.zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMs;
    }

    @Deprecated
    @Generated
    public void setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
    }

    @Deprecated
    @Generated
    public void setZooKeeperAllowReadOnlyOperations(boolean zooKeeperAllowReadOnlyOperations) {
        this.zooKeeperAllowReadOnlyOperations = zooKeeperAllowReadOnlyOperations;
    }

    @Generated
    public void setBrokerServiceURL(String brokerServiceURL) {
        this.brokerServiceURL = brokerServiceURL;
    }

    @Generated
    public void setBrokerServiceURLTLS(String brokerServiceURLTLS) {
        this.brokerServiceURLTLS = brokerServiceURLTLS;
    }

    @Generated
    public void setBrokerWebServiceURL(String brokerWebServiceURL) {
        this.brokerWebServiceURL = brokerWebServiceURL;
    }

    @Generated
    public void setBrokerWebServiceURLTLS(String brokerWebServiceURLTLS) {
        this.brokerWebServiceURLTLS = brokerWebServiceURLTLS;
    }

    @Generated
    public void setFunctionWorkerWebServiceURL(String functionWorkerWebServiceURL) {
        this.functionWorkerWebServiceURL = functionWorkerWebServiceURL;
    }

    @Generated
    public void setFunctionWorkerWebServiceURLTLS(String functionWorkerWebServiceURLTLS) {
        this.functionWorkerWebServiceURLTLS = functionWorkerWebServiceURLTLS;
    }

    @Generated
    public void setCheckActiveBrokers(boolean checkActiveBrokers) {
        this.checkActiveBrokers = checkActiveBrokers;
    }

    @Generated
    public void setBrokerProxyConnectTimeoutMs(int brokerProxyConnectTimeoutMs) {
        this.brokerProxyConnectTimeoutMs = brokerProxyConnectTimeoutMs;
    }

    @Generated
    public void setBrokerProxyReadTimeoutMs(int brokerProxyReadTimeoutMs) {
        this.brokerProxyReadTimeoutMs = brokerProxyReadTimeoutMs;
    }

    @Generated
    public void setBrokerProxyAllowedHostNames(String brokerProxyAllowedHostNames) {
        this.brokerProxyAllowedHostNames = brokerProxyAllowedHostNames;
    }

    @Generated
    public void setBrokerProxyAllowedIPAddresses(String brokerProxyAllowedIPAddresses) {
        this.brokerProxyAllowedIPAddresses = brokerProxyAllowedIPAddresses;
    }

    @Generated
    public void setBrokerProxyAllowedTargetPorts(String brokerProxyAllowedTargetPorts) {
        this.brokerProxyAllowedTargetPorts = brokerProxyAllowedTargetPorts;
    }

    @Generated
    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Generated
    public void setAdvertisedAddress(String advertisedAddress) {
        this.advertisedAddress = advertisedAddress;
    }

    @Generated
    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    @Generated
    public void setHaProxyProtocolEnabled(boolean haProxyProtocolEnabled) {
        this.haProxyProtocolEnabled = haProxyProtocolEnabled;
    }

    @Generated
    public void setWebServiceHaProxyProtocolEnabled(boolean webServiceHaProxyProtocolEnabled) {
        this.webServiceHaProxyProtocolEnabled = webServiceHaProxyProtocolEnabled;
    }

    @Generated
    public void setWebServiceTrustXForwardedFor(boolean webServiceTrustXForwardedFor) {
        this.webServiceTrustXForwardedFor = webServiceTrustXForwardedFor;
    }

    @Generated
    public void setWebServiceLogDetailedAddresses(Boolean webServiceLogDetailedAddresses) {
        this.webServiceLogDetailedAddresses = webServiceLogDetailedAddresses;
    }

    @Generated
    public void setAuthenticationRoleLoggingAnonymizer(String authenticationRoleLoggingAnonymizer) {
        this.authenticationRoleLoggingAnonymizer = authenticationRoleLoggingAnonymizer;
    }

    @Generated
    public void setProxyZeroCopyModeEnabled(boolean proxyZeroCopyModeEnabled) {
        this.proxyZeroCopyModeEnabled = proxyZeroCopyModeEnabled;
    }

    @Generated
    public void setServicePort(Optional<Integer> servicePort) {
        this.servicePort = servicePort;
    }

    @Generated
    public void setServicePortTls(Optional<Integer> servicePortTls) {
        this.servicePortTls = servicePortTls;
    }

    @Generated
    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    @Generated
    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    @Generated
    public void setWebServiceTlsProvider(String webServiceTlsProvider) {
        this.webServiceTlsProvider = webServiceTlsProvider;
    }

    @Generated
    public void setWebServiceTlsProtocols(Set<String> webServiceTlsProtocols) {
        this.webServiceTlsProtocols = webServiceTlsProtocols;
    }

    @Generated
    public void setWebServiceTlsCiphers(Set<String> webServiceTlsCiphers) {
        this.webServiceTlsCiphers = webServiceTlsCiphers;
    }

    @Generated
    public void setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
    }

    @Generated
    public void setProxyLogLevel(Optional<Integer> proxyLogLevel) {
        this.proxyLogLevel = proxyLogLevel;
    }

    @Generated
    public void setStatusFilePath(String statusFilePath) {
        this.statusFilePath = statusFilePath;
    }

    @Generated
    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    @Generated
    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    @Generated
    public void setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    @Generated
    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    @Generated
    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    @Generated
    public void setForwardAuthorizationCredentials(boolean forwardAuthorizationCredentials) {
        this.forwardAuthorizationCredentials = forwardAuthorizationCredentials;
    }

    @Generated
    public void setAuthenticationRefreshCheckSeconds(int authenticationRefreshCheckSeconds) {
        this.authenticationRefreshCheckSeconds = authenticationRefreshCheckSeconds;
    }

    @Generated
    public void setEnableProxyStatsEndpoints(boolean enableProxyStatsEndpoints) {
        this.enableProxyStatsEndpoints = enableProxyStatsEndpoints;
    }

    @Generated
    public void setAuthenticateMetricsEndpoint(boolean authenticateMetricsEndpoint) {
        this.authenticateMetricsEndpoint = authenticateMetricsEndpoint;
    }

    @Generated
    public void setMetricsServletTimeoutMs(long metricsServletTimeoutMs) {
        this.metricsServletTimeoutMs = metricsServletTimeoutMs;
    }

    @Generated
    public void setSaslJaasClientAllowedIds(String saslJaasClientAllowedIds) {
        this.saslJaasClientAllowedIds = saslJaasClientAllowedIds;
    }

    @Generated
    public void setSaslJaasServerSectionName(String saslJaasServerSectionName) {
        this.saslJaasServerSectionName = saslJaasServerSectionName;
    }

    @Generated
    public void setSaslJaasServerRoleTokenSignerSecretPath(String saslJaasServerRoleTokenSignerSecretPath) {
        this.saslJaasServerRoleTokenSignerSecretPath = saslJaasServerRoleTokenSignerSecretPath;
    }

    @Generated
    public void setKinitCommand(String kinitCommand) {
        this.kinitCommand = kinitCommand;
    }

    @Generated
    public void setMaxConcurrentInboundConnections(int maxConcurrentInboundConnections) {
        this.maxConcurrentInboundConnections = maxConcurrentInboundConnections;
    }

    @Generated
    public void setMaxConcurrentInboundConnectionsPerIp(int maxConcurrentInboundConnectionsPerIp) {
        this.maxConcurrentInboundConnectionsPerIp = maxConcurrentInboundConnectionsPerIp;
    }

    @Generated
    public void setMaxConcurrentLookupRequests(int maxConcurrentLookupRequests) {
        this.maxConcurrentLookupRequests = maxConcurrentLookupRequests;
    }

    @Generated
    public void setMaxTopicListInFlightHeapMemSizeMB(int maxTopicListInFlightHeapMemSizeMB) {
        this.maxTopicListInFlightHeapMemSizeMB = maxTopicListInFlightHeapMemSizeMB;
    }

    @Generated
    public void setMaxTopicListInFlightDirectMemSizeMB(int maxTopicListInFlightDirectMemSizeMB) {
        this.maxTopicListInFlightDirectMemSizeMB = maxTopicListInFlightDirectMemSizeMB;
    }

    @Generated
    public void setMaxTopicListInFlightHeapMemSizePermitsAcquireTimeoutMillis(int maxTopicListInFlightHeapMemSizePermitsAcquireTimeoutMillis) {
        this.maxTopicListInFlightHeapMemSizePermitsAcquireTimeoutMillis = maxTopicListInFlightHeapMemSizePermitsAcquireTimeoutMillis;
    }

    @Generated
    public void setMaxTopicListInFlightHeapMemSizePermitsAcquireQueueSize(int maxTopicListInFlightHeapMemSizePermitsAcquireQueueSize) {
        this.maxTopicListInFlightHeapMemSizePermitsAcquireQueueSize = maxTopicListInFlightHeapMemSizePermitsAcquireQueueSize;
    }

    @Generated
    public void setMaxTopicListInFlightDirectMemSizePermitsAcquireTimeoutMillis(int maxTopicListInFlightDirectMemSizePermitsAcquireTimeoutMillis) {
        this.maxTopicListInFlightDirectMemSizePermitsAcquireTimeoutMillis = maxTopicListInFlightDirectMemSizePermitsAcquireTimeoutMillis;
    }

    @Generated
    public void setMaxTopicListInFlightDirectMemSizePermitsAcquireQueueSize(int maxTopicListInFlightDirectMemSizePermitsAcquireQueueSize) {
        this.maxTopicListInFlightDirectMemSizePermitsAcquireQueueSize = maxTopicListInFlightDirectMemSizePermitsAcquireQueueSize;
    }

    @Generated
    public void setBrokerClientAuthenticationPlugin(String brokerClientAuthenticationPlugin) {
        this.brokerClientAuthenticationPlugin = brokerClientAuthenticationPlugin;
    }

    @Generated
    public void setBrokerClientAuthenticationParameters(String brokerClientAuthenticationParameters) {
        this.brokerClientAuthenticationParameters = brokerClientAuthenticationParameters;
    }

    @Generated
    public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    @Generated
    public void setBrokerClientKeyFilePath(String brokerClientKeyFilePath) {
        this.brokerClientKeyFilePath = brokerClientKeyFilePath;
    }

    @Generated
    public void setBrokerClientCertificateFilePath(String brokerClientCertificateFilePath) {
        this.brokerClientCertificateFilePath = brokerClientCertificateFilePath;
    }

    @Generated
    public void setTlsEnabledWithBroker(boolean tlsEnabledWithBroker) {
        this.tlsEnabledWithBroker = tlsEnabledWithBroker;
    }

    @Generated
    public void setAnonymousUserRole(String anonymousUserRole) {
        this.anonymousUserRole = anonymousUserRole;
    }

    @Deprecated
    @Generated
    public void setTlsEnabledInProxy(boolean tlsEnabledInProxy) {
        this.tlsEnabledInProxy = tlsEnabledInProxy;
    }

    @Generated
    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }

    @Generated
    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    @Generated
    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    @Generated
    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    @Generated
    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    @Generated
    public void setTlsHostnameVerificationEnabled(boolean tlsHostnameVerificationEnabled) {
        this.tlsHostnameVerificationEnabled = tlsHostnameVerificationEnabled;
    }

    @Generated
    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    @Generated
    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    @Generated
    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }

    @Generated
    public void setTlsEnabledWithKeyStore(boolean tlsEnabledWithKeyStore) {
        this.tlsEnabledWithKeyStore = tlsEnabledWithKeyStore;
    }

    @Generated
    public void setTlsProvider(String tlsProvider) {
        this.tlsProvider = tlsProvider;
    }

    @Generated
    public void setTlsKeyStoreType(String tlsKeyStoreType) {
        this.tlsKeyStoreType = tlsKeyStoreType;
    }

    @Generated
    public void setTlsKeyStore(String tlsKeyStore) {
        this.tlsKeyStore = tlsKeyStore;
    }

    @Generated
    public void setTlsKeyStorePassword(String tlsKeyStorePassword) {
        this.tlsKeyStorePassword = tlsKeyStorePassword;
    }

    @Generated
    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    @Generated
    public void setTlsTrustStore(String tlsTrustStore) {
        this.tlsTrustStore = tlsTrustStore;
    }

    @Generated
    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    @Generated
    public void setSslFactoryPlugin(String sslFactoryPlugin) {
        this.sslFactoryPlugin = sslFactoryPlugin;
    }

    @Generated
    public void setSslFactoryPluginParams(String sslFactoryPluginParams) {
        this.sslFactoryPluginParams = sslFactoryPluginParams;
    }

    @Generated
    public void setBrokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
        this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
    }

    @Generated
    public void setBrokerClientSslProvider(String brokerClientSslProvider) {
        this.brokerClientSslProvider = brokerClientSslProvider;
    }

    @Generated
    public void setBrokerClientTlsKeyStoreType(String brokerClientTlsKeyStoreType) {
        this.brokerClientTlsKeyStoreType = brokerClientTlsKeyStoreType;
    }

    @Generated
    public void setBrokerClientTlsKeyStore(String brokerClientTlsKeyStore) {
        this.brokerClientTlsKeyStore = brokerClientTlsKeyStore;
    }

    @Generated
    public void setBrokerClientTlsKeyStorePassword(String brokerClientTlsKeyStorePassword) {
        this.brokerClientTlsKeyStorePassword = brokerClientTlsKeyStorePassword;
    }

    @Generated
    public void setBrokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
        this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
    }

    @Generated
    public void setBrokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
        this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
    }

    @Generated
    public void setBrokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
        this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
    }

    @Generated
    public void setBrokerClientTlsCiphers(Set<String> brokerClientTlsCiphers) {
        this.brokerClientTlsCiphers = brokerClientTlsCiphers;
    }

    @Generated
    public void setBrokerClientTlsProtocols(Set<String> brokerClientTlsProtocols) {
        this.brokerClientTlsProtocols = brokerClientTlsProtocols;
    }

    @Generated
    public void setBrokerClientSslFactoryPlugin(String brokerClientSslFactoryPlugin) {
        this.brokerClientSslFactoryPlugin = brokerClientSslFactoryPlugin;
    }

    @Generated
    public void setBrokerClientSslFactoryPluginParams(String brokerClientSslFactoryPluginParams) {
        this.brokerClientSslFactoryPluginParams = brokerClientSslFactoryPluginParams;
    }

    @Generated
    public void setHttpReverseProxyConfigs(Set<HttpReverseProxyConfig> httpReverseProxyConfigs) {
        this.httpReverseProxyConfigs = httpReverseProxyConfigs;
    }

    @Generated
    public void setHttpOutputBufferSize(int httpOutputBufferSize) {
        this.httpOutputBufferSize = httpOutputBufferSize;
    }

    @Generated
    public void setHttpMaxRequestHeaderSize(int httpMaxRequestHeaderSize) {
        this.httpMaxRequestHeaderSize = httpMaxRequestHeaderSize;
    }

    @Generated
    public void setHttpInputMaxReplayBufferSize(int httpInputMaxReplayBufferSize) {
        this.httpInputMaxReplayBufferSize = httpInputMaxReplayBufferSize;
    }

    @Generated
    public void setHttpProxyTimeout(int httpProxyTimeout) {
        this.httpProxyTimeout = httpProxyTimeout;
    }

    @Generated
    public void setHttpNumThreads(int httpNumThreads) {
        this.httpNumThreads = httpNumThreads;
    }

    @Generated
    public void setMaxConcurrentHttpRequests(int maxConcurrentHttpRequests) {
        this.maxConcurrentHttpRequests = maxConcurrentHttpRequests;
    }

    @Generated
    public void setHttpServerThreadPoolQueueSize(int httpServerThreadPoolQueueSize) {
        this.httpServerThreadPoolQueueSize = httpServerThreadPoolQueueSize;
    }

    @Generated
    public void setHttpServerAcceptQueueSize(int httpServerAcceptQueueSize) {
        this.httpServerAcceptQueueSize = httpServerAcceptQueueSize;
    }

    @Generated
    public void setMaxHttpServerConnections(int maxHttpServerConnections) {
        this.maxHttpServerConnections = maxHttpServerConnections;
    }

    @Generated
    public void setNumIOThreads(int numIOThreads) {
        this.numIOThreads = numIOThreads;
    }

    @Generated
    public void setNumAcceptorThreads(int numAcceptorThreads) {
        this.numAcceptorThreads = numAcceptorThreads;
    }

    @Deprecated
    @Generated
    public void setProxyAdditionalServletDirectory(String proxyAdditionalServletDirectory) {
        this.proxyAdditionalServletDirectory = proxyAdditionalServletDirectory;
    }

    @Generated
    public void setAdditionalServletDirectory(String additionalServletDirectory) {
        this.additionalServletDirectory = additionalServletDirectory;
    }

    @Deprecated
    @Generated
    public void setProxyAdditionalServlets(Set<String> proxyAdditionalServlets) {
        this.proxyAdditionalServlets = proxyAdditionalServlets;
    }

    @Generated
    public void setProxyHttpResponseHeadersJson(String proxyHttpResponseHeadersJson) {
        this.proxyHttpResponseHeadersJson = proxyHttpResponseHeadersJson;
    }

    @Generated
    public void setAdditionalServlets(Set<String> additionalServlets) {
        this.additionalServlets = additionalServlets;
    }

    @Generated
    public void setHttpRequestsLimitEnabled(boolean httpRequestsLimitEnabled) {
        this.httpRequestsLimitEnabled = httpRequestsLimitEnabled;
    }

    @Generated
    public void setHttpRequestsMaxPerSecond(double httpRequestsMaxPerSecond) {
        this.httpRequestsMaxPerSecond = httpRequestsMaxPerSecond;
    }

    @Generated
    public void setProxyExtensionsDirectory(String proxyExtensionsDirectory) {
        this.proxyExtensionsDirectory = proxyExtensionsDirectory;
    }

    @Generated
    public void setProxyExtensions(Set<String> proxyExtensions) {
        this.proxyExtensions = proxyExtensions;
    }

    @Generated
    public void setUseSeparateThreadPoolForProxyExtensions(boolean useSeparateThreadPoolForProxyExtensions) {
        this.useSeparateThreadPoolForProxyExtensions = useSeparateThreadPoolForProxyExtensions;
    }

    @Generated
    public void setWebSocketServiceEnabled(boolean webSocketServiceEnabled) {
        this.webSocketServiceEnabled = webSocketServiceEnabled;
    }

    @Generated
    public void setWebSocketPingDurationSeconds(int webSocketPingDurationSeconds) {
        this.webSocketPingDurationSeconds = webSocketPingDurationSeconds;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public static class HttpReverseProxyConfig {
        private final String name;
        private final String path;
        private final String proxyTo;

        HttpReverseProxyConfig(String name, String path, String proxyTo) {
            this.name = name;
            this.path = path;
            this.proxyTo = proxyTo;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getProxyTo() {
            return this.proxyTo;
        }

        public String toString() {
            return String.format("HttpReverseProxyConfig(%s, path=%s, proxyTo=%s)", this.name, this.path, this.proxyTo);
        }
    }
}

