/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.bookkeeper.HierarchicalLedgerUtils;
import org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHierarchicalLedgerManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHierarchicalLedgerManager.class);
    protected final MetadataStore store;
    protected final ScheduledExecutorService scheduler;
    protected final String ledgerRootPath;

    AbstractHierarchicalLedgerManager(MetadataStore store, ScheduledExecutorService scheduler, String ledgerRootPath) {
        this.store = store;
        this.scheduler = scheduler;
        this.ledgerRootPath = ledgerRootPath;
    }

    protected abstract String getLedgerParentNodeRegex();

    public boolean isLedgerParentNode(String path) {
        return path.matches(this.getLedgerParentNodeRegex());
    }

    void asyncProcessLevelNodes(String path, BookkeeperInternalCallbacks.Processor<String> processor, AsyncCallback.VoidCallback finalCb, Object context, int successRc, int failureRc) {
        ((CompletableFuture)this.store.getChildren(path).thenAccept(levelNodes -> {
            if (levelNodes.isEmpty()) {
                finalCb.processResult(successRc, null, context);
                return;
            }
            AsyncListProcessor listProcessor = new AsyncListProcessor(this.scheduler);
            listProcessor.process(levelNodes, processor, finalCb, context, successRc, failureRc);
        })).exceptionally(ex -> {
            log.error("Error polling hash nodes of {}: {}", (Object)path, (Object)ex.getMessage());
            finalCb.processResult(failureRc, null, context);
            return null;
        });
    }

    long getLedgerId(String ... levelNodes) throws IOException {
        return StringUtils.stringToHierarchicalLedgerId((String[])levelNodes);
    }

    protected void asyncProcessLedgersInSingleNode(String path, BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object ctx, int successRc, int failureRc) {
        ((CompletableFuture)this.store.getChildren(path).thenAccept(ledgerNodes -> {
            NavigableSet<Long> activeLedgers = HierarchicalLedgerUtils.ledgerListToSet(ledgerNodes, this.ledgerRootPath, path);
            if (log.isDebugEnabled()) {
                log.debug("Processing ledgers: {}", activeLedgers);
            }
            if (activeLedgers.isEmpty()) {
                finalCb.processResult(successRc, null, ctx);
                return;
            }
            BookkeeperInternalCallbacks.MultiCallback mcb = new BookkeeperInternalCallbacks.MultiCallback(activeLedgers.size(), finalCb, ctx, successRc, failureRc);
            this.scheduler.submit(() -> {
                for (Long ledger : activeLedgers) {
                    processor.process((Object)ledger, (AsyncCallback.VoidCallback)mcb);
                }
            });
        })).exceptionally(ex -> {
            finalCb.processResult(failureRc, null, ctx);
            return null;
        });
    }

    private static class AsyncListProcessor<T> {
        ScheduledExecutorService scheduler;

        public AsyncListProcessor(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
        }

        public void process(final List<T> data, final BookkeeperInternalCallbacks.Processor<T> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            if (data == null || data.size() == 0) {
                finalCb.processResult(successRc, null, context);
                return;
            }
            final int size = data.size();
            final AtomicInteger current = new AtomicInteger(0);
            T firstElement = data.get(0);
            processor.process(firstElement, new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                    if (rc != successRc) {
                        finalCb.processResult(failureRc, null, context);
                        return;
                    }
                    int next = current.incrementAndGet();
                    if (next >= size) {
                        finalCb.processResult(successRc, null, context);
                        return;
                    }
                    Object dataToProcess = data.get(next);
                    1 stub = this;
                    scheduler.execute(() -> processor.process(dataToProcess, stub));
                }
            });
        }
    }
}

