/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.redis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class RedisAbstractConfig
implements Serializable {
    private static final long serialVersionUID = -7860917032537872317L;
    @FieldDoc(required=true, defaultValue="", help="A comma separated list of Redis hosts to connect to")
    private String redisHosts;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The password used to connect to Redis")
    private String redisPassword;
    @FieldDoc(required=true, defaultValue="0", help="The Redis database to connect to")
    private int redisDatabase = 0;
    @FieldDoc(required=false, defaultValue="Standalone", help="The client mode to use when interacting with the Redis cluster. Possible values [Standalone, Cluster]")
    private String clientMode = "Standalone";
    @FieldDoc(required=false, defaultValue="true", help="Flag to determine if the Redis client should automatically reconnect")
    private boolean autoReconnect = true;
    @FieldDoc(required=false, defaultValue="2147483647", help="The maximum number of queued requests to Redis")
    private int requestQueue = Integer.MAX_VALUE;
    @FieldDoc(required=false, defaultValue="false", help="Flag to enable TCP no delay should be used")
    private boolean tcpNoDelay = false;
    @FieldDoc(required=false, defaultValue="false", help="Flag to enable a keepalive to Redis")
    private boolean keepAlive = false;
    @FieldDoc(required=false, defaultValue="10000", help="The amount of time in milliseconds to wait before timing out when connecting")
    private long connectTimeout = 10000L;

    public void validate() {
        Preconditions.checkNotNull((Object)this.clientMode, (Object)"clientMode property not set.");
    }

    public List<HostAndPort> getHostAndPorts() {
        String[] hosts;
        ArrayList hostAndPorts = Lists.newArrayList();
        for (String host : hosts = StringUtils.split((String)this.redisHosts, (String)",")) {
            HostAndPort hostAndPort = HostAndPort.fromString((String)host);
            hostAndPorts.add(hostAndPort);
        }
        return hostAndPorts;
    }

    @Generated
    public RedisAbstractConfig() {
    }

    @Generated
    public String getRedisHosts() {
        return this.redisHosts;
    }

    @Generated
    public String getRedisPassword() {
        return this.redisPassword;
    }

    @Generated
    public int getRedisDatabase() {
        return this.redisDatabase;
    }

    @Generated
    public String getClientMode() {
        return this.clientMode;
    }

    @Generated
    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Generated
    public int getRequestQueue() {
        return this.requestQueue;
    }

    @Generated
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Generated
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public RedisAbstractConfig setRedisHosts(String redisHosts) {
        this.redisHosts = redisHosts;
        return this;
    }

    @Generated
    public RedisAbstractConfig setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    @Generated
    public RedisAbstractConfig setRedisDatabase(int redisDatabase) {
        this.redisDatabase = redisDatabase;
        return this;
    }

    @Generated
    public RedisAbstractConfig setClientMode(String clientMode) {
        this.clientMode = clientMode;
        return this;
    }

    @Generated
    public RedisAbstractConfig setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    @Generated
    public RedisAbstractConfig setRequestQueue(int requestQueue) {
        this.requestQueue = requestQueue;
        return this;
    }

    @Generated
    public RedisAbstractConfig setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @Generated
    public RedisAbstractConfig setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Generated
    public RedisAbstractConfig setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisAbstractConfig)) {
            return false;
        }
        RedisAbstractConfig other = (RedisAbstractConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRedisDatabase() != other.getRedisDatabase()) {
            return false;
        }
        if (this.isAutoReconnect() != other.isAutoReconnect()) {
            return false;
        }
        if (this.getRequestQueue() != other.getRequestQueue()) {
            return false;
        }
        if (this.isTcpNoDelay() != other.isTcpNoDelay()) {
            return false;
        }
        if (this.isKeepAlive() != other.isKeepAlive()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        String this$redisHosts = this.getRedisHosts();
        String other$redisHosts = other.getRedisHosts();
        if (this$redisHosts == null ? other$redisHosts != null : !this$redisHosts.equals(other$redisHosts)) {
            return false;
        }
        String this$redisPassword = this.getRedisPassword();
        String other$redisPassword = other.getRedisPassword();
        if (this$redisPassword == null ? other$redisPassword != null : !this$redisPassword.equals(other$redisPassword)) {
            return false;
        }
        String this$clientMode = this.getClientMode();
        String other$clientMode = other.getClientMode();
        return !(this$clientMode == null ? other$clientMode != null : !this$clientMode.equals(other$clientMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedisAbstractConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRedisDatabase();
        result = result * 59 + (this.isAutoReconnect() ? 79 : 97);
        result = result * 59 + this.getRequestQueue();
        result = result * 59 + (this.isTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isKeepAlive() ? 79 : 97);
        long $connectTimeout = this.getConnectTimeout();
        result = result * 59 + (int)($connectTimeout >>> 32 ^ $connectTimeout);
        String $redisHosts = this.getRedisHosts();
        result = result * 59 + ($redisHosts == null ? 43 : $redisHosts.hashCode());
        String $redisPassword = this.getRedisPassword();
        result = result * 59 + ($redisPassword == null ? 43 : $redisPassword.hashCode());
        String $clientMode = this.getClientMode();
        result = result * 59 + ($clientMode == null ? 43 : $clientMode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RedisAbstractConfig(redisHosts=" + this.getRedisHosts() + ", redisPassword=" + this.getRedisPassword() + ", redisDatabase=" + this.getRedisDatabase() + ", clientMode=" + this.getClientMode() + ", autoReconnect=" + this.isAutoReconnect() + ", requestQueue=" + this.getRequestQueue() + ", tcpNoDelay=" + this.isTcpNoDelay() + ", keepAlive=" + this.isKeepAlive() + ", connectTimeout=" + this.getConnectTimeout() + ")";
    }

    public static enum ClientMode {
        STANDALONE,
        CLUSTER;

    }
}

