/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.file.FileSourceConfig;

public class ProcessedFileThread
extends Thread {
    private final BlockingQueue<File> recentlyProcessed;
    private final boolean keepOriginal;
    private final String processedFileSuffix;

    public ProcessedFileThread(FileSourceConfig fileConfig, BlockingQueue<File> recentlyProcessed) {
        this.keepOriginal = Optional.ofNullable(fileConfig.getKeepFile()).orElse(false);
        this.processedFileSuffix = fileConfig.getProcessedFileSuffix();
        this.recentlyProcessed = recentlyProcessed;
    }

    @Override
    public void run() {
        try {
            while (true) {
                File file = this.recentlyProcessed.take();
                this.handle(file);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void handle(File f) {
        if (!this.keepOriginal) {
            try {
                if (StringUtils.isBlank((CharSequence)this.processedFileSuffix)) {
                    Files.deleteIfExists(f.toPath());
                } else {
                    File targetFile = new File(f.getParentFile(), f.getName() + this.processedFileSuffix);
                    Files.move(f.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

