/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.file;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FileSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String inputDirectory;
    private Boolean recurse;
    private Boolean keepFile = Boolean.FALSE;
    private String fileFilter = "[^.].*";
    private String pathFilter;
    private Integer minimumFileAge;
    private Long maximumFileAge;
    private Integer minimumSize;
    private Double maximumSize;
    private Boolean ignoreHiddenFiles;
    private Long pollingInterval;
    private Integer numWorkers = 1;
    private String processedFileSuffix;

    public static FileSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (FileSourceConfig)mapper.readValue(new File(yamlFile), FileSourceConfig.class);
    }

    public static FileSourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (FileSourceConfig)mapper.readValue(mapper.writeValueAsString(map), FileSourceConfig.class);
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.inputDirectory)) {
            throw new IllegalArgumentException("Required property not set.");
        }
        if (Files.notExists(Paths.get(this.inputDirectory, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new IllegalArgumentException("Specified input directory does not exist");
        }
        if (!Files.isReadable(Paths.get(this.inputDirectory, new String[0]))) {
            throw new IllegalArgumentException("Specified input directory is not readable");
        }
        if (!Optional.ofNullable(this.keepFile).orElse(false).booleanValue() && !Files.isWritable(Paths.get(this.inputDirectory, new String[0]))) {
            throw new IllegalArgumentException("You have requested the consumed files to be deleted, but the source directory is not writeable.");
        }
        if (StringUtils.isNotBlank((CharSequence)this.fileFilter)) {
            try {
                Pattern.compile(this.fileFilter);
            }
            catch (PatternSyntaxException psEx) {
                throw new IllegalArgumentException("Invalid Regex pattern provided for fileFilter");
            }
        }
        if (this.minimumFileAge != null && Math.signum(this.minimumFileAge.intValue()) < 0.0f) {
            throw new IllegalArgumentException("The property minimumFileAge must be non-negative");
        }
        if (this.maximumFileAge != null && Math.signum(this.maximumFileAge.longValue()) < 0.0f) {
            throw new IllegalArgumentException("The property maximumFileAge must be non-negative");
        }
        if (this.minimumSize != null && Math.signum(this.minimumSize.intValue()) < 0.0f) {
            throw new IllegalArgumentException("The property minimumSize must be non-negative");
        }
        if (this.maximumSize != null && Math.signum(this.maximumSize) < 0.0) {
            throw new IllegalArgumentException("The property maximumSize must be non-negative");
        }
        if (this.pollingInterval != null && this.pollingInterval <= 0L) {
            throw new IllegalArgumentException("The property pollingInterval must be greater than zero");
        }
        if (this.numWorkers != null && this.numWorkers <= 0) {
            throw new IllegalArgumentException("The property numWorkers must be greater than zero");
        }
        if (this.processedFileSuffix != null && this.keepFile.booleanValue()) {
            throw new IllegalArgumentException("The property keepFile must be false if the property processedFileSuffix is set");
        }
    }

    @Generated
    public FileSourceConfig() {
    }

    @Generated
    public String getInputDirectory() {
        return this.inputDirectory;
    }

    @Generated
    public Boolean getRecurse() {
        return this.recurse;
    }

    @Generated
    public Boolean getKeepFile() {
        return this.keepFile;
    }

    @Generated
    public String getFileFilter() {
        return this.fileFilter;
    }

    @Generated
    public String getPathFilter() {
        return this.pathFilter;
    }

    @Generated
    public Integer getMinimumFileAge() {
        return this.minimumFileAge;
    }

    @Generated
    public Long getMaximumFileAge() {
        return this.maximumFileAge;
    }

    @Generated
    public Integer getMinimumSize() {
        return this.minimumSize;
    }

    @Generated
    public Double getMaximumSize() {
        return this.maximumSize;
    }

    @Generated
    public Boolean getIgnoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    @Generated
    public Long getPollingInterval() {
        return this.pollingInterval;
    }

    @Generated
    public Integer getNumWorkers() {
        return this.numWorkers;
    }

    @Generated
    public String getProcessedFileSuffix() {
        return this.processedFileSuffix;
    }

    @Generated
    public FileSourceConfig setInputDirectory(String inputDirectory) {
        this.inputDirectory = inputDirectory;
        return this;
    }

    @Generated
    public FileSourceConfig setRecurse(Boolean recurse) {
        this.recurse = recurse;
        return this;
    }

    @Generated
    public FileSourceConfig setKeepFile(Boolean keepFile) {
        this.keepFile = keepFile;
        return this;
    }

    @Generated
    public FileSourceConfig setFileFilter(String fileFilter) {
        this.fileFilter = fileFilter;
        return this;
    }

    @Generated
    public FileSourceConfig setPathFilter(String pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    @Generated
    public FileSourceConfig setMinimumFileAge(Integer minimumFileAge) {
        this.minimumFileAge = minimumFileAge;
        return this;
    }

    @Generated
    public FileSourceConfig setMaximumFileAge(Long maximumFileAge) {
        this.maximumFileAge = maximumFileAge;
        return this;
    }

    @Generated
    public FileSourceConfig setMinimumSize(Integer minimumSize) {
        this.minimumSize = minimumSize;
        return this;
    }

    @Generated
    public FileSourceConfig setMaximumSize(Double maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    @Generated
    public FileSourceConfig setIgnoreHiddenFiles(Boolean ignoreHiddenFiles) {
        this.ignoreHiddenFiles = ignoreHiddenFiles;
        return this;
    }

    @Generated
    public FileSourceConfig setPollingInterval(Long pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    @Generated
    public FileSourceConfig setNumWorkers(Integer numWorkers) {
        this.numWorkers = numWorkers;
        return this;
    }

    @Generated
    public FileSourceConfig setProcessedFileSuffix(String processedFileSuffix) {
        this.processedFileSuffix = processedFileSuffix;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSourceConfig)) {
            return false;
        }
        FileSourceConfig other = (FileSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$recurse = this.getRecurse();
        Boolean other$recurse = other.getRecurse();
        if (this$recurse == null ? other$recurse != null : !((Object)this$recurse).equals(other$recurse)) {
            return false;
        }
        Boolean this$keepFile = this.getKeepFile();
        Boolean other$keepFile = other.getKeepFile();
        if (this$keepFile == null ? other$keepFile != null : !((Object)this$keepFile).equals(other$keepFile)) {
            return false;
        }
        Integer this$minimumFileAge = this.getMinimumFileAge();
        Integer other$minimumFileAge = other.getMinimumFileAge();
        if (this$minimumFileAge == null ? other$minimumFileAge != null : !((Object)this$minimumFileAge).equals(other$minimumFileAge)) {
            return false;
        }
        Long this$maximumFileAge = this.getMaximumFileAge();
        Long other$maximumFileAge = other.getMaximumFileAge();
        if (this$maximumFileAge == null ? other$maximumFileAge != null : !((Object)this$maximumFileAge).equals(other$maximumFileAge)) {
            return false;
        }
        Integer this$minimumSize = this.getMinimumSize();
        Integer other$minimumSize = other.getMinimumSize();
        if (this$minimumSize == null ? other$minimumSize != null : !((Object)this$minimumSize).equals(other$minimumSize)) {
            return false;
        }
        Double this$maximumSize = this.getMaximumSize();
        Double other$maximumSize = other.getMaximumSize();
        if (this$maximumSize == null ? other$maximumSize != null : !((Object)this$maximumSize).equals(other$maximumSize)) {
            return false;
        }
        Boolean this$ignoreHiddenFiles = this.getIgnoreHiddenFiles();
        Boolean other$ignoreHiddenFiles = other.getIgnoreHiddenFiles();
        if (this$ignoreHiddenFiles == null ? other$ignoreHiddenFiles != null : !((Object)this$ignoreHiddenFiles).equals(other$ignoreHiddenFiles)) {
            return false;
        }
        Long this$pollingInterval = this.getPollingInterval();
        Long other$pollingInterval = other.getPollingInterval();
        if (this$pollingInterval == null ? other$pollingInterval != null : !((Object)this$pollingInterval).equals(other$pollingInterval)) {
            return false;
        }
        Integer this$numWorkers = this.getNumWorkers();
        Integer other$numWorkers = other.getNumWorkers();
        if (this$numWorkers == null ? other$numWorkers != null : !((Object)this$numWorkers).equals(other$numWorkers)) {
            return false;
        }
        String this$inputDirectory = this.getInputDirectory();
        String other$inputDirectory = other.getInputDirectory();
        if (this$inputDirectory == null ? other$inputDirectory != null : !this$inputDirectory.equals(other$inputDirectory)) {
            return false;
        }
        String this$fileFilter = this.getFileFilter();
        String other$fileFilter = other.getFileFilter();
        if (this$fileFilter == null ? other$fileFilter != null : !this$fileFilter.equals(other$fileFilter)) {
            return false;
        }
        String this$pathFilter = this.getPathFilter();
        String other$pathFilter = other.getPathFilter();
        if (this$pathFilter == null ? other$pathFilter != null : !this$pathFilter.equals(other$pathFilter)) {
            return false;
        }
        String this$processedFileSuffix = this.getProcessedFileSuffix();
        String other$processedFileSuffix = other.getProcessedFileSuffix();
        return !(this$processedFileSuffix == null ? other$processedFileSuffix != null : !this$processedFileSuffix.equals(other$processedFileSuffix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileSourceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $recurse = this.getRecurse();
        result = result * 59 + ($recurse == null ? 43 : ((Object)$recurse).hashCode());
        Boolean $keepFile = this.getKeepFile();
        result = result * 59 + ($keepFile == null ? 43 : ((Object)$keepFile).hashCode());
        Integer $minimumFileAge = this.getMinimumFileAge();
        result = result * 59 + ($minimumFileAge == null ? 43 : ((Object)$minimumFileAge).hashCode());
        Long $maximumFileAge = this.getMaximumFileAge();
        result = result * 59 + ($maximumFileAge == null ? 43 : ((Object)$maximumFileAge).hashCode());
        Integer $minimumSize = this.getMinimumSize();
        result = result * 59 + ($minimumSize == null ? 43 : ((Object)$minimumSize).hashCode());
        Double $maximumSize = this.getMaximumSize();
        result = result * 59 + ($maximumSize == null ? 43 : ((Object)$maximumSize).hashCode());
        Boolean $ignoreHiddenFiles = this.getIgnoreHiddenFiles();
        result = result * 59 + ($ignoreHiddenFiles == null ? 43 : ((Object)$ignoreHiddenFiles).hashCode());
        Long $pollingInterval = this.getPollingInterval();
        result = result * 59 + ($pollingInterval == null ? 43 : ((Object)$pollingInterval).hashCode());
        Integer $numWorkers = this.getNumWorkers();
        result = result * 59 + ($numWorkers == null ? 43 : ((Object)$numWorkers).hashCode());
        String $inputDirectory = this.getInputDirectory();
        result = result * 59 + ($inputDirectory == null ? 43 : $inputDirectory.hashCode());
        String $fileFilter = this.getFileFilter();
        result = result * 59 + ($fileFilter == null ? 43 : $fileFilter.hashCode());
        String $pathFilter = this.getPathFilter();
        result = result * 59 + ($pathFilter == null ? 43 : $pathFilter.hashCode());
        String $processedFileSuffix = this.getProcessedFileSuffix();
        result = result * 59 + ($processedFileSuffix == null ? 43 : $processedFileSuffix.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FileSourceConfig(inputDirectory=" + this.getInputDirectory() + ", recurse=" + this.getRecurse() + ", keepFile=" + this.getKeepFile() + ", fileFilter=" + this.getFileFilter() + ", pathFilter=" + this.getPathFilter() + ", minimumFileAge=" + this.getMinimumFileAge() + ", maximumFileAge=" + this.getMaximumFileAge() + ", minimumSize=" + this.getMinimumSize() + ", maximumSize=" + this.getMaximumSize() + ", ignoreHiddenFiles=" + this.getIgnoreHiddenFiles() + ", pollingInterval=" + this.getPollingInterval() + ", numWorkers=" + this.getNumWorkers() + ", processedFileSuffix=" + this.getProcessedFileSuffix() + ")";
    }
}

