/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.MessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.CodecManager;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ClusterSerializableUtils;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.shareddata.impl.ClusterSerializable;

public class ClusterSerializableCodec
implements MessageCodec<ClusterSerializable, ClusterSerializable> {
    private final CodecManager codecManager;

    public ClusterSerializableCodec(CodecManager codecManager) {
        this.codecManager = codecManager;
    }

    @Override
    public void encodeToWire(Buffer buffer, ClusterSerializable obj) {
        byte[] classNameBytes = obj.getClass().getName().getBytes(CharsetUtil.UTF_8);
        buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
        obj.writeToBuffer(buffer);
    }

    @Override
    public ClusterSerializable decodeFromWire(int pos, Buffer buffer) {
        ClusterSerializable clusterSerializable;
        int len;
        byte[] classNameBytes;
        String className;
        if (!this.codecManager.acceptClusterSerializable(className = new String(classNameBytes = buffer.getBytes(pos += 4, pos + (len = buffer.getInt(pos))), CharsetUtil.UTF_8))) {
            throw new RuntimeException("Class not allowed: " + className);
        }
        pos += len;
        try {
            Class<?> clazz = ClusterSerializableCodec.getClassLoader().loadClass(className);
            clusterSerializable = (ClusterSerializable)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        clusterSerializable.readFromBuffer(pos, buffer);
        return clusterSerializable;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl != null ? tccl : ClusterSerializableCodec.class.getClassLoader();
    }

    @Override
    public ClusterSerializable transform(ClusterSerializable obj) {
        return ClusterSerializableUtils.copy(obj);
    }

    @Override
    public String name() {
        return "clusterserializable";
    }

    @Override
    public byte systemCodecID() {
        return 16;
    }
}

