/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.cookie;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.Cookie;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.IOUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminCommand
extends BookieCommand<AdminFlags> {
    static final Logger LOG = LoggerFactory.getLogger(AdminCommand.class);
    private static final String NAME = "admin";
    private static final String DESC = "Command to update cookie";
    private File[] journalDirectories;
    private File[] ledgerDirectories;
    private File[] indexDirectories;

    public AdminCommand() {
        this(new AdminFlags());
    }

    private AdminCommand(AdminFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, AdminFlags cmdFlags) {
        this.initDirectory(conf);
        try {
            return this.update(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private void initDirectory(ServerConfiguration bkConf) {
        this.journalDirectories = BookieImpl.getCurrentDirectories(bkConf.getJournalDirs());
        this.ledgerDirectories = BookieImpl.getCurrentDirectories(bkConf.getLedgerDirs());
        this.indexDirectories = null == bkConf.getIndexDirs() ? this.ledgerDirectories : BookieImpl.getCurrentDirectories(bkConf.getIndexDirs());
    }

    private boolean update(ServerConfiguration conf, AdminFlags flags) throws Exception {
        boolean useHostName = flags.hostname;
        if (flags.hostname || flags.ip) {
            if (!conf.getUseHostNameAsBookieID() && useHostName) {
                LOG.error("Expects configuration useHostNameAsBookieID=true as the option value");
                return false;
            }
            if (conf.getUseHostNameAsBookieID() && !useHostName) {
                LOG.error("Expects configuration useHostNameAsBookieID=false as the option value");
                return false;
            }
            return this.updateBookieIdInCookie(conf, flags.hostname);
        }
        if (flags.expandstorage) {
            conf.setAllowStorageExpansion(true);
            return this.expandStorage(conf);
        }
        if (flags.list) {
            return this.listOrDeleteCookies(conf, false, false);
        }
        if (flags.delete) {
            return this.listOrDeleteCookies(conf, true, flags.force);
        }
        LOG.error("Invalid command !");
        this.usage();
        return false;
    }

    private boolean updateBookieIdInCookie(ServerConfiguration bkConf, boolean useHostname) throws Exception {
        return MetadataDrivers.runFunctionWithRegistrationManager(bkConf, arg_0 -> this.lambda$updateBookieIdInCookie$0(bkConf, useHostname, arg_0));
    }

    private boolean verifyCookie(Cookie oldCookie, File dir) throws IOException {
        try {
            Cookie cookie = Cookie.readFromDirectory(dir);
            cookie.verify(oldCookie);
        }
        catch (BookieException.InvalidCookieException e) {
            return false;
        }
        return true;
    }

    private boolean expandStorage(ServerConfiguration bkConf) throws Exception {
        return MetadataDrivers.runFunctionWithMetadataBookieDriver(bkConf, driver -> {
            ArrayList<File> allLedgerDirs = Lists.newArrayList();
            allLedgerDirs.addAll(Arrays.asList(this.ledgerDirectories));
            if (this.indexDirectories != this.ledgerDirectories) {
                allLedgerDirs.addAll(Arrays.asList(this.indexDirectories));
            }
            try (RegistrationManager registrationManager = driver.createRegistrationManager();){
                LegacyCookieValidation validation = new LegacyCookieValidation(bkConf, registrationManager);
                ArrayList<File> dirs = Lists.newArrayList();
                dirs.addAll(Arrays.asList(this.journalDirectories));
                dirs.addAll(allLedgerDirs);
                validation.checkCookies(dirs);
                Boolean bl = true;
                return bl;
            }
            catch (BookieException e) {
                LOG.error("Exception while updating cookie for storage expansion", (Throwable)e);
                return false;
            }
        });
    }

    private boolean listOrDeleteCookies(ServerConfiguration bkConf, boolean delete, boolean force) throws Exception {
        BookieId bookieAddress = BookieImpl.getBookieId(bkConf);
        File[] journalDirs = bkConf.getJournalDirs();
        File[] ledgerDirs = bkConf.getLedgerDirs();
        File[] indexDirs = bkConf.getIndexDirs();
        File[] allDirs = ArrayUtils.addAll(journalDirs, ledgerDirs);
        if (indexDirs != null) {
            allDirs = ArrayUtils.addAll(allDirs, indexDirs);
        }
        File[] allCurDirs = BookieImpl.getCurrentDirectories(allDirs);
        LinkedList<File> allVersionFiles = new LinkedList<File>();
        for (File curDir : allCurDirs) {
            File versionFile = new File(curDir, "VERSION");
            if (!versionFile.exists()) continue;
            allVersionFiles.add(versionFile);
        }
        if (!allVersionFiles.isEmpty()) {
            if (delete) {
                boolean confirm = force;
                if (!confirm) {
                    confirm = IOUtils.confirmPrompt("Are you sure you want to delete Cookies locally?");
                }
                if (confirm) {
                    for (File verFile : allVersionFiles) {
                        if (verFile.delete()) continue;
                        LOG.error("Failed to delete Local cookie file {}. So aborting deletecookie of Bookie: {}", (Object)verFile, (Object)bookieAddress);
                        return false;
                    }
                    LOG.info("Deleted Local Cookies of Bookie: {}", (Object)bookieAddress);
                } else {
                    LOG.info("Skipping deleting local Cookies of Bookie: {}", (Object)bookieAddress);
                }
            } else {
                LOG.info("Listing local Cookie Files of Bookie: {}", (Object)bookieAddress);
                for (File verFile : allVersionFiles) {
                    LOG.info(verFile.getCanonicalPath());
                }
            }
        } else {
            LOG.info("No local cookies for Bookie: {}", (Object)bookieAddress);
        }
        return MetadataDrivers.runFunctionWithRegistrationManager(bkConf, rm -> {
            try {
                Versioned<Cookie> cookie = null;
                try {
                    cookie = Cookie.readFromRegistrationManager(rm, bookieAddress);
                }
                catch (BookieException.CookieNotFoundException nne) {
                    LOG.info("No cookie for {} in metadata store", (Object)bookieAddress);
                    return true;
                }
                if (delete) {
                    boolean confirm = force;
                    if (!confirm) {
                        confirm = IOUtils.confirmPrompt("Are you sure you want to delete Cookies from metadata store?");
                    }
                    if (confirm) {
                        cookie.getValue().deleteFromRegistrationManager((RegistrationManager)rm, bkConf, cookie.getVersion());
                        LOG.info("Deleted Cookie from metadata store for Bookie: {}", (Object)bookieAddress);
                    } else {
                        LOG.info("Skipping deleting cookie from metadata store for Bookie: {}", (Object)bookieAddress);
                    }
                }
            }
            catch (IOException | BookieException e) {
                return false;
            }
            return true;
        });
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Boolean lambda$updateBookieIdInCookie$0(ServerConfiguration bkConf, boolean useHostname, RegistrationManager rm) {
        try {
            conf = new ServerConfiguration(bkConf);
            newBookieId = BookieImpl.getBookieId(conf).toString();
            oldCookie = null;
            try {
                conf.setUseHostNameAsBookieID(useHostname == false);
                oldCookie = Cookie.readFromRegistrationManager(rm, conf);
            }
            catch (BookieException.CookieNotFoundException nne) {
                AdminCommand.LOG.error("Either cookie already updated with UseHostNameAsBookieID={} or no cookie exists!", (Object)useHostname, (Object)nne);
                return false;
            }
            newCookie = Cookie.newBuilder(oldCookie.getValue()).setBookieId(newBookieId).build();
            hasCookieUpdatedInDirs = this.verifyCookie(newCookie, this.journalDirectories[0]);
            for (File dir : this.ledgerDirectories) {
                hasCookieUpdatedInDirs &= this.verifyCookie(newCookie, dir);
            }
            if (this.indexDirectories != this.ledgerDirectories) {
                for (File dir : this.indexDirectories) {
                    hasCookieUpdatedInDirs &= this.verifyCookie(newCookie, dir);
                }
            }
            if (hasCookieUpdatedInDirs) {
                try {
                    conf.setUseHostNameAsBookieID(useHostname);
                    Cookie.readFromRegistrationManager(rm, conf);
                    conf.setUseHostNameAsBookieID(useHostname == false);
                    oldCookie.getValue().deleteFromRegistrationManager(rm, conf, oldCookie.getVersion());
                    return true;
                }
                catch (BookieException.CookieNotFoundException nne) {
                    if (!AdminCommand.LOG.isDebugEnabled()) ** GOTO lbl49
                    AdminCommand.LOG.debug("Ignoring, cookie will be written to zookeeper");
                }
            } else {
                for (File journalDirectory : this.journalDirectories) {
                    newCookie.writeToDirectory(journalDirectory);
                    AdminCommand.LOG.info("Updated cookie file present in journalDirectory {}", (Object)journalDirectory);
                }
                for (File dir : this.ledgerDirectories) {
                    newCookie.writeToDirectory(dir);
                }
                AdminCommand.LOG.info("Updated cookie file present in ledgerDirectories {}", (Object)this.ledgerDirectories);
                if (this.ledgerDirectories != this.indexDirectories) {
                    for (File dir : this.indexDirectories) {
                        newCookie.writeToDirectory(dir);
                    }
                    AdminCommand.LOG.info("Updated cookie file present in indexDirectories {}", (Object)this.indexDirectories);
                }
            }
lbl49:
            // 5 sources

            conf.setUseHostNameAsBookieID(useHostname);
            newCookie.writeToRegistrationManager(rm, conf, Version.NEW);
            conf.setUseHostNameAsBookieID(useHostname == false);
            oldCookie.getValue().deleteFromRegistrationManager(rm, conf, oldCookie.getVersion());
            return true;
        }
        catch (IOException | BookieException ioe) {
            AdminCommand.LOG.error("IOException during cookie updation!", (Throwable)ioe);
            return false;
        }
    }

    public static class AdminFlags
    extends CliFlags {
        @Parameter(names={"-host", "--hostname"}, description="Expects config useHostNameAsBookieID=true as the option value")
        private boolean hostname;
        @Parameter(names={"-p", "-ip"}, description="Expects config useHostNameAsBookieID=false as the option value")
        private boolean ip;
        @Parameter(names={"-e", "--expandstorage"}, description="Add new empty ledger/index directories")
        private boolean expandstorage;
        @Parameter(names={"-l", "--list"}, description="List paths of all the cookies present locally and on zooKeeper")
        private boolean list;
        @Parameter(names={"-d", "--delete"}, description="Delete cookie both locally and in zooKeeper")
        private boolean delete;
        @Parameter(names={"-f", "--force"}, description="Force delete cookie")
        private boolean force;

        public AdminFlags hostname(boolean hostname) {
            this.hostname = hostname;
            return this;
        }

        public AdminFlags ip(boolean ip) {
            this.ip = ip;
            return this;
        }

        public AdminFlags expandstorage(boolean expandstorage) {
            this.expandstorage = expandstorage;
            return this;
        }

        public AdminFlags list(boolean list) {
            this.list = list;
            return this;
        }

        public AdminFlags delete(boolean delete) {
            this.delete = delete;
            return this;
        }

        public AdminFlags force(boolean force) {
            this.force = force;
            return this;
        }
    }
}

