/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger.AbstractSlogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger.Slogger;

public class ConsoleSlogger
extends AbstractSlogger {
    private static final int MAX_STACKTRACE_ELEMENTS = 20;
    private static final int MAX_CAUSES = 10;
    private final Class<?> clazz;

    ConsoleSlogger() {
        this(ConsoleSlogger.class);
    }

    ConsoleSlogger(Class<?> clazz) {
        this(clazz, Collections.emptyList());
    }

    ConsoleSlogger(Class<?> clazz, Iterable<Object> parent) {
        super(parent);
        this.clazz = clazz;
    }

    @Override
    protected Slogger newSlogger(Optional<Class<?>> clazz, Iterable<Object> parent) {
        return new ConsoleSlogger(clazz.orElse(ConsoleSlogger.class), parent);
    }

    @Override
    protected void doLog(AbstractSlogger.Level level, Enum<?> event, String message, Throwable throwable, List<Object> keyValues) {
        String nowAsISO = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        ConsoleSlogger.keyValue(builder, "date", nowAsISO);
        builder.append(",");
        ConsoleSlogger.keyValue(builder, "level", level.toString());
        if (event != null) {
            builder.append(",");
            ConsoleSlogger.keyValue(builder, "event", event.toString());
        }
        if (message != null) {
            builder.append(",");
            ConsoleSlogger.keyValue(builder, "message", message);
        }
        for (int i = 0; i < keyValues.size(); i += 2) {
            builder.append(",");
            ConsoleSlogger.keyValue(builder, keyValues.get(i).toString(), keyValues.get(i + 1).toString());
        }
        if (throwable != null) {
            builder.append(",");
            Throwable cause = throwable;
            StringBuilder stacktrace = new StringBuilder();
            int causes = 0;
            while (cause != null) {
                stacktrace.append("[").append(cause.getMessage()).append("] at ");
                int i = 0;
                for (StackTraceElement element : cause.getStackTrace()) {
                    if (i++ > 20) {
                        stacktrace.append("<|[frames omitted]");
                    }
                    stacktrace.append("<|").append(element.toString());
                }
                if ((cause = cause.getCause()) == null) continue;
                if (causes++ > 10) {
                    stacktrace.append(" [max causes exceeded] ");
                    break;
                }
                stacktrace.append(" caused by ");
            }
            ConsoleSlogger.keyValue(builder, "exception", stacktrace.toString());
        }
        builder.append("}");
        System.out.println(builder);
    }

    private static void keyValue(StringBuilder sb, String key, String value) {
        ConsoleSlogger.quotedAppend(sb, key);
        sb.append(":");
        ConsoleSlogger.quotedAppend(sb, value);
    }

    private static void quotedAppend(StringBuilder sb, String str) {
        sb.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c < ' ') {
                sb.append(String.format("\\u%04X", c));
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
    }
}

