/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.proxy;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.CallOptions;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Channel;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ClientCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Metadata;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerCallHandler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.proxy.ChannelFinder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.proxy.ProxyCall;

class ProxyServerCallHandler<ReqT, RespT>
implements ServerCallHandler<ReqT, RespT> {
    private final ChannelFinder finder;
    private final CallOptions callOptions;

    ProxyServerCallHandler(ChannelFinder finder, CallOptions callOptions) {
        this.finder = finder;
        this.callOptions = callOptions;
    }

    public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> serverCall, Metadata headers) {
        Channel channel = this.finder.findChannel(serverCall, headers);
        ClientCall clientCall = channel.newCall(serverCall.getMethodDescriptor(), this.callOptions);
        ProxyCall<ReqT, RespT> proxyCall = new ProxyCall<ReqT, RespT>(serverCall, clientCall);
        clientCall.start((ClientCall.Listener)proxyCall.getClientCallListener(), headers);
        serverCall.request(1);
        clientCall.request(1);
        return proxyCall.getServerCallListener();
    }
}

