/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.RateLimiter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetadataUpdateLoop {
    static final Logger LOG = LoggerFactory.getLogger(MetadataUpdateLoop.class);
    private final LedgerManager lm;
    private final long ledgerId;
    private final Supplier<Versioned<LedgerMetadata>> currentLocalValue;
    private final NeedsUpdatePredicate needsTransformation;
    private final MetadataTransform transform;
    private final LocalValueUpdater updateLocalValue;
    private final RateLimiter throttler;
    private final String logContext;
    private volatile int writeLoopCount = 0;
    private static final AtomicIntegerFieldUpdater<MetadataUpdateLoop> WRITE_LOOP_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MetadataUpdateLoop.class, "writeLoopCount");

    MetadataUpdateLoop(LedgerManager lm, long ledgerId, Supplier<Versioned<LedgerMetadata>> currentLocalValue, NeedsUpdatePredicate needsTransformation, MetadataTransform transform, LocalValueUpdater updateLocalValue) {
        this(lm, ledgerId, currentLocalValue, needsTransformation, transform, updateLocalValue, null);
    }

    MetadataUpdateLoop(LedgerManager lm, long ledgerId, Supplier<Versioned<LedgerMetadata>> currentLocalValue, NeedsUpdatePredicate needsTransformation, MetadataTransform transform, LocalValueUpdater updateLocalValue, RateLimiter throttler) {
        this.lm = lm;
        this.ledgerId = ledgerId;
        this.currentLocalValue = currentLocalValue;
        this.needsTransformation = needsTransformation;
        this.transform = transform;
        this.updateLocalValue = updateLocalValue;
        this.throttler = throttler;
        this.logContext = String.format("UpdateLoop(ledgerId=%d,loopId=%08x)", ledgerId, System.identityHashCode(this));
    }

    CompletableFuture<Versioned<LedgerMetadata>> run() {
        CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        this.writeLoop(this.currentLocalValue.get(), promise);
        return promise;
    }

    private void writeLoop(Versioned<LedgerMetadata> currentLocal, CompletableFuture<Versioned<LedgerMetadata>> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} starting write loop iteration, attempt {}", (Object)this.logContext, (Object)WRITE_LOOP_COUNT_UPDATER.incrementAndGet(this));
        }
        try {
            if (this.needsTransformation.needsUpdate(currentLocal.getValue())) {
                LedgerMetadata transformed = this.transform.transform(currentLocal.getValue());
                if (this.throttler != null) {
                    this.throttler.acquire();
                }
                this.lm.writeLedgerMetadata(this.ledgerId, transformed, currentLocal.getVersion()).whenComplete((writtenMetadata, ex) -> {
                    if (ex == null) {
                        if (this.updateLocalValue.updateValue(currentLocal, (Versioned<LedgerMetadata>)writtenMetadata)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} success", (Object)this.logContext);
                            }
                            promise.complete((Versioned<LedgerMetadata>)writtenMetadata);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} local value changed while we were writing, try again", (Object)this.logContext);
                            }
                            this.writeLoop(this.currentLocalValue.get(), promise);
                        }
                    } else if (ex instanceof BKException.BKMetadataVersionException) {
                        LOG.info("{} conflict writing metadata to store, update local value and try again", (Object)this.logContext);
                        this.updateLocalValueFromStore(this.ledgerId).whenComplete((readMetadata, readEx) -> {
                            if (readEx == null) {
                                this.writeLoop((Versioned<LedgerMetadata>)readMetadata, promise);
                            } else {
                                promise.completeExceptionally((Throwable)readEx);
                            }
                        });
                    } else {
                        LOG.error("{} Error writing metadata to store", (Object)this.logContext, ex);
                        promise.completeExceptionally((Throwable)ex);
                    }
                });
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Update not needed, completing", (Object)this.logContext);
                }
                promise.complete(currentLocal);
            }
        }
        catch (Exception e) {
            LOG.error("{} Exception updating", (Object)this.logContext, (Object)e);
            promise.completeExceptionally(e);
        }
    }

    private CompletableFuture<Versioned<LedgerMetadata>> updateLocalValueFromStore(long ledgerId) {
        CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        this.readLoop(ledgerId, promise);
        return promise;
    }

    private void readLoop(long ledgerId, CompletableFuture<Versioned<LedgerMetadata>> promise) {
        Versioned<LedgerMetadata> current = this.currentLocalValue.get();
        this.lm.readLedgerMetadata(ledgerId).whenComplete((read, exception) -> {
            if (exception != null) {
                LOG.error("{} Failed to read metadata from store", (Object)this.logContext, exception);
                promise.completeExceptionally((Throwable)exception);
            } else if (current.getVersion().compare(read.getVersion()) == Version.Occurred.CONCURRENTLY) {
                promise.complete(current);
            } else if (this.updateLocalValue.updateValue(current, (Versioned<LedgerMetadata>)read)) {
                promise.complete((Versioned<LedgerMetadata>)read);
            } else {
                this.readLoop(ledgerId, promise);
            }
        });
    }

    static interface LocalValueUpdater {
        public boolean updateValue(Versioned<LedgerMetadata> var1, Versioned<LedgerMetadata> var2);
    }

    static interface MetadataTransform {
        public LedgerMetadata transform(LedgerMetadata var1) throws Exception;
    }

    static interface NeedsUpdatePredicate {
        public boolean needsUpdate(LedgerMetadata var1) throws Exception;
    }
}

