/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.directentrylogger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.EntryLogIds;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.directentrylogger.Events;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger.Slogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.LedgerDirUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.tuple.Pair;

public class EntryLogIdsImpl
implements EntryLogIds {
    private final LedgerDirsManager ledgerDirsManager;
    private final Slogger slog;
    private int nextId;
    private int maxId;

    public EntryLogIdsImpl(LedgerDirsManager ledgerDirsManager, Slogger slog) throws IOException {
        this.ledgerDirsManager = ledgerDirsManager;
        this.slog = slog.ctx(EntryLogIdsImpl.class);
        this.findLargestGap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextId() throws IOException {
        while (true) {
            EntryLogIdsImpl entryLogIdsImpl = this;
            synchronized (entryLogIdsImpl) {
                int current = this.nextId++;
                if (this.nextId != this.maxId) {
                    return current;
                }
                this.findLargestGap();
            }
        }
    }

    private void findLargestGap() throws IOException {
        long start = System.nanoTime();
        ArrayList<Integer> currentIds = new ArrayList<Integer>();
        for (File ledgerDir : this.ledgerDirsManager.getAllLedgerDirs()) {
            currentIds.addAll(LedgerDirUtil.logIdsInDirectory(ledgerDir));
            currentIds.addAll(LedgerDirUtil.compactedLogIdsInDirectory(ledgerDir));
        }
        Pair<Integer, Integer> gap = LedgerDirUtil.findLargestGap(currentIds);
        this.nextId = gap.getLeft();
        this.maxId = gap.getRight();
        this.slog.kv("dirs", this.ledgerDirsManager.getAllLedgerDirs()).kv("nextId", this.nextId).kv("maxId", this.maxId).kv("durationMs", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)).info(Events.ENTRYLOG_IDS_CANDIDATES_SELECTED);
    }
}

