/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.zstd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.hadoop.HadoopOutputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.zstd.ZstdOutputStream;

class ZstdHadoopOutputStream
extends HadoopOutputStream {
    private final OutputStream out;
    private boolean initialized;
    private ZstdOutputStream zstdOutputStream;

    public ZstdHadoopOutputStream(OutputStream out) {
        this.out = Objects.requireNonNull(out, "out is null");
    }

    @Override
    public void write(int b) throws IOException {
        this.openStreamIfNecessary();
        this.zstdOutputStream.write(b);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.openStreamIfNecessary();
        this.zstdOutputStream.write(buffer, offset, length);
    }

    @Override
    public void finish() throws IOException {
        if (this.zstdOutputStream != null) {
            this.zstdOutputStream.finishWithoutClosingSource();
            this.zstdOutputStream = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.initialized) {
                this.openStreamIfNecessary();
            }
            this.finish();
        }
        finally {
            this.out.close();
        }
    }

    private void openStreamIfNecessary() throws IOException {
        if (this.zstdOutputStream == null) {
            this.initialized = true;
            this.zstdOutputStream = new ZstdOutputStream(this.out);
        }
    }
}

