/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.deflate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.deflate.JdkDeflateHadoopInputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.deflate.JdkDeflateHadoopOutputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.hadoop.HadoopInputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.hadoop.HadoopOutputStream;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.hadoop.HadoopStreams;

public class JdkDeflateHadoopStreams
implements HadoopStreams {
    private static final int BUFFER_SIZE = 8192;

    @Override
    public String getDefaultFileExtension() {
        return ".deflate";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.DefaultCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new JdkDeflateHadoopInputStream(in, 8192);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new JdkDeflateHadoopOutputStream(out, 8192);
    }
}

