/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.RequestUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForceLedgerProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ForceLedgerProcessorV3.class);

    public ForceLedgerProcessorV3(BookkeeperProtocol.Request request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor) {
        super(request, requestHandler, requestProcessor);
    }

    private BookkeeperProtocol.ForceLedgerResponse getForceLedgerResponse() {
        long startTimeNanos = MathUtils.nowInNano();
        BookkeeperProtocol.ForceLedgerRequest forceLedgerRequest = this.request.getForceLedgerRequest();
        long ledgerId = forceLedgerRequest.getLedgerId();
        BookkeeperProtocol.ForceLedgerResponse.Builder forceLedgerResponse = BookkeeperProtocol.ForceLedgerResponse.newBuilder().setLedgerId(ledgerId);
        if (!this.isVersionCompatible()) {
            forceLedgerResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
            return forceLedgerResponse.build();
        }
        BookkeeperInternalCallbacks.WriteCallback wcb = (rc, ledgerId1, entryId, addr, ctx) -> {
            BookkeeperProtocol.StatusCode status;
            Preconditions.checkArgument(entryId == -16384L, "entryId must be METAENTRY_ID_FORCE_LEDGER but was {}", entryId);
            Preconditions.checkArgument(ledgerId1 == ledgerId, "ledgerId must be {} but was {}", ledgerId, ledgerId1);
            if (0 == rc) {
                this.requestProcessor.getRequestStats().getForceLedgerStats().registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            } else {
                this.requestProcessor.getRequestStats().getForceLedgerStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            }
            switch (rc) {
                case 0: {
                    status = BookkeeperProtocol.StatusCode.EOK;
                    break;
                }
                case 101: {
                    status = BookkeeperProtocol.StatusCode.EIO;
                    break;
                }
                default: {
                    status = BookkeeperProtocol.StatusCode.EUA;
                }
            }
            forceLedgerResponse.setStatus(status);
            BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(forceLedgerResponse.getStatus()).setForceLedgerResponse(forceLedgerResponse);
            BookkeeperProtocol.Response resp = response.build();
            this.sendResponse(status, resp, this.requestProcessor.getRequestStats().getForceLedgerRequestStats());
        };
        BookkeeperProtocol.StatusCode status = null;
        try {
            this.requestProcessor.getBookie().forceLedger(ledgerId, wcb, this.requestHandler);
            status = BookkeeperProtocol.StatusCode.EOK;
        }
        catch (Throwable t) {
            logger.error("Unexpected exception while forcing ledger {} : ", (Object)ledgerId, (Object)t);
            status = BookkeeperProtocol.StatusCode.EBADREQ;
        }
        if (!status.equals(BookkeeperProtocol.StatusCode.EOK)) {
            forceLedgerResponse.setStatus(status);
            return forceLedgerResponse.build();
        }
        return null;
    }

    @Override
    public void run() {
        BookkeeperProtocol.ForceLedgerResponse forceLedgerResponse = this.getForceLedgerResponse();
        if (null != forceLedgerResponse) {
            BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(forceLedgerResponse.getStatus()).setForceLedgerResponse(forceLedgerResponse);
            BookkeeperProtocol.Response resp = response.build();
            this.sendResponse(forceLedgerResponse.getStatus(), resp, this.requestProcessor.getRequestStats().getForceLedgerRequestStats());
        }
    }

    @Override
    public String toString() {
        return RequestUtils.toSafeString(this.request);
    }
}

