/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.zk;

import java.util.Optional;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataBookieDriver
extends ZKMetadataDriverBase
implements MetadataBookieDriver {
    private static final Logger log = LoggerFactory.getLogger(ZKMetadataBookieDriver.class);
    ServerConfiguration serverConf;

    @Override
    public synchronized MetadataBookieDriver initialize(ServerConfiguration conf, StatsLogger statsLogger) throws MetadataException {
        super.initialize(conf, statsLogger.scope("bookie"), new BoundExponentialBackoffRetryPolicy(conf.getZkRetryBackoffStartMs(), conf.getZkRetryBackoffMaxMs(), conf.getZkRetryBackoffMaxRetries()), Optional.empty());
        this.serverConf = conf;
        this.statsLogger = statsLogger;
        return this;
    }

    @Override
    public synchronized RegistrationManager createRegistrationManager() {
        ZKRegistrationManager zkRegistrationManager = this.newZKRegistrationManager(this.serverConf, this.zk);
        return zkRegistrationManager;
    }

    @VisibleForTesting
    ZKRegistrationManager newZKRegistrationManager(ServerConfiguration serverConf, ZooKeeper zk) {
        return new ZKRegistrationManager(serverConf, zk);
    }

    @Override
    public void close() {
        super.close();
    }

    static {
        MetadataDrivers.registerBookieDriver("zk", ZKMetadataBookieDriver.class);
    }
}

