/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.collections.GrowableMpScArrayConsumerBlockingQueue;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadExecutor
extends AbstractExecutorService
implements ExecutorService,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(SingleThreadExecutor.class);
    private final BlockingQueue<Runnable> queue;
    private final Thread runner;
    private final boolean rejectExecution;
    private final LongAdder tasksCount = new LongAdder();
    private final LongAdder tasksCompleted = new LongAdder();
    private final LongAdder tasksRejected = new LongAdder();
    private final LongAdder tasksFailed = new LongAdder();
    private volatile State state;
    private final CountDownLatch startLatch;

    public SingleThreadExecutor(ThreadFactory tf) {
        this(tf, 0, false);
    }

    @SuppressFBWarnings(value={"SC_START_IN_CTOR"})
    public SingleThreadExecutor(ThreadFactory tf, int maxQueueCapacity, boolean rejectExecution) {
        if (rejectExecution && maxQueueCapacity == 0) {
            throw new IllegalArgumentException("Executor cannot reject new items if the queue is unbound");
        }
        this.queue = maxQueueCapacity > 0 ? new ArrayBlockingQueue<Runnable>(maxQueueCapacity) : new GrowableMpScArrayConsumerBlockingQueue<Runnable>();
        this.runner = tf.newThread(this);
        this.state = State.Running;
        this.rejectExecution = rejectExecution;
        this.startLatch = new CountDownLatch(1);
        this.runner.start();
        this.startLatch.await();
    }

    @Override
    public void run() {
        try {
            int i;
            int n;
            boolean isInitialized = false;
            ArrayList localTasks = new ArrayList();
            while (this.state == State.Running) {
                if (!isInitialized) {
                    this.startLatch.countDown();
                    isInitialized = true;
                }
                if ((n = this.queue.drainTo(localTasks)) > 0) {
                    for (i = 0; i < n; ++i) {
                        if (this.safeRunTask((Runnable)localTasks.get(i))) continue;
                        return;
                    }
                    localTasks.clear();
                    continue;
                }
                if (this.safeRunTask(this.queue.take())) continue;
                return;
            }
            n = this.queue.drainTo(localTasks);
            for (i = 0; i < n; ++i) {
                this.safeRunTask((Runnable)localTasks.get(i));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            log.error("Exception in executor: {}", (Object)t.getMessage(), (Object)t);
            throw t;
        }
        finally {
            this.state = State.Terminated;
        }
    }

    private boolean safeRunTask(Runnable r) {
        try {
            r.run();
            this.tasksCompleted.increment();
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
            this.tasksFailed.increment();
            log.error("Error while running task: {}", (Object)t.getMessage(), (Object)t);
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.state = State.Shutdown;
        if (this.queue.isEmpty()) {
            this.runner.interrupt();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.state = State.Shutdown;
        this.runner.interrupt();
        ArrayList<Runnable> remainingTasks = new ArrayList<Runnable>();
        this.queue.drainTo(remainingTasks);
        return remainingTasks;
    }

    @Override
    public boolean isShutdown() {
        return this.state != State.Running;
    }

    @Override
    public boolean isTerminated() {
        return this.state == State.Terminated;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.runner.join(unit.toMillis(timeout));
        return this.runner.isAlive();
    }

    public long getQueuedTasksCount() {
        return Math.max(0L, this.getSubmittedTasksCount() - this.getCompletedTasksCount());
    }

    public long getSubmittedTasksCount() {
        return this.tasksCount.sum();
    }

    public long getCompletedTasksCount() {
        return this.tasksCompleted.sum();
    }

    public long getRejectedTasksCount() {
        return this.tasksRejected.sum();
    }

    public long getFailedTasksCount() {
        return this.tasksFailed.sum();
    }

    @Override
    public void execute(Runnable r) {
        block5: {
            if (this.state != State.Running) {
                throw new RejectedExecutionException("Executor is shutting down");
            }
            try {
                if (!this.rejectExecution) {
                    this.queue.put(r);
                    this.tasksCount.increment();
                    break block5;
                }
                if (this.queue.offer(r)) {
                    this.tasksCount.increment();
                    break block5;
                }
                this.tasksRejected.increment();
                throw new ExecutorRejectedException("Executor queue is full");
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Executor thread was interrupted", e);
            }
        }
    }

    public void registerMetrics(StatsLogger statsLogger) {
        statsLogger.scopeLabel("thread", this.runner.getName()).registerGauge("thread_executor_queue", (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return SingleThreadExecutor.this.getQueuedTasksCount();
            }
        });
        statsLogger.scopeLabel("thread", this.runner.getName()).registerGauge("thread_executor_completed", (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return SingleThreadExecutor.this.getCompletedTasksCount();
            }
        });
        statsLogger.scopeLabel("thread", this.runner.getName()).registerGauge("thread_executor_tasks_completed", (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return SingleThreadExecutor.this.getCompletedTasksCount();
            }
        });
        statsLogger.scopeLabel("thread", this.runner.getName()).registerGauge("thread_executor_tasks_rejected", (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return SingleThreadExecutor.this.getRejectedTasksCount();
            }
        });
        statsLogger.scopeLabel("thread", this.runner.getName()).registerGauge("thread_executor_tasks_failed", (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return SingleThreadExecutor.this.getFailedTasksCount();
            }
        });
    }

    private static class ExecutorRejectedException
    extends RejectedExecutionException {
        private ExecutorRejectedException(String msg) {
            super(msg);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static enum State {
        Running,
        Shutdown,
        Terminated;

    }
}

