/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;

public class NumberFormat {
    static void format(ByteBuf out, long num) {
        boolean encounteredMinValue;
        if (num == 0L) {
            out.writeByte(48);
            return;
        }
        boolean bl = encounteredMinValue = num == Long.MIN_VALUE;
        if (num < 0L) {
            out.writeByte(45);
            num += encounteredMinValue ? 1L : 0L;
            num *= -1L;
        }
        int start = out.writerIndex();
        NumberFormat.formatHelper(out, num);
        int end = out.writerIndex();
        if (encounteredMinValue) {
            out.setByte(start, out.getByte(start) + 1);
        }
        --end;
        for (int i = 0; i <= (end - start) / 2; ++i) {
            byte tmp = out.getByte(end - i);
            out.setByte(end - i, out.getByte(start + i));
            out.setByte(start + i, tmp);
        }
    }

    static void formatHelper(ByteBuf out, long num) {
        while (num != 0L) {
            out.writeByte((int)(48L + num % 10L));
            num /= 10L;
        }
    }
}

