package org.apache.pulsar.common.api.proto;
public final class CommandGetTopicsOfNamespaceResponse {
	private long requestId;
	private static final int _REQUEST_ID_FIELD_NUMBER = 1;
	private static final int _REQUEST_ID_TAG = (_REQUEST_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_REQUEST_ID_TAG);
	private static final int _REQUEST_ID_MASK = 1 << (0 % 32);
	public boolean hasRequestId() {
		return (_bitField0 & _REQUEST_ID_MASK) != 0;
	}
	public long getRequestId() {
		if (!hasRequestId()) {
			throw new IllegalStateException("Field 'request_id' is not set");
		}
		return requestId;
	}
	public CommandGetTopicsOfNamespaceResponse setRequestId(long requestId) {
		this.requestId = requestId;
		_bitField0 |= _REQUEST_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandGetTopicsOfNamespaceResponse clearRequestId() {
		_bitField0 &= ~_REQUEST_ID_MASK;
		return this;
	}

	private java.util.List<LightProtoCodec.StringHolder> topics = null;
	private int _topicsCount = 0;
	private static final int _TOPICS_FIELD_NUMBER = 2;
	private static final int _TOPICS_TAG = (_TOPICS_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TOPICS_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TOPICS_TAG);
	public int getTopicsCount() {
		return _topicsCount;
	}
	public String getTopicAt(int idx) {
		if (idx < 0 || idx >= _topicsCount) {
			throw new IndexOutOfBoundsException(
					"Index " + idx + " is out of the list size (" + _topicsCount + ") for field 'topics'");
		}
		LightProtoCodec.StringHolder _sh = topics.get(idx);
		if (_sh.s == null) {
			_sh.s = LightProtoCodec.readString(_parsedBuffer, _sh.idx, _sh.len);
		}
		return _sh.s;
	}
	public java.util.List<String> getTopicsList() {
		if (_topicsCount == 0) {
			return java.util.Collections.emptyList();
		} else {
			java.util.List<String> _l = new java.util.ArrayList<>();
			for (int i = 0; i < _topicsCount; i++) {
				_l.add(getTopicAt(i));
			}
			return _l;
		}
	}
	public void addTopic(String topic) {
		if (topics == null) {
			topics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh = _newTopicStringHolder();
		_cachedSize = -1;
		_sh.s = topic;
		_sh.idx = -1;
		_sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
	}
	public CommandGetTopicsOfNamespaceResponse addAllTopics(Iterable<String> topics) {
		for (String _s : topics) {
			addTopic(_s);
		}
		return this;
	}
	private LightProtoCodec.StringHolder _newTopicStringHolder() {
		if (topics == null) {
			topics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh;
		if (topics.size() == _topicsCount) {
			_sh = new LightProtoCodec.StringHolder();
			topics.add(_sh);
		} else {
			_sh = topics.get(_topicsCount);
		}
		_topicsCount++;
		return _sh;
	}
	public CommandGetTopicsOfNamespaceResponse clearTopics() {
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_topicsCount = 0;
		return this;
	}

	private boolean filtered = false;
	private static final int _FILTERED_FIELD_NUMBER = 3;
	private static final int _FILTERED_TAG = (_FILTERED_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _FILTERED_TAG_SIZE = LightProtoCodec.computeVarIntSize(_FILTERED_TAG);
	private static final int _FILTERED_MASK = 1 << (2 % 32);
	public boolean hasFiltered() {
		return (_bitField0 & _FILTERED_MASK) != 0;
	}
	public boolean isFiltered() {
		return filtered;
	}
	public CommandGetTopicsOfNamespaceResponse setFiltered(boolean filtered) {
		this.filtered = filtered;
		_bitField0 |= _FILTERED_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandGetTopicsOfNamespaceResponse clearFiltered() {
		_bitField0 &= ~_FILTERED_MASK;
		filtered = false;
		return this;
	}

	private String topicsHash;
	private int _topicsHashBufferIdx = -1;
	private int _topicsHashBufferLen = -1;
	private static final int _TOPICS_HASH_FIELD_NUMBER = 4;
	private static final int _TOPICS_HASH_TAG = (_TOPICS_HASH_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TOPICS_HASH_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TOPICS_HASH_TAG);
	private static final int _TOPICS_HASH_MASK = 1 << (3 % 32);
	public boolean hasTopicsHash() {
		return (_bitField0 & _TOPICS_HASH_MASK) != 0;
	}
	public String getTopicsHash() {
		if (!hasTopicsHash()) {
			throw new IllegalStateException("Field 'topics_hash' is not set");
		}
		if (topicsHash == null) {
			topicsHash = LightProtoCodec.readString(_parsedBuffer, _topicsHashBufferIdx, _topicsHashBufferLen);
		}
		return topicsHash;
	}
	public CommandGetTopicsOfNamespaceResponse setTopicsHash(String topicsHash) {
		this.topicsHash = topicsHash;
		_bitField0 |= _TOPICS_HASH_MASK;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = LightProtoCodec.computeStringUTF8Size(topicsHash);
		_cachedSize = -1;
		return this;
	}
	public CommandGetTopicsOfNamespaceResponse clearTopicsHash() {
		_bitField0 &= ~_TOPICS_HASH_MASK;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		return this;
	}

	private boolean changed = true;
	private static final int _CHANGED_FIELD_NUMBER = 5;
	private static final int _CHANGED_TAG = (_CHANGED_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _CHANGED_TAG_SIZE = LightProtoCodec.computeVarIntSize(_CHANGED_TAG);
	private static final int _CHANGED_MASK = 1 << (4 % 32);
	public boolean hasChanged() {
		return (_bitField0 & _CHANGED_MASK) != 0;
	}
	public boolean isChanged() {
		return changed;
	}
	public CommandGetTopicsOfNamespaceResponse setChanged(boolean changed) {
		this.changed = changed;
		_bitField0 |= _CHANGED_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandGetTopicsOfNamespaceResponse clearChanged() {
		_bitField0 &= ~_CHANGED_MASK;
		changed = true;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0 | _REQUEST_ID_MASK;
	public int writeTo(io.netty.buffer.ByteBuf _b) {
		checkRequiredFields();
		int _writeIdx = _b.writerIndex();
		LightProtoCodec.writeVarInt(_b, _REQUEST_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, requestId);
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			LightProtoCodec.writeVarInt(_b, _TOPICS_TAG);
			LightProtoCodec.writeVarInt(_b, _sh.len);
			if (_sh.idx == -1) {
				LightProtoCodec.writeString(_b, _sh.s, _sh.len);
			} else {
				_parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
			}
		}
		if (hasFiltered()) {
			LightProtoCodec.writeVarInt(_b, _FILTERED_TAG);
			_b.writeBoolean(filtered);
		}
		if (hasTopicsHash()) {
			LightProtoCodec.writeVarInt(_b, _TOPICS_HASH_TAG);
			LightProtoCodec.writeVarInt(_b, _topicsHashBufferLen);
			if (_topicsHashBufferIdx == -1) {
				LightProtoCodec.writeString(_b, topicsHash, _topicsHashBufferLen);
			} else {
				_parsedBuffer.getBytes(_topicsHashBufferIdx, _b, _topicsHashBufferLen);
			}
		}
		if (hasChanged()) {
			LightProtoCodec.writeVarInt(_b, _CHANGED_TAG);
			_b.writeBoolean(changed);
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		_size += _REQUEST_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(requestId);
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			_size += _TOPICS_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
		}
		if (hasFiltered()) {
			_size += _FILTERED_TAG_SIZE;
			_size += 1;
		}
		if (hasTopicsHash()) {
			_size += _TOPICS_HASH_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_topicsHashBufferLen);
			_size += _topicsHashBufferLen;
		}
		if (hasChanged()) {
			_size += _CHANGED_TAG_SIZE;
			_size += 1;
		}
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _REQUEST_ID_TAG :
					_bitField0 |= _REQUEST_ID_MASK;
					requestId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _TOPICS_TAG :
					LightProtoCodec.StringHolder _topicsSh = _newTopicStringHolder();
					_topicsSh.len = LightProtoCodec.readVarInt(_buffer);
					_topicsSh.idx = _buffer.readerIndex();
					_buffer.skipBytes(_topicsSh.len);
					break;
				case _FILTERED_TAG :
					_bitField0 |= _FILTERED_MASK;
					filtered = LightProtoCodec.readVarInt(_buffer) == 1;
					break;
				case _TOPICS_HASH_TAG :
					_bitField0 |= _TOPICS_HASH_MASK;
					_topicsHashBufferLen = LightProtoCodec.readVarInt(_buffer);
					_topicsHashBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_topicsHashBufferLen);
					break;
				case _CHANGED_TAG :
					_bitField0 |= _CHANGED_MASK;
					changed = LightProtoCodec.readVarInt(_buffer) == 1;
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		checkRequiredFields();
		_parsedBuffer = _buffer;
	}
	private void checkRequiredFields() {
		if ((_bitField0 & _REQUIRED_FIELDS_MASK0) != _REQUIRED_FIELDS_MASK0) {
			throw new IllegalStateException("Some required fields are missing");
		}
	}
	public CommandGetTopicsOfNamespaceResponse clear() {
		for (int i = 0; i < _topicsCount; i++) {
			LightProtoCodec.StringHolder _sh = topics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_topicsCount = 0;
		filtered = false;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		changed = true;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public CommandGetTopicsOfNamespaceResponse copyFrom(CommandGetTopicsOfNamespaceResponse _other) {
		_cachedSize = -1;
		if (_other.hasRequestId()) {
			setRequestId(_other.requestId);
		}
		for (int i = 0; i < _other.getTopicsCount(); i++) {
			addTopic(_other.getTopicAt(i));
		}
		if (_other.hasFiltered()) {
			setFiltered(_other.filtered);
		}
		if (_other.hasTopicsHash()) {
			setTopicsHash(_other.getTopicsHash());
		}
		if (_other.hasChanged()) {
			setChanged(_other.changed);
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private io.netty.buffer.ByteBuf _parsedBuffer;

}
