/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionPolicies;
import org.apache.pulsar.common.policies.data.impl.AutoSubscriptionCreationOverrideImpl;
import org.apache.pulsar.common.policies.data.impl.BacklogQuotaImpl;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public class TopicPolicies {
    private Map<String, BacklogQuotaImpl> backLogQuotaMap;
    private List<CommandSubscribe.SubType> subscriptionTypesEnabled;
    private List<String> replicationClusters;
    private List<String> shadowTopics;
    private Boolean isGlobal = false;
    private PersistencePolicies persistence;
    private RetentionPolicies retentionPolicies;
    private Boolean deduplicationEnabled;
    private Integer messageTTLInSeconds;
    private Integer maxProducerPerTopic;
    private Integer maxConsumerPerTopic;
    private Integer maxConsumersPerSubscription;
    private Integer maxUnackedMessagesOnConsumer;
    private Integer maxUnackedMessagesOnSubscription;
    private Long delayedDeliveryTickTimeMillis;
    private Boolean delayedDeliveryEnabled;
    private Long delayedDeliveryMaxDelayInMillis;
    private Boolean dispatcherPauseOnAckStatePersistentEnabled;
    private OffloadPoliciesImpl offloadPolicies;
    private InactiveTopicPolicies inactiveTopicPolicies;
    private DispatchRateImpl dispatchRate;
    private DispatchRateImpl subscriptionDispatchRate;
    private Long compactionThreshold;
    private PublishRate publishRate;
    private SubscribeRate subscribeRate;
    private Integer deduplicationSnapshotIntervalSeconds;
    private Integer maxMessageSize;
    private Integer maxSubscriptionsPerTopic;
    private DispatchRateImpl replicatorDispatchRate;
    private SchemaCompatibilityStrategy schemaCompatibilityStrategy;
    private EntryFilters entryFilters;
    private AutoSubscriptionCreationOverrideImpl autoSubscriptionCreationOverride;
    private Map<String, SubscriptionPolicies> subscriptionPolicies;
    private Boolean schemaValidationEnforced;

    public boolean isGlobalPolicies() {
        return this.isGlobal != null && this.isGlobal != false;
    }

    public boolean isReplicatorDispatchRateSet() {
        return this.replicatorDispatchRate != null;
    }

    public boolean isMaxSubscriptionsPerTopicSet() {
        return this.maxSubscriptionsPerTopic != null;
    }

    public boolean isMaxMessageSizeSet() {
        return this.maxMessageSize != null;
    }

    public boolean isDeduplicationSnapshotIntervalSecondsSet() {
        return this.deduplicationSnapshotIntervalSeconds != null;
    }

    public boolean isInactiveTopicPoliciesSet() {
        return this.inactiveTopicPolicies != null;
    }

    public boolean isOffloadPoliciesSet() {
        return this.offloadPolicies != null;
    }

    public boolean isMaxUnackedMessagesOnConsumerSet() {
        return this.maxUnackedMessagesOnConsumer != null;
    }

    public boolean isDelayedDeliveryTickTimeMillisSet() {
        return this.delayedDeliveryTickTimeMillis != null;
    }

    public boolean isDelayedDeliveryEnabledSet() {
        return this.delayedDeliveryEnabled != null;
    }

    public boolean isMaxUnackedMessagesOnSubscriptionSet() {
        return this.maxUnackedMessagesOnSubscription != null;
    }

    public boolean isBacklogQuotaSet() {
        return !this.backLogQuotaMap.isEmpty();
    }

    public boolean isPersistentPolicySet() {
        return this.persistence != null;
    }

    public boolean isRetentionSet() {
        return this.retentionPolicies != null;
    }

    public boolean isDeduplicationSet() {
        return this.deduplicationEnabled != null;
    }

    public boolean isMessageTTLSet() {
        return this.messageTTLInSeconds != null;
    }

    public boolean isMaxProducerPerTopicSet() {
        return this.maxProducerPerTopic != null;
    }

    public boolean isMaxConsumerPerTopicSet() {
        return this.maxConsumerPerTopic != null;
    }

    public boolean isMaxConsumersPerSubscriptionSet() {
        return this.maxConsumersPerSubscription != null;
    }

    public boolean isDispatchRateSet() {
        return this.dispatchRate != null;
    }

    public boolean isSubscriptionDispatchRateSet() {
        return this.subscriptionDispatchRate != null;
    }

    public boolean isCompactionThresholdSet() {
        return this.compactionThreshold != null;
    }

    public boolean isPublishRateSet() {
        return this.publishRate != null;
    }

    public boolean isSubscribeRateSet() {
        return this.subscribeRate != null;
    }

    public boolean isSchemaValidationEnforced() {
        return this.schemaValidationEnforced != null;
    }

    public Set<String> getReplicationClustersSet() {
        return this.replicationClusters != null ? Sets.newTreeSet(this.replicationClusters) : null;
    }

    public Map<String, SubscriptionPolicies> getSubscriptionPolicies() {
        if (this.subscriptionPolicies == null) {
            this.subscriptionPolicies = new ConcurrentHashMap<String, SubscriptionPolicies>();
        }
        return this.subscriptionPolicies;
    }

    @Generated
    private static Map<String, BacklogQuotaImpl> $default$backLogQuotaMap() {
        return new HashMap<String, BacklogQuotaImpl>();
    }

    @Generated
    private static List<CommandSubscribe.SubType> $default$subscriptionTypesEnabled() {
        return new ArrayList<CommandSubscribe.SubType>();
    }

    @Generated
    private static Map<String, SubscriptionPolicies> $default$subscriptionPolicies() {
        return new HashMap<String, SubscriptionPolicies>();
    }

    @Generated
    public static TopicPoliciesBuilder builder() {
        return new TopicPoliciesBuilder();
    }

    @Generated
    public Map<String, BacklogQuotaImpl> getBackLogQuotaMap() {
        return this.backLogQuotaMap;
    }

    @Generated
    public List<CommandSubscribe.SubType> getSubscriptionTypesEnabled() {
        return this.subscriptionTypesEnabled;
    }

    @Generated
    public List<String> getReplicationClusters() {
        return this.replicationClusters;
    }

    @Generated
    public List<String> getShadowTopics() {
        return this.shadowTopics;
    }

    @Generated
    public Boolean getIsGlobal() {
        return this.isGlobal;
    }

    @Generated
    public PersistencePolicies getPersistence() {
        return this.persistence;
    }

    @Generated
    public RetentionPolicies getRetentionPolicies() {
        return this.retentionPolicies;
    }

    @Generated
    public Boolean getDeduplicationEnabled() {
        return this.deduplicationEnabled;
    }

    @Generated
    public Integer getMessageTTLInSeconds() {
        return this.messageTTLInSeconds;
    }

    @Generated
    public Integer getMaxProducerPerTopic() {
        return this.maxProducerPerTopic;
    }

    @Generated
    public Integer getMaxConsumerPerTopic() {
        return this.maxConsumerPerTopic;
    }

    @Generated
    public Integer getMaxConsumersPerSubscription() {
        return this.maxConsumersPerSubscription;
    }

    @Generated
    public Integer getMaxUnackedMessagesOnConsumer() {
        return this.maxUnackedMessagesOnConsumer;
    }

    @Generated
    public Integer getMaxUnackedMessagesOnSubscription() {
        return this.maxUnackedMessagesOnSubscription;
    }

    @Generated
    public Long getDelayedDeliveryTickTimeMillis() {
        return this.delayedDeliveryTickTimeMillis;
    }

    @Generated
    public Boolean getDelayedDeliveryEnabled() {
        return this.delayedDeliveryEnabled;
    }

    @Generated
    public Long getDelayedDeliveryMaxDelayInMillis() {
        return this.delayedDeliveryMaxDelayInMillis;
    }

    @Generated
    public Boolean getDispatcherPauseOnAckStatePersistentEnabled() {
        return this.dispatcherPauseOnAckStatePersistentEnabled;
    }

    @Generated
    public OffloadPoliciesImpl getOffloadPolicies() {
        return this.offloadPolicies;
    }

    @Generated
    public InactiveTopicPolicies getInactiveTopicPolicies() {
        return this.inactiveTopicPolicies;
    }

    @Generated
    public DispatchRateImpl getDispatchRate() {
        return this.dispatchRate;
    }

    @Generated
    public DispatchRateImpl getSubscriptionDispatchRate() {
        return this.subscriptionDispatchRate;
    }

    @Generated
    public Long getCompactionThreshold() {
        return this.compactionThreshold;
    }

    @Generated
    public PublishRate getPublishRate() {
        return this.publishRate;
    }

    @Generated
    public SubscribeRate getSubscribeRate() {
        return this.subscribeRate;
    }

    @Generated
    public Integer getDeduplicationSnapshotIntervalSeconds() {
        return this.deduplicationSnapshotIntervalSeconds;
    }

    @Generated
    public Integer getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Generated
    public Integer getMaxSubscriptionsPerTopic() {
        return this.maxSubscriptionsPerTopic;
    }

    @Generated
    public DispatchRateImpl getReplicatorDispatchRate() {
        return this.replicatorDispatchRate;
    }

    @Generated
    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy() {
        return this.schemaCompatibilityStrategy;
    }

    @Generated
    public EntryFilters getEntryFilters() {
        return this.entryFilters;
    }

    @Generated
    public AutoSubscriptionCreationOverrideImpl getAutoSubscriptionCreationOverride() {
        return this.autoSubscriptionCreationOverride;
    }

    @Generated
    public Boolean getSchemaValidationEnforced() {
        return this.schemaValidationEnforced;
    }

    @Generated
    public void setBackLogQuotaMap(Map<String, BacklogQuotaImpl> backLogQuotaMap) {
        this.backLogQuotaMap = backLogQuotaMap;
    }

    @Generated
    public void setSubscriptionTypesEnabled(List<CommandSubscribe.SubType> subscriptionTypesEnabled) {
        this.subscriptionTypesEnabled = subscriptionTypesEnabled;
    }

    @Generated
    public void setReplicationClusters(List<String> replicationClusters) {
        this.replicationClusters = replicationClusters;
    }

    @Generated
    public void setShadowTopics(List<String> shadowTopics) {
        this.shadowTopics = shadowTopics;
    }

    @Generated
    public void setIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    @Generated
    public void setPersistence(PersistencePolicies persistence) {
        this.persistence = persistence;
    }

    @Generated
    public void setRetentionPolicies(RetentionPolicies retentionPolicies) {
        this.retentionPolicies = retentionPolicies;
    }

    @Generated
    public void setDeduplicationEnabled(Boolean deduplicationEnabled) {
        this.deduplicationEnabled = deduplicationEnabled;
    }

    @Generated
    public void setMessageTTLInSeconds(Integer messageTTLInSeconds) {
        this.messageTTLInSeconds = messageTTLInSeconds;
    }

    @Generated
    public void setMaxProducerPerTopic(Integer maxProducerPerTopic) {
        this.maxProducerPerTopic = maxProducerPerTopic;
    }

    @Generated
    public void setMaxConsumerPerTopic(Integer maxConsumerPerTopic) {
        this.maxConsumerPerTopic = maxConsumerPerTopic;
    }

    @Generated
    public void setMaxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
        this.maxConsumersPerSubscription = maxConsumersPerSubscription;
    }

    @Generated
    public void setMaxUnackedMessagesOnConsumer(Integer maxUnackedMessagesOnConsumer) {
        this.maxUnackedMessagesOnConsumer = maxUnackedMessagesOnConsumer;
    }

    @Generated
    public void setMaxUnackedMessagesOnSubscription(Integer maxUnackedMessagesOnSubscription) {
        this.maxUnackedMessagesOnSubscription = maxUnackedMessagesOnSubscription;
    }

    @Generated
    public void setDelayedDeliveryTickTimeMillis(Long delayedDeliveryTickTimeMillis) {
        this.delayedDeliveryTickTimeMillis = delayedDeliveryTickTimeMillis;
    }

    @Generated
    public void setDelayedDeliveryEnabled(Boolean delayedDeliveryEnabled) {
        this.delayedDeliveryEnabled = delayedDeliveryEnabled;
    }

    @Generated
    public void setDelayedDeliveryMaxDelayInMillis(Long delayedDeliveryMaxDelayInMillis) {
        this.delayedDeliveryMaxDelayInMillis = delayedDeliveryMaxDelayInMillis;
    }

    @Generated
    public void setDispatcherPauseOnAckStatePersistentEnabled(Boolean dispatcherPauseOnAckStatePersistentEnabled) {
        this.dispatcherPauseOnAckStatePersistentEnabled = dispatcherPauseOnAckStatePersistentEnabled;
    }

    @Generated
    public void setOffloadPolicies(OffloadPoliciesImpl offloadPolicies) {
        this.offloadPolicies = offloadPolicies;
    }

    @Generated
    public void setInactiveTopicPolicies(InactiveTopicPolicies inactiveTopicPolicies) {
        this.inactiveTopicPolicies = inactiveTopicPolicies;
    }

    @Generated
    public void setDispatchRate(DispatchRateImpl dispatchRate) {
        this.dispatchRate = dispatchRate;
    }

    @Generated
    public void setSubscriptionDispatchRate(DispatchRateImpl subscriptionDispatchRate) {
        this.subscriptionDispatchRate = subscriptionDispatchRate;
    }

    @Generated
    public void setCompactionThreshold(Long compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
    }

    @Generated
    public void setPublishRate(PublishRate publishRate) {
        this.publishRate = publishRate;
    }

    @Generated
    public void setSubscribeRate(SubscribeRate subscribeRate) {
        this.subscribeRate = subscribeRate;
    }

    @Generated
    public void setDeduplicationSnapshotIntervalSeconds(Integer deduplicationSnapshotIntervalSeconds) {
        this.deduplicationSnapshotIntervalSeconds = deduplicationSnapshotIntervalSeconds;
    }

    @Generated
    public void setMaxMessageSize(Integer maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    @Generated
    public void setMaxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic) {
        this.maxSubscriptionsPerTopic = maxSubscriptionsPerTopic;
    }

    @Generated
    public void setReplicatorDispatchRate(DispatchRateImpl replicatorDispatchRate) {
        this.replicatorDispatchRate = replicatorDispatchRate;
    }

    @Generated
    public void setSchemaCompatibilityStrategy(SchemaCompatibilityStrategy schemaCompatibilityStrategy) {
        this.schemaCompatibilityStrategy = schemaCompatibilityStrategy;
    }

    @Generated
    public void setEntryFilters(EntryFilters entryFilters) {
        this.entryFilters = entryFilters;
    }

    @Generated
    public void setAutoSubscriptionCreationOverride(AutoSubscriptionCreationOverrideImpl autoSubscriptionCreationOverride) {
        this.autoSubscriptionCreationOverride = autoSubscriptionCreationOverride;
    }

    @Generated
    public void setSubscriptionPolicies(Map<String, SubscriptionPolicies> subscriptionPolicies) {
        this.subscriptionPolicies = subscriptionPolicies;
    }

    @Generated
    public void setSchemaValidationEnforced(Boolean schemaValidationEnforced) {
        this.schemaValidationEnforced = schemaValidationEnforced;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicPolicies)) {
            return false;
        }
        TopicPolicies other = (TopicPolicies)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isGlobal = this.getIsGlobal();
        Boolean other$isGlobal = other.getIsGlobal();
        if (this$isGlobal == null ? other$isGlobal != null : !((Object)this$isGlobal).equals(other$isGlobal)) {
            return false;
        }
        Boolean this$deduplicationEnabled = this.getDeduplicationEnabled();
        Boolean other$deduplicationEnabled = other.getDeduplicationEnabled();
        if (this$deduplicationEnabled == null ? other$deduplicationEnabled != null : !((Object)this$deduplicationEnabled).equals(other$deduplicationEnabled)) {
            return false;
        }
        Integer this$messageTTLInSeconds = this.getMessageTTLInSeconds();
        Integer other$messageTTLInSeconds = other.getMessageTTLInSeconds();
        if (this$messageTTLInSeconds == null ? other$messageTTLInSeconds != null : !((Object)this$messageTTLInSeconds).equals(other$messageTTLInSeconds)) {
            return false;
        }
        Integer this$maxProducerPerTopic = this.getMaxProducerPerTopic();
        Integer other$maxProducerPerTopic = other.getMaxProducerPerTopic();
        if (this$maxProducerPerTopic == null ? other$maxProducerPerTopic != null : !((Object)this$maxProducerPerTopic).equals(other$maxProducerPerTopic)) {
            return false;
        }
        Integer this$maxConsumerPerTopic = this.getMaxConsumerPerTopic();
        Integer other$maxConsumerPerTopic = other.getMaxConsumerPerTopic();
        if (this$maxConsumerPerTopic == null ? other$maxConsumerPerTopic != null : !((Object)this$maxConsumerPerTopic).equals(other$maxConsumerPerTopic)) {
            return false;
        }
        Integer this$maxConsumersPerSubscription = this.getMaxConsumersPerSubscription();
        Integer other$maxConsumersPerSubscription = other.getMaxConsumersPerSubscription();
        if (this$maxConsumersPerSubscription == null ? other$maxConsumersPerSubscription != null : !((Object)this$maxConsumersPerSubscription).equals(other$maxConsumersPerSubscription)) {
            return false;
        }
        Integer this$maxUnackedMessagesOnConsumer = this.getMaxUnackedMessagesOnConsumer();
        Integer other$maxUnackedMessagesOnConsumer = other.getMaxUnackedMessagesOnConsumer();
        if (this$maxUnackedMessagesOnConsumer == null ? other$maxUnackedMessagesOnConsumer != null : !((Object)this$maxUnackedMessagesOnConsumer).equals(other$maxUnackedMessagesOnConsumer)) {
            return false;
        }
        Integer this$maxUnackedMessagesOnSubscription = this.getMaxUnackedMessagesOnSubscription();
        Integer other$maxUnackedMessagesOnSubscription = other.getMaxUnackedMessagesOnSubscription();
        if (this$maxUnackedMessagesOnSubscription == null ? other$maxUnackedMessagesOnSubscription != null : !((Object)this$maxUnackedMessagesOnSubscription).equals(other$maxUnackedMessagesOnSubscription)) {
            return false;
        }
        Long this$delayedDeliveryTickTimeMillis = this.getDelayedDeliveryTickTimeMillis();
        Long other$delayedDeliveryTickTimeMillis = other.getDelayedDeliveryTickTimeMillis();
        if (this$delayedDeliveryTickTimeMillis == null ? other$delayedDeliveryTickTimeMillis != null : !((Object)this$delayedDeliveryTickTimeMillis).equals(other$delayedDeliveryTickTimeMillis)) {
            return false;
        }
        Boolean this$delayedDeliveryEnabled = this.getDelayedDeliveryEnabled();
        Boolean other$delayedDeliveryEnabled = other.getDelayedDeliveryEnabled();
        if (this$delayedDeliveryEnabled == null ? other$delayedDeliveryEnabled != null : !((Object)this$delayedDeliveryEnabled).equals(other$delayedDeliveryEnabled)) {
            return false;
        }
        Long this$delayedDeliveryMaxDelayInMillis = this.getDelayedDeliveryMaxDelayInMillis();
        Long other$delayedDeliveryMaxDelayInMillis = other.getDelayedDeliveryMaxDelayInMillis();
        if (this$delayedDeliveryMaxDelayInMillis == null ? other$delayedDeliveryMaxDelayInMillis != null : !((Object)this$delayedDeliveryMaxDelayInMillis).equals(other$delayedDeliveryMaxDelayInMillis)) {
            return false;
        }
        Boolean this$dispatcherPauseOnAckStatePersistentEnabled = this.getDispatcherPauseOnAckStatePersistentEnabled();
        Boolean other$dispatcherPauseOnAckStatePersistentEnabled = other.getDispatcherPauseOnAckStatePersistentEnabled();
        if (this$dispatcherPauseOnAckStatePersistentEnabled == null ? other$dispatcherPauseOnAckStatePersistentEnabled != null : !((Object)this$dispatcherPauseOnAckStatePersistentEnabled).equals(other$dispatcherPauseOnAckStatePersistentEnabled)) {
            return false;
        }
        Long this$compactionThreshold = this.getCompactionThreshold();
        Long other$compactionThreshold = other.getCompactionThreshold();
        if (this$compactionThreshold == null ? other$compactionThreshold != null : !((Object)this$compactionThreshold).equals(other$compactionThreshold)) {
            return false;
        }
        Integer this$deduplicationSnapshotIntervalSeconds = this.getDeduplicationSnapshotIntervalSeconds();
        Integer other$deduplicationSnapshotIntervalSeconds = other.getDeduplicationSnapshotIntervalSeconds();
        if (this$deduplicationSnapshotIntervalSeconds == null ? other$deduplicationSnapshotIntervalSeconds != null : !((Object)this$deduplicationSnapshotIntervalSeconds).equals(other$deduplicationSnapshotIntervalSeconds)) {
            return false;
        }
        Integer this$maxMessageSize = this.getMaxMessageSize();
        Integer other$maxMessageSize = other.getMaxMessageSize();
        if (this$maxMessageSize == null ? other$maxMessageSize != null : !((Object)this$maxMessageSize).equals(other$maxMessageSize)) {
            return false;
        }
        Integer this$maxSubscriptionsPerTopic = this.getMaxSubscriptionsPerTopic();
        Integer other$maxSubscriptionsPerTopic = other.getMaxSubscriptionsPerTopic();
        if (this$maxSubscriptionsPerTopic == null ? other$maxSubscriptionsPerTopic != null : !((Object)this$maxSubscriptionsPerTopic).equals(other$maxSubscriptionsPerTopic)) {
            return false;
        }
        Boolean this$schemaValidationEnforced = this.getSchemaValidationEnforced();
        Boolean other$schemaValidationEnforced = other.getSchemaValidationEnforced();
        if (this$schemaValidationEnforced == null ? other$schemaValidationEnforced != null : !((Object)this$schemaValidationEnforced).equals(other$schemaValidationEnforced)) {
            return false;
        }
        Map<String, BacklogQuotaImpl> this$backLogQuotaMap = this.getBackLogQuotaMap();
        Map<String, BacklogQuotaImpl> other$backLogQuotaMap = other.getBackLogQuotaMap();
        if (this$backLogQuotaMap == null ? other$backLogQuotaMap != null : !((Object)this$backLogQuotaMap).equals(other$backLogQuotaMap)) {
            return false;
        }
        List<CommandSubscribe.SubType> this$subscriptionTypesEnabled = this.getSubscriptionTypesEnabled();
        List<CommandSubscribe.SubType> other$subscriptionTypesEnabled = other.getSubscriptionTypesEnabled();
        if (this$subscriptionTypesEnabled == null ? other$subscriptionTypesEnabled != null : !((Object)this$subscriptionTypesEnabled).equals(other$subscriptionTypesEnabled)) {
            return false;
        }
        List<String> this$replicationClusters = this.getReplicationClusters();
        List<String> other$replicationClusters = other.getReplicationClusters();
        if (this$replicationClusters == null ? other$replicationClusters != null : !((Object)this$replicationClusters).equals(other$replicationClusters)) {
            return false;
        }
        List<String> this$shadowTopics = this.getShadowTopics();
        List<String> other$shadowTopics = other.getShadowTopics();
        if (this$shadowTopics == null ? other$shadowTopics != null : !((Object)this$shadowTopics).equals(other$shadowTopics)) {
            return false;
        }
        PersistencePolicies this$persistence = this.getPersistence();
        PersistencePolicies other$persistence = other.getPersistence();
        if (this$persistence == null ? other$persistence != null : !this$persistence.equals(other$persistence)) {
            return false;
        }
        RetentionPolicies this$retentionPolicies = this.getRetentionPolicies();
        RetentionPolicies other$retentionPolicies = other.getRetentionPolicies();
        if (this$retentionPolicies == null ? other$retentionPolicies != null : !this$retentionPolicies.equals(other$retentionPolicies)) {
            return false;
        }
        OffloadPoliciesImpl this$offloadPolicies = this.getOffloadPolicies();
        OffloadPoliciesImpl other$offloadPolicies = other.getOffloadPolicies();
        if (this$offloadPolicies == null ? other$offloadPolicies != null : !((Object)this$offloadPolicies).equals(other$offloadPolicies)) {
            return false;
        }
        InactiveTopicPolicies this$inactiveTopicPolicies = this.getInactiveTopicPolicies();
        InactiveTopicPolicies other$inactiveTopicPolicies = other.getInactiveTopicPolicies();
        if (this$inactiveTopicPolicies == null ? other$inactiveTopicPolicies != null : !this$inactiveTopicPolicies.equals(other$inactiveTopicPolicies)) {
            return false;
        }
        DispatchRateImpl this$dispatchRate = this.getDispatchRate();
        DispatchRateImpl other$dispatchRate = other.getDispatchRate();
        if (this$dispatchRate == null ? other$dispatchRate != null : !this$dispatchRate.equals(other$dispatchRate)) {
            return false;
        }
        DispatchRateImpl this$subscriptionDispatchRate = this.getSubscriptionDispatchRate();
        DispatchRateImpl other$subscriptionDispatchRate = other.getSubscriptionDispatchRate();
        if (this$subscriptionDispatchRate == null ? other$subscriptionDispatchRate != null : !this$subscriptionDispatchRate.equals(other$subscriptionDispatchRate)) {
            return false;
        }
        PublishRate this$publishRate = this.getPublishRate();
        PublishRate other$publishRate = other.getPublishRate();
        if (this$publishRate == null ? other$publishRate != null : !this$publishRate.equals(other$publishRate)) {
            return false;
        }
        SubscribeRate this$subscribeRate = this.getSubscribeRate();
        SubscribeRate other$subscribeRate = other.getSubscribeRate();
        if (this$subscribeRate == null ? other$subscribeRate != null : !this$subscribeRate.equals(other$subscribeRate)) {
            return false;
        }
        DispatchRateImpl this$replicatorDispatchRate = this.getReplicatorDispatchRate();
        DispatchRateImpl other$replicatorDispatchRate = other.getReplicatorDispatchRate();
        if (this$replicatorDispatchRate == null ? other$replicatorDispatchRate != null : !this$replicatorDispatchRate.equals(other$replicatorDispatchRate)) {
            return false;
        }
        SchemaCompatibilityStrategy this$schemaCompatibilityStrategy = this.getSchemaCompatibilityStrategy();
        SchemaCompatibilityStrategy other$schemaCompatibilityStrategy = other.getSchemaCompatibilityStrategy();
        if (this$schemaCompatibilityStrategy == null ? other$schemaCompatibilityStrategy != null : !this$schemaCompatibilityStrategy.equals(other$schemaCompatibilityStrategy)) {
            return false;
        }
        EntryFilters this$entryFilters = this.getEntryFilters();
        EntryFilters other$entryFilters = other.getEntryFilters();
        if (this$entryFilters == null ? other$entryFilters != null : !this$entryFilters.equals(other$entryFilters)) {
            return false;
        }
        AutoSubscriptionCreationOverrideImpl this$autoSubscriptionCreationOverride = this.getAutoSubscriptionCreationOverride();
        AutoSubscriptionCreationOverrideImpl other$autoSubscriptionCreationOverride = other.getAutoSubscriptionCreationOverride();
        if (this$autoSubscriptionCreationOverride == null ? other$autoSubscriptionCreationOverride != null : !this$autoSubscriptionCreationOverride.equals(other$autoSubscriptionCreationOverride)) {
            return false;
        }
        Map<String, SubscriptionPolicies> this$subscriptionPolicies = this.getSubscriptionPolicies();
        Map<String, SubscriptionPolicies> other$subscriptionPolicies = other.getSubscriptionPolicies();
        return !(this$subscriptionPolicies == null ? other$subscriptionPolicies != null : !((Object)this$subscriptionPolicies).equals(other$subscriptionPolicies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopicPolicies;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isGlobal = this.getIsGlobal();
        result = result * 59 + ($isGlobal == null ? 43 : ((Object)$isGlobal).hashCode());
        Boolean $deduplicationEnabled = this.getDeduplicationEnabled();
        result = result * 59 + ($deduplicationEnabled == null ? 43 : ((Object)$deduplicationEnabled).hashCode());
        Integer $messageTTLInSeconds = this.getMessageTTLInSeconds();
        result = result * 59 + ($messageTTLInSeconds == null ? 43 : ((Object)$messageTTLInSeconds).hashCode());
        Integer $maxProducerPerTopic = this.getMaxProducerPerTopic();
        result = result * 59 + ($maxProducerPerTopic == null ? 43 : ((Object)$maxProducerPerTopic).hashCode());
        Integer $maxConsumerPerTopic = this.getMaxConsumerPerTopic();
        result = result * 59 + ($maxConsumerPerTopic == null ? 43 : ((Object)$maxConsumerPerTopic).hashCode());
        Integer $maxConsumersPerSubscription = this.getMaxConsumersPerSubscription();
        result = result * 59 + ($maxConsumersPerSubscription == null ? 43 : ((Object)$maxConsumersPerSubscription).hashCode());
        Integer $maxUnackedMessagesOnConsumer = this.getMaxUnackedMessagesOnConsumer();
        result = result * 59 + ($maxUnackedMessagesOnConsumer == null ? 43 : ((Object)$maxUnackedMessagesOnConsumer).hashCode());
        Integer $maxUnackedMessagesOnSubscription = this.getMaxUnackedMessagesOnSubscription();
        result = result * 59 + ($maxUnackedMessagesOnSubscription == null ? 43 : ((Object)$maxUnackedMessagesOnSubscription).hashCode());
        Long $delayedDeliveryTickTimeMillis = this.getDelayedDeliveryTickTimeMillis();
        result = result * 59 + ($delayedDeliveryTickTimeMillis == null ? 43 : ((Object)$delayedDeliveryTickTimeMillis).hashCode());
        Boolean $delayedDeliveryEnabled = this.getDelayedDeliveryEnabled();
        result = result * 59 + ($delayedDeliveryEnabled == null ? 43 : ((Object)$delayedDeliveryEnabled).hashCode());
        Long $delayedDeliveryMaxDelayInMillis = this.getDelayedDeliveryMaxDelayInMillis();
        result = result * 59 + ($delayedDeliveryMaxDelayInMillis == null ? 43 : ((Object)$delayedDeliveryMaxDelayInMillis).hashCode());
        Boolean $dispatcherPauseOnAckStatePersistentEnabled = this.getDispatcherPauseOnAckStatePersistentEnabled();
        result = result * 59 + ($dispatcherPauseOnAckStatePersistentEnabled == null ? 43 : ((Object)$dispatcherPauseOnAckStatePersistentEnabled).hashCode());
        Long $compactionThreshold = this.getCompactionThreshold();
        result = result * 59 + ($compactionThreshold == null ? 43 : ((Object)$compactionThreshold).hashCode());
        Integer $deduplicationSnapshotIntervalSeconds = this.getDeduplicationSnapshotIntervalSeconds();
        result = result * 59 + ($deduplicationSnapshotIntervalSeconds == null ? 43 : ((Object)$deduplicationSnapshotIntervalSeconds).hashCode());
        Integer $maxMessageSize = this.getMaxMessageSize();
        result = result * 59 + ($maxMessageSize == null ? 43 : ((Object)$maxMessageSize).hashCode());
        Integer $maxSubscriptionsPerTopic = this.getMaxSubscriptionsPerTopic();
        result = result * 59 + ($maxSubscriptionsPerTopic == null ? 43 : ((Object)$maxSubscriptionsPerTopic).hashCode());
        Boolean $schemaValidationEnforced = this.getSchemaValidationEnforced();
        result = result * 59 + ($schemaValidationEnforced == null ? 43 : ((Object)$schemaValidationEnforced).hashCode());
        Map<String, BacklogQuotaImpl> $backLogQuotaMap = this.getBackLogQuotaMap();
        result = result * 59 + ($backLogQuotaMap == null ? 43 : ((Object)$backLogQuotaMap).hashCode());
        List<CommandSubscribe.SubType> $subscriptionTypesEnabled = this.getSubscriptionTypesEnabled();
        result = result * 59 + ($subscriptionTypesEnabled == null ? 43 : ((Object)$subscriptionTypesEnabled).hashCode());
        List<String> $replicationClusters = this.getReplicationClusters();
        result = result * 59 + ($replicationClusters == null ? 43 : ((Object)$replicationClusters).hashCode());
        List<String> $shadowTopics = this.getShadowTopics();
        result = result * 59 + ($shadowTopics == null ? 43 : ((Object)$shadowTopics).hashCode());
        PersistencePolicies $persistence = this.getPersistence();
        result = result * 59 + ($persistence == null ? 43 : $persistence.hashCode());
        RetentionPolicies $retentionPolicies = this.getRetentionPolicies();
        result = result * 59 + ($retentionPolicies == null ? 43 : $retentionPolicies.hashCode());
        OffloadPoliciesImpl $offloadPolicies = this.getOffloadPolicies();
        result = result * 59 + ($offloadPolicies == null ? 43 : ((Object)$offloadPolicies).hashCode());
        InactiveTopicPolicies $inactiveTopicPolicies = this.getInactiveTopicPolicies();
        result = result * 59 + ($inactiveTopicPolicies == null ? 43 : $inactiveTopicPolicies.hashCode());
        DispatchRateImpl $dispatchRate = this.getDispatchRate();
        result = result * 59 + ($dispatchRate == null ? 43 : $dispatchRate.hashCode());
        DispatchRateImpl $subscriptionDispatchRate = this.getSubscriptionDispatchRate();
        result = result * 59 + ($subscriptionDispatchRate == null ? 43 : $subscriptionDispatchRate.hashCode());
        PublishRate $publishRate = this.getPublishRate();
        result = result * 59 + ($publishRate == null ? 43 : $publishRate.hashCode());
        SubscribeRate $subscribeRate = this.getSubscribeRate();
        result = result * 59 + ($subscribeRate == null ? 43 : $subscribeRate.hashCode());
        DispatchRateImpl $replicatorDispatchRate = this.getReplicatorDispatchRate();
        result = result * 59 + ($replicatorDispatchRate == null ? 43 : $replicatorDispatchRate.hashCode());
        SchemaCompatibilityStrategy $schemaCompatibilityStrategy = this.getSchemaCompatibilityStrategy();
        result = result * 59 + ($schemaCompatibilityStrategy == null ? 43 : $schemaCompatibilityStrategy.hashCode());
        EntryFilters $entryFilters = this.getEntryFilters();
        result = result * 59 + ($entryFilters == null ? 43 : $entryFilters.hashCode());
        AutoSubscriptionCreationOverrideImpl $autoSubscriptionCreationOverride = this.getAutoSubscriptionCreationOverride();
        result = result * 59 + ($autoSubscriptionCreationOverride == null ? 43 : $autoSubscriptionCreationOverride.hashCode());
        Map<String, SubscriptionPolicies> $subscriptionPolicies = this.getSubscriptionPolicies();
        result = result * 59 + ($subscriptionPolicies == null ? 43 : ((Object)$subscriptionPolicies).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TopicPolicies(backLogQuotaMap=" + this.getBackLogQuotaMap() + ", subscriptionTypesEnabled=" + this.getSubscriptionTypesEnabled() + ", replicationClusters=" + this.getReplicationClusters() + ", shadowTopics=" + this.getShadowTopics() + ", isGlobal=" + this.getIsGlobal() + ", persistence=" + this.getPersistence() + ", retentionPolicies=" + this.getRetentionPolicies() + ", deduplicationEnabled=" + this.getDeduplicationEnabled() + ", messageTTLInSeconds=" + this.getMessageTTLInSeconds() + ", maxProducerPerTopic=" + this.getMaxProducerPerTopic() + ", maxConsumerPerTopic=" + this.getMaxConsumerPerTopic() + ", maxConsumersPerSubscription=" + this.getMaxConsumersPerSubscription() + ", maxUnackedMessagesOnConsumer=" + this.getMaxUnackedMessagesOnConsumer() + ", maxUnackedMessagesOnSubscription=" + this.getMaxUnackedMessagesOnSubscription() + ", delayedDeliveryTickTimeMillis=" + this.getDelayedDeliveryTickTimeMillis() + ", delayedDeliveryEnabled=" + this.getDelayedDeliveryEnabled() + ", delayedDeliveryMaxDelayInMillis=" + this.getDelayedDeliveryMaxDelayInMillis() + ", dispatcherPauseOnAckStatePersistentEnabled=" + this.getDispatcherPauseOnAckStatePersistentEnabled() + ", offloadPolicies=" + this.getOffloadPolicies() + ", inactiveTopicPolicies=" + this.getInactiveTopicPolicies() + ", dispatchRate=" + this.getDispatchRate() + ", subscriptionDispatchRate=" + this.getSubscriptionDispatchRate() + ", compactionThreshold=" + this.getCompactionThreshold() + ", publishRate=" + this.getPublishRate() + ", subscribeRate=" + this.getSubscribeRate() + ", deduplicationSnapshotIntervalSeconds=" + this.getDeduplicationSnapshotIntervalSeconds() + ", maxMessageSize=" + this.getMaxMessageSize() + ", maxSubscriptionsPerTopic=" + this.getMaxSubscriptionsPerTopic() + ", replicatorDispatchRate=" + this.getReplicatorDispatchRate() + ", schemaCompatibilityStrategy=" + this.getSchemaCompatibilityStrategy() + ", entryFilters=" + this.getEntryFilters() + ", autoSubscriptionCreationOverride=" + this.getAutoSubscriptionCreationOverride() + ", subscriptionPolicies=" + this.getSubscriptionPolicies() + ", schemaValidationEnforced=" + this.getSchemaValidationEnforced() + ")";
    }

    @Generated
    public TopicPolicies() {
        this.backLogQuotaMap = TopicPolicies.$default$backLogQuotaMap();
        this.subscriptionTypesEnabled = TopicPolicies.$default$subscriptionTypesEnabled();
        this.subscriptionPolicies = TopicPolicies.$default$subscriptionPolicies();
    }

    @Generated
    public TopicPolicies(Map<String, BacklogQuotaImpl> backLogQuotaMap, List<CommandSubscribe.SubType> subscriptionTypesEnabled, List<String> replicationClusters, List<String> shadowTopics, Boolean isGlobal, PersistencePolicies persistence, RetentionPolicies retentionPolicies, Boolean deduplicationEnabled, Integer messageTTLInSeconds, Integer maxProducerPerTopic, Integer maxConsumerPerTopic, Integer maxConsumersPerSubscription, Integer maxUnackedMessagesOnConsumer, Integer maxUnackedMessagesOnSubscription, Long delayedDeliveryTickTimeMillis, Boolean delayedDeliveryEnabled, Long delayedDeliveryMaxDelayInMillis, Boolean dispatcherPauseOnAckStatePersistentEnabled, OffloadPoliciesImpl offloadPolicies, InactiveTopicPolicies inactiveTopicPolicies, DispatchRateImpl dispatchRate, DispatchRateImpl subscriptionDispatchRate, Long compactionThreshold, PublishRate publishRate, SubscribeRate subscribeRate, Integer deduplicationSnapshotIntervalSeconds, Integer maxMessageSize, Integer maxSubscriptionsPerTopic, DispatchRateImpl replicatorDispatchRate, SchemaCompatibilityStrategy schemaCompatibilityStrategy, EntryFilters entryFilters, AutoSubscriptionCreationOverrideImpl autoSubscriptionCreationOverride, Map<String, SubscriptionPolicies> subscriptionPolicies, Boolean schemaValidationEnforced) {
        this.backLogQuotaMap = backLogQuotaMap;
        this.subscriptionTypesEnabled = subscriptionTypesEnabled;
        this.replicationClusters = replicationClusters;
        this.shadowTopics = shadowTopics;
        this.isGlobal = isGlobal;
        this.persistence = persistence;
        this.retentionPolicies = retentionPolicies;
        this.deduplicationEnabled = deduplicationEnabled;
        this.messageTTLInSeconds = messageTTLInSeconds;
        this.maxProducerPerTopic = maxProducerPerTopic;
        this.maxConsumerPerTopic = maxConsumerPerTopic;
        this.maxConsumersPerSubscription = maxConsumersPerSubscription;
        this.maxUnackedMessagesOnConsumer = maxUnackedMessagesOnConsumer;
        this.maxUnackedMessagesOnSubscription = maxUnackedMessagesOnSubscription;
        this.delayedDeliveryTickTimeMillis = delayedDeliveryTickTimeMillis;
        this.delayedDeliveryEnabled = delayedDeliveryEnabled;
        this.delayedDeliveryMaxDelayInMillis = delayedDeliveryMaxDelayInMillis;
        this.dispatcherPauseOnAckStatePersistentEnabled = dispatcherPauseOnAckStatePersistentEnabled;
        this.offloadPolicies = offloadPolicies;
        this.inactiveTopicPolicies = inactiveTopicPolicies;
        this.dispatchRate = dispatchRate;
        this.subscriptionDispatchRate = subscriptionDispatchRate;
        this.compactionThreshold = compactionThreshold;
        this.publishRate = publishRate;
        this.subscribeRate = subscribeRate;
        this.deduplicationSnapshotIntervalSeconds = deduplicationSnapshotIntervalSeconds;
        this.maxMessageSize = maxMessageSize;
        this.maxSubscriptionsPerTopic = maxSubscriptionsPerTopic;
        this.replicatorDispatchRate = replicatorDispatchRate;
        this.schemaCompatibilityStrategy = schemaCompatibilityStrategy;
        this.entryFilters = entryFilters;
        this.autoSubscriptionCreationOverride = autoSubscriptionCreationOverride;
        this.subscriptionPolicies = subscriptionPolicies;
        this.schemaValidationEnforced = schemaValidationEnforced;
    }

    @Generated
    public static class TopicPoliciesBuilder {
        @Generated
        private boolean backLogQuotaMap$set;
        @Generated
        private Map<String, BacklogQuotaImpl> backLogQuotaMap$value;
        @Generated
        private boolean subscriptionTypesEnabled$set;
        @Generated
        private List<CommandSubscribe.SubType> subscriptionTypesEnabled$value;
        @Generated
        private List<String> replicationClusters;
        @Generated
        private List<String> shadowTopics;
        @Generated
        private Boolean isGlobal;
        @Generated
        private PersistencePolicies persistence;
        @Generated
        private RetentionPolicies retentionPolicies;
        @Generated
        private Boolean deduplicationEnabled;
        @Generated
        private Integer messageTTLInSeconds;
        @Generated
        private Integer maxProducerPerTopic;
        @Generated
        private Integer maxConsumerPerTopic;
        @Generated
        private Integer maxConsumersPerSubscription;
        @Generated
        private Integer maxUnackedMessagesOnConsumer;
        @Generated
        private Integer maxUnackedMessagesOnSubscription;
        @Generated
        private Long delayedDeliveryTickTimeMillis;
        @Generated
        private Boolean delayedDeliveryEnabled;
        @Generated
        private Long delayedDeliveryMaxDelayInMillis;
        @Generated
        private Boolean dispatcherPauseOnAckStatePersistentEnabled;
        @Generated
        private OffloadPoliciesImpl offloadPolicies;
        @Generated
        private InactiveTopicPolicies inactiveTopicPolicies;
        @Generated
        private DispatchRateImpl dispatchRate;
        @Generated
        private DispatchRateImpl subscriptionDispatchRate;
        @Generated
        private Long compactionThreshold;
        @Generated
        private PublishRate publishRate;
        @Generated
        private SubscribeRate subscribeRate;
        @Generated
        private Integer deduplicationSnapshotIntervalSeconds;
        @Generated
        private Integer maxMessageSize;
        @Generated
        private Integer maxSubscriptionsPerTopic;
        @Generated
        private DispatchRateImpl replicatorDispatchRate;
        @Generated
        private SchemaCompatibilityStrategy schemaCompatibilityStrategy;
        @Generated
        private EntryFilters entryFilters;
        @Generated
        private AutoSubscriptionCreationOverrideImpl autoSubscriptionCreationOverride;
        @Generated
        private boolean subscriptionPolicies$set;
        @Generated
        private Map<String, SubscriptionPolicies> subscriptionPolicies$value;
        @Generated
        private Boolean schemaValidationEnforced;

        @Generated
        TopicPoliciesBuilder() {
        }

        @Generated
        public TopicPoliciesBuilder backLogQuotaMap(Map<String, BacklogQuotaImpl> backLogQuotaMap) {
            this.backLogQuotaMap$value = backLogQuotaMap;
            this.backLogQuotaMap$set = true;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder subscriptionTypesEnabled(List<CommandSubscribe.SubType> subscriptionTypesEnabled) {
            this.subscriptionTypesEnabled$value = subscriptionTypesEnabled;
            this.subscriptionTypesEnabled$set = true;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder replicationClusters(List<String> replicationClusters) {
            this.replicationClusters = replicationClusters;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder shadowTopics(List<String> shadowTopics) {
            this.shadowTopics = shadowTopics;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder persistence(PersistencePolicies persistence) {
            this.persistence = persistence;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder retentionPolicies(RetentionPolicies retentionPolicies) {
            this.retentionPolicies = retentionPolicies;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder deduplicationEnabled(Boolean deduplicationEnabled) {
            this.deduplicationEnabled = deduplicationEnabled;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder messageTTLInSeconds(Integer messageTTLInSeconds) {
            this.messageTTLInSeconds = messageTTLInSeconds;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder maxProducerPerTopic(Integer maxProducerPerTopic) {
            this.maxProducerPerTopic = maxProducerPerTopic;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder maxConsumerPerTopic(Integer maxConsumerPerTopic) {
            this.maxConsumerPerTopic = maxConsumerPerTopic;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder maxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
            this.maxConsumersPerSubscription = maxConsumersPerSubscription;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder maxUnackedMessagesOnConsumer(Integer maxUnackedMessagesOnConsumer) {
            this.maxUnackedMessagesOnConsumer = maxUnackedMessagesOnConsumer;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder maxUnackedMessagesOnSubscription(Integer maxUnackedMessagesOnSubscription) {
            this.maxUnackedMessagesOnSubscription = maxUnackedMessagesOnSubscription;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder delayedDeliveryTickTimeMillis(Long delayedDeliveryTickTimeMillis) {
            this.delayedDeliveryTickTimeMillis = delayedDeliveryTickTimeMillis;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder delayedDeliveryEnabled(Boolean delayedDeliveryEnabled) {
            this.delayedDeliveryEnabled = delayedDeliveryEnabled;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder delayedDeliveryMaxDelayInMillis(Long delayedDeliveryMaxDelayInMillis) {
            this.delayedDeliveryMaxDelayInMillis = delayedDeliveryMaxDelayInMillis;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder dispatcherPauseOnAckStatePersistentEnabled(Boolean dispatcherPauseOnAckStatePersistentEnabled) {
            this.dispatcherPauseOnAckStatePersistentEnabled = dispatcherPauseOnAckStatePersistentEnabled;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder offloadPolicies(OffloadPoliciesImpl offloadPolicies) {
            this.offloadPolicies = offloadPolicies;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder inactiveTopicPolicies(InactiveTopicPolicies inactiveTopicPolicies) {
            this.inactiveTopicPolicies = inactiveTopicPolicies;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder dispatchRate(DispatchRateImpl dispatchRate) {
            this.dispatchRate = dispatchRate;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder subscriptionDispatchRate(DispatchRateImpl subscriptionDispatchRate) {
            this.subscriptionDispatchRate = subscriptionDispatchRate;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder compactionThreshold(Long compactionThreshold) {
            this.compactionThreshold = compactionThreshold;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder publishRate(PublishRate publishRate) {
            this.publishRate = publishRate;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder subscribeRate(SubscribeRate subscribeRate) {
            this.subscribeRate = subscribeRate;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder deduplicationSnapshotIntervalSeconds(Integer deduplicationSnapshotIntervalSeconds) {
            this.deduplicationSnapshotIntervalSeconds = deduplicationSnapshotIntervalSeconds;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder maxMessageSize(Integer maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder maxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic) {
            this.maxSubscriptionsPerTopic = maxSubscriptionsPerTopic;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder replicatorDispatchRate(DispatchRateImpl replicatorDispatchRate) {
            this.replicatorDispatchRate = replicatorDispatchRate;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder schemaCompatibilityStrategy(SchemaCompatibilityStrategy schemaCompatibilityStrategy) {
            this.schemaCompatibilityStrategy = schemaCompatibilityStrategy;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder entryFilters(EntryFilters entryFilters) {
            this.entryFilters = entryFilters;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder autoSubscriptionCreationOverride(AutoSubscriptionCreationOverrideImpl autoSubscriptionCreationOverride) {
            this.autoSubscriptionCreationOverride = autoSubscriptionCreationOverride;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder subscriptionPolicies(Map<String, SubscriptionPolicies> subscriptionPolicies) {
            this.subscriptionPolicies$value = subscriptionPolicies;
            this.subscriptionPolicies$set = true;
            return this;
        }

        @Generated
        public TopicPoliciesBuilder schemaValidationEnforced(Boolean schemaValidationEnforced) {
            this.schemaValidationEnforced = schemaValidationEnforced;
            return this;
        }

        @Generated
        public TopicPolicies build() {
            Map backLogQuotaMap$value = this.backLogQuotaMap$value;
            if (!this.backLogQuotaMap$set) {
                backLogQuotaMap$value = TopicPolicies.$default$backLogQuotaMap();
            }
            List subscriptionTypesEnabled$value = this.subscriptionTypesEnabled$value;
            if (!this.subscriptionTypesEnabled$set) {
                subscriptionTypesEnabled$value = TopicPolicies.$default$subscriptionTypesEnabled();
            }
            Map subscriptionPolicies$value = this.subscriptionPolicies$value;
            if (!this.subscriptionPolicies$set) {
                subscriptionPolicies$value = TopicPolicies.$default$subscriptionPolicies();
            }
            return new TopicPolicies(backLogQuotaMap$value, subscriptionTypesEnabled$value, this.replicationClusters, this.shadowTopics, this.isGlobal, this.persistence, this.retentionPolicies, this.deduplicationEnabled, this.messageTTLInSeconds, this.maxProducerPerTopic, this.maxConsumerPerTopic, this.maxConsumersPerSubscription, this.maxUnackedMessagesOnConsumer, this.maxUnackedMessagesOnSubscription, this.delayedDeliveryTickTimeMillis, this.delayedDeliveryEnabled, this.delayedDeliveryMaxDelayInMillis, this.dispatcherPauseOnAckStatePersistentEnabled, this.offloadPolicies, this.inactiveTopicPolicies, this.dispatchRate, this.subscriptionDispatchRate, this.compactionThreshold, this.publishRate, this.subscribeRate, this.deduplicationSnapshotIntervalSeconds, this.maxMessageSize, this.maxSubscriptionsPerTopic, this.replicatorDispatchRate, this.schemaCompatibilityStrategy, this.entryFilters, this.autoSubscriptionCreationOverride, subscriptionPolicies$value, this.schemaValidationEnforced);
        }

        @Generated
        public String toString() {
            return "TopicPolicies.TopicPoliciesBuilder(backLogQuotaMap$value=" + this.backLogQuotaMap$value + ", subscriptionTypesEnabled$value=" + this.subscriptionTypesEnabled$value + ", replicationClusters=" + this.replicationClusters + ", shadowTopics=" + this.shadowTopics + ", isGlobal=" + this.isGlobal + ", persistence=" + this.persistence + ", retentionPolicies=" + this.retentionPolicies + ", deduplicationEnabled=" + this.deduplicationEnabled + ", messageTTLInSeconds=" + this.messageTTLInSeconds + ", maxProducerPerTopic=" + this.maxProducerPerTopic + ", maxConsumerPerTopic=" + this.maxConsumerPerTopic + ", maxConsumersPerSubscription=" + this.maxConsumersPerSubscription + ", maxUnackedMessagesOnConsumer=" + this.maxUnackedMessagesOnConsumer + ", maxUnackedMessagesOnSubscription=" + this.maxUnackedMessagesOnSubscription + ", delayedDeliveryTickTimeMillis=" + this.delayedDeliveryTickTimeMillis + ", delayedDeliveryEnabled=" + this.delayedDeliveryEnabled + ", delayedDeliveryMaxDelayInMillis=" + this.delayedDeliveryMaxDelayInMillis + ", dispatcherPauseOnAckStatePersistentEnabled=" + this.dispatcherPauseOnAckStatePersistentEnabled + ", offloadPolicies=" + this.offloadPolicies + ", inactiveTopicPolicies=" + this.inactiveTopicPolicies + ", dispatchRate=" + this.dispatchRate + ", subscriptionDispatchRate=" + this.subscriptionDispatchRate + ", compactionThreshold=" + this.compactionThreshold + ", publishRate=" + this.publishRate + ", subscribeRate=" + this.subscribeRate + ", deduplicationSnapshotIntervalSeconds=" + this.deduplicationSnapshotIntervalSeconds + ", maxMessageSize=" + this.maxMessageSize + ", maxSubscriptionsPerTopic=" + this.maxSubscriptionsPerTopic + ", replicatorDispatchRate=" + this.replicatorDispatchRate + ", schemaCompatibilityStrategy=" + this.schemaCompatibilityStrategy + ", entryFilters=" + this.entryFilters + ", autoSubscriptionCreationOverride=" + this.autoSubscriptionCreationOverride + ", subscriptionPolicies$value=" + this.subscriptionPolicies$value + ", schemaValidationEnforced=" + this.schemaValidationEnforced + ")";
        }
    }
}

