/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.github.benmanes.caffeine.cache;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.DisabledScheduler;
import org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.ExecutorServiceScheduler;
import org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.GuardedScheduler;
import org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.SystemScheduler;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@FunctionalInterface
public interface Scheduler {
    public Future<? extends @Nullable Object> schedule(Executor var1, Runnable var2, long var3, TimeUnit var5);

    public static Scheduler disabledScheduler() {
        return DisabledScheduler.INSTANCE;
    }

    public static Scheduler systemScheduler() {
        return SystemScheduler.INSTANCE;
    }

    public static Scheduler forScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return new ExecutorServiceScheduler(scheduledExecutorService);
    }

    public static Scheduler guardedScheduler(Scheduler scheduler) {
        return scheduler instanceof GuardedScheduler ? scheduler : new GuardedScheduler(scheduler);
    }
}

