/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.github.benmanes.caffeine.cache;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.Expiry;
import org.apache.pulsar.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;

final class ExpiryAfterCreate<K, V>
implements Expiry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    final BiFunction<K, V, Duration> function;

    public ExpiryAfterCreate(BiFunction<K, V, Duration> calculator) {
        this.function = Objects.requireNonNull(calculator);
    }

    @Override
    public long expireAfterCreate(K key, V value, long currentTime) {
        return Caffeine.toNanosSaturated(this.function.apply(key, value));
    }

    @Override
    @CanIgnoreReturnValue
    public long expireAfterUpdate(K key, V value, long currentTime, long currentDuration) {
        return currentDuration;
    }

    @Override
    @CanIgnoreReturnValue
    public long expireAfterRead(K key, V value, long currentTime, long currentDuration) {
        return currentDuration;
    }
}

