/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.client.util.PulsarHttpAsyncSslEngineFactory;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.BoundRequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private static final String ORIGINAL_PRINCIPAL_HEADER = "X-Original-Principal";
    protected static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 10;
    protected static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 30;
    protected final AsyncHttpClient httpClient;
    protected final ServiceNameResolver serviceNameResolver;
    protected final Authentication authentication;
    protected final ClientConfigurationData clientConf;
    protected ScheduledExecutorService executorService;
    protected PulsarSslFactory sslFactory;

    protected HttpClient(ClientConfigurationData conf, EventLoopGroup eventLoopGroup) throws PulsarClientException {
        this.authentication = conf.getAuthentication();
        this.serviceNameResolver = new PulsarServiceNameResolver();
        this.clientConf = conf;
        this.serviceNameResolver.updateServiceUrl(conf.getServiceUrl());
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        confBuilder.setCookieStore(null);
        confBuilder.setUseProxyProperties(true);
        confBuilder.setFollowRedirect(true);
        confBuilder.setMaxRedirects(conf.getMaxLookupRedirects());
        confBuilder.setConnectTimeout(10000);
        confBuilder.setReadTimeout(30000);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setKeepAliveStrategy(new DefaultKeepAliveStrategy(){

            @Override
            public boolean keepAlive(InetSocketAddress remoteAddress, Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(remoteAddress, ahcRequest, request, response);
            }
        });
        if ("https".equals(this.serviceNameResolver.getServiceUri().getServiceName())) {
            try {
                this.executorService = Executors.newSingleThreadScheduledExecutor(new ExecutorProvider.ExtendedThreadFactory("httpclient-ssl-refresh"));
                PulsarSslConfiguration sslConfiguration = this.buildSslConfiguration(conf, this.serviceNameResolver.resolveHostUri().getHost());
                this.sslFactory = (PulsarSslFactory)Class.forName(conf.getSslFactoryPlugin()).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.sslFactory.initialize(sslConfiguration);
                this.sslFactory.createInternalSslContext();
                if (conf.getAutoCertRefreshSeconds() > 0) {
                    this.executorService.scheduleWithFixedDelay(this::refreshSslContext, conf.getAutoCertRefreshSeconds(), conf.getAutoCertRefreshSeconds(), TimeUnit.SECONDS);
                }
                String hostname = conf.isTlsHostnameVerificationEnable() ? null : this.serviceNameResolver.resolveHostUri().getHost();
                PulsarHttpAsyncSslEngineFactory sslEngineFactory = new PulsarHttpAsyncSslEngineFactory(this.sslFactory, hostname);
                confBuilder.setSslEngineFactory(sslEngineFactory);
                confBuilder.setUseInsecureTrustManager(conf.isTlsAllowInsecureConnection());
                confBuilder.setDisableHttpsEndpointIdentificationAlgorithm(!conf.isTlsHostnameVerificationEnable());
            }
            catch (Exception e) {
                throw new PulsarClientException.InvalidConfigurationException((Throwable)e);
            }
        }
        confBuilder.setEventLoopGroup(eventLoopGroup);
        DefaultAsyncHttpClientConfig config = confBuilder.build();
        this.httpClient = new DefaultAsyncHttpClient(config);
        log.debug("Using HTTP url: {}", (Object)conf.getServiceUrl());
    }

    String getServiceUrl() {
        return this.serviceNameResolver.getServiceUrl();
    }

    public InetSocketAddress resolveHost() {
        return this.serviceNameResolver.resolveHost();
    }

    void setServiceUrl(String serviceUrl) throws PulsarClientException {
        this.serviceNameResolver.updateServiceUrl(serviceUrl);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public <T> CompletableFuture<T> get(String path, Class<T> clazz) {
        CompletableFuture future = new CompletableFuture();
        try {
            URI hostUri = this.serviceNameResolver.resolveHostUri();
            String requestUrl = new URL(hostUri.toURL(), path).toString();
            String remoteHostName = hostUri.getHost();
            AuthenticationDataProvider authData = this.authentication.getAuthData(remoteHostName);
            CompletableFuture authFuture = new CompletableFuture();
            if (authData.hasDataForHttp()) {
                this.authentication.authenticationStage(requestUrl, authData, null, authFuture);
            } else {
                authFuture.complete(null);
            }
            authFuture.whenComplete((respHeaders, ex) -> {
                if (ex != null) {
                    log.warn("[{}] Failed to perform http request at authentication stage: {}", (Object)requestUrl, (Object)ex.getMessage());
                    future.completeExceptionally(new PulsarClientException(ex));
                    return;
                }
                BoundRequestBuilder builder = (BoundRequestBuilder)this.httpClient.prepareGet(requestUrl).setHeader((CharSequence)"Accept", "application/json");
                if (authData.hasDataForHttp()) {
                    Set headers;
                    try {
                        headers = this.authentication.newRequestHeader(requestUrl, authData, respHeaders);
                    }
                    catch (Exception e) {
                        log.warn("[{}] Error during HTTP get headers: {}", (Object)requestUrl, (Object)e.getMessage());
                        future.completeExceptionally(new PulsarClientException((Throwable)e));
                        return;
                    }
                    if (headers != null) {
                        headers.forEach(entry -> builder.addHeader((CharSequence)entry.getKey(), (String)entry.getValue()));
                    }
                }
                if (this.clientConf.getOriginalPrincipal() != null) {
                    builder.addHeader((CharSequence)ORIGINAL_PRINCIPAL_HEADER, this.clientConf.getOriginalPrincipal());
                }
                builder.execute().toCompletableFuture().whenComplete((response2, t2) -> {
                    if (t2 != null) {
                        log.warn("[{}] Failed to perform http request: {}", (Object)requestUrl, (Object)t2.getMessage());
                        future.completeExceptionally(new PulsarClientException(t2));
                        return;
                    }
                    if (response2.getStatusCode() != 200) {
                        log.warn("[{}] HTTP get request failed: {}", (Object)requestUrl, (Object)response2.getStatusText());
                        Object e = response2.getStatusCode() == 404 ? new PulsarClientException.NotFoundException("Not found: " + response2.getStatusText()) : new PulsarClientException("HTTP get request failed: " + response2.getStatusText());
                        future.completeExceptionally((Throwable)e);
                        return;
                    }
                    try {
                        Object data = ObjectMapperFactory.getMapper().reader().readValue(response2.getResponseBodyAsBytes(), clazz);
                        future.complete(data);
                    }
                    catch (Exception e) {
                        log.warn("[{}] Error during HTTP get request: {}", (Object)requestUrl, (Object)e.getMessage());
                        future.completeExceptionally(new PulsarClientException((Throwable)e));
                    }
                });
            });
        }
        catch (Exception e) {
            log.warn("[{}]PulsarClientImpl: {}", (Object)path, (Object)e.getMessage());
            if (e instanceof PulsarClientException) {
                future.completeExceptionally(e);
            }
            future.completeExceptionally(new PulsarClientException((Throwable)e));
        }
        return future;
    }

    protected PulsarSslConfiguration buildSslConfiguration(ClientConfigurationData config, String host) throws PulsarClientException {
        return PulsarSslConfiguration.builder().tlsProvider(config.getSslProvider()).tlsKeyStoreType(config.getTlsKeyStoreType()).tlsKeyStorePath(config.getTlsKeyStorePath()).tlsKeyStorePassword(config.getTlsKeyStorePassword()).tlsTrustStoreType(config.getTlsTrustStoreType()).tlsTrustStorePath(config.getTlsTrustStorePath()).tlsTrustStorePassword(config.getTlsTrustStorePassword()).tlsCiphers(config.getTlsCiphers()).tlsProtocols(config.getTlsProtocols()).tlsTrustCertsFilePath(config.getTlsTrustCertsFilePath()).tlsCertificateFilePath(config.getTlsCertificateFilePath()).tlsKeyFilePath(config.getTlsKeyFilePath()).allowInsecureConnection(config.isTlsAllowInsecureConnection()).requireTrustedClientCertOnConnect(false).tlsEnabledWithKeystore(config.isUseKeyStoreTls()).tlsCustomParams(config.getSslFactoryPluginParams()).authData(config.getAuthentication().getAuthData(host)).serverMode(false).isHttps(true).build();
    }

    protected void refreshSslContext() {
        try {
            this.sslFactory.update();
        }
        catch (Exception e) {
            log.error("Failed to refresh SSL context", (Throwable)e);
        }
    }
}

