/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.BitSet;
import org.apache.pulsar.client.api.MessageId;

public interface MessageIdAdv
extends MessageId {
    public long getLedgerId();

    public long getEntryId();

    default public int getPartitionIndex() {
        return -1;
    }

    default public int getBatchIndex() {
        return -1;
    }

    default public int getBatchSize() {
        return 0;
    }

    default public BitSet getAckSet() {
        return null;
    }

    default public MessageIdAdv getFirstChunkMessageId() {
        return null;
    }

    default public int compareTo(MessageId o) {
        if (!(o instanceof MessageIdAdv)) {
            throw new UnsupportedOperationException("Unknown MessageId type: " + (o != null ? o.getClass().getName() : "null"));
        }
        MessageIdAdv other = (MessageIdAdv)o;
        int result = Long.compare(this.getLedgerId(), other.getLedgerId());
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.getEntryId(), other.getEntryId());
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.getPartitionIndex(), other.getPartitionIndex());
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.getBatchIndex(), other.getBatchIndex());
    }
}

