/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.crc;

import org.apache.pulsar.shade.com.scurrilous.circe.crc.AbstractIntCrc;

final class NormalByteCrc
extends AbstractIntCrc {
    private final byte[] table = new byte[256];

    NormalByteCrc(String algorithm, int bitWidth, int poly, int init, int xorOut) {
        super(algorithm, bitWidth, init, xorOut);
        if (bitWidth > 8) {
            throw new IllegalArgumentException("invalid CRC width");
        }
        int widthMask = (1 << bitWidth) - 1;
        int shpoly = poly << 8 - bitWidth;
        for (int i = 0; i < 256; ++i) {
            int crc = i;
            for (int j = 0; j < 8; ++j) {
                crc = (crc & 0x80) != 0 ? crc << 1 ^ shpoly : crc << 1;
            }
            this.table[i] = (byte)(crc >> 8 - bitWidth & widthMask);
        }
    }

    @Override
    protected int resumeRaw(int crc, byte[] input, int index, int length) {
        for (int i = 0; i < length; ++i) {
            crc = this.table[crc << 8 - this.bitWidth ^ input[index + i] & 0xFF] & 0xFF;
        }
        return crc;
    }
}

