/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Splitter;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicName
implements ServiceUnitId {
    private static final Logger log = LoggerFactory.getLogger(TopicName.class);
    public static final String PUBLIC_TENANT = "public";
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String PARTITIONED_TOPIC_SUFFIX = "-partition-";
    private final String completeTopicName;
    private final TopicDomain domain;
    private final String tenant;
    private final String cluster;
    private final String namespacePortion;
    private final String localName;
    private final NamespaceName namespaceName;
    private final int partitionIndex;
    private static final LoadingCache<String, TopicName> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<String, TopicName>(){

        @Override
        public TopicName load(String name) throws Exception {
            return new TopicName(name);
        }
    });

    public static TopicName get(String domain, NamespaceName namespaceName, String topic) {
        String name = domain + "://" + namespaceName.toString() + '/' + topic;
        return TopicName.get(name);
    }

    public static TopicName get(String domain, String tenant, String namespace, String topic) {
        String name = domain + "://" + tenant + '/' + namespace + '/' + topic;
        return TopicName.get(name);
    }

    public static TopicName get(String domain, String tenant, String cluster, String namespace, String topic) {
        String name = domain + "://" + tenant + '/' + cluster + '/' + namespace + '/' + topic;
        return TopicName.get(name);
    }

    public static TopicName get(String topic) {
        try {
            return cache.get(topic);
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
        catch (UncheckedExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public static boolean isValid(String topic) {
        try {
            TopicName.get(topic);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private TopicName(String completeTopicName) {
        try {
            Object parts;
            if (!completeTopicName.contains("://")) {
                parts = StringUtils.split(completeTopicName, '/');
                if (((String[])parts).length == 3) {
                    completeTopicName = TopicDomain.persistent.name() + "://" + completeTopicName;
                } else if (((String[])parts).length == 1) {
                    completeTopicName = TopicDomain.persistent.name() + "://" + PUBLIC_TENANT + "/" + DEFAULT_NAMESPACE + "/" + (String)parts[0];
                } else {
                    throw new IllegalArgumentException("Invalid short topic name '" + completeTopicName + "', it should be in the format of <tenant>/<namespace>/<topic> or <topic>");
                }
            }
            this.completeTopicName = completeTopicName;
            parts = Splitter.on("://").limit(2).splitToList(completeTopicName);
            this.domain = TopicDomain.getEnum((String)parts.get(0));
            String rest = (String)parts.get(1);
            parts = Splitter.on("/").limit(4).splitToList(rest);
            if (parts.size() == 3) {
                this.tenant = (String)parts.get(0);
                this.cluster = null;
                this.namespacePortion = (String)parts.get(1);
                this.localName = (String)parts.get(2);
                this.partitionIndex = TopicName.getPartitionIndex(completeTopicName);
                this.namespaceName = NamespaceName.get(this.tenant, this.namespacePortion);
            } else if (parts.size() == 4) {
                this.tenant = (String)parts.get(0);
                this.cluster = (String)parts.get(1);
                this.namespacePortion = (String)parts.get(2);
                this.localName = (String)parts.get(3);
                this.partitionIndex = TopicName.getPartitionIndex(completeTopicName);
                this.namespaceName = NamespaceName.get(this.tenant, this.cluster, this.namespacePortion);
            } else {
                throw new IllegalArgumentException("Invalid topic name: " + completeTopicName);
            }
            if (this.localName == null || this.localName.isEmpty()) {
                throw new IllegalArgumentException("Invalid topic name: " + completeTopicName);
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid topic name: " + completeTopicName, e);
        }
    }

    public boolean isPersistent() {
        return TopicDomain.persistent == this.domain;
    }

    public String getNamespace() {
        return this.namespaceName.toString();
    }

    @Override
    public NamespaceName getNamespaceObject() {
        return this.namespaceName;
    }

    public TopicDomain getDomain() {
        return this.domain;
    }

    public String getTenant() {
        return this.tenant;
    }

    @Deprecated
    public String getCluster() {
        return this.cluster;
    }

    public String getNamespacePortion() {
        return this.namespacePortion;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getEncodedLocalName() {
        return Codec.encode(this.localName);
    }

    public TopicName getPartition(int index) {
        if (index == -1 || this.toString().contains(PARTITIONED_TOPIC_SUFFIX)) {
            return this;
        }
        String partitionName = this.toString() + PARTITIONED_TOPIC_SUFFIX + index;
        return TopicName.get(partitionName);
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public boolean isPartitioned() {
        return this.partitionIndex != -1;
    }

    public String getPartitionedTopicName() {
        if (this.isPartitioned()) {
            return this.completeTopicName.substring(0, this.completeTopicName.lastIndexOf(PARTITIONED_TOPIC_SUFFIX));
        }
        return this.completeTopicName;
    }

    public static int getPartitionIndex(String topic) {
        int partitionIndex = -1;
        if (topic.contains(PARTITIONED_TOPIC_SUFFIX)) {
            try {
                partitionIndex = Integer.parseInt(topic.substring(topic.lastIndexOf(45) + 1));
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not get the partition index from the topic {}", (Object)topic);
            }
        }
        return partitionIndex;
    }

    public String getRestPath() {
        if (this.isV2()) {
            return String.format("%s/%s/%s/%s", new Object[]{this.domain, this.tenant, this.namespacePortion, this.getEncodedLocalName()});
        }
        return String.format("%s/%s/%s/%s/%s", new Object[]{this.domain, this.tenant, this.cluster, this.namespacePortion, this.getEncodedLocalName()});
    }

    public String getPersistenceNamingEncoding() {
        if (this.isV2()) {
            return String.format("%s/%s/%s/%s", new Object[]{this.tenant, this.namespacePortion, this.domain, this.getEncodedLocalName()});
        }
        return String.format("%s/%s/%s/%s/%s", new Object[]{this.tenant, this.cluster, this.namespacePortion, this.domain, this.getEncodedLocalName()});
    }

    public String getLookupName() {
        if (this.isV2()) {
            return String.format("%s/%s/%s/%s", new Object[]{this.domain, this.tenant, this.namespacePortion, this.getEncodedLocalName()});
        }
        return String.format("%s/%s/%s/%s/%s", new Object[]{this.domain, this.tenant, this.cluster, this.namespacePortion, this.getEncodedLocalName()});
    }

    public boolean isGlobal() {
        return this.cluster == null || "global".equalsIgnoreCase(this.cluster);
    }

    public String getSchemaName() {
        return this.getTenant() + "/" + this.getNamespacePortion() + "/" + this.getLocalName();
    }

    @Override
    public String toString() {
        return this.completeTopicName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopicName) {
            TopicName other = (TopicName)obj;
            return Objects.equal(this.completeTopicName, other.completeTopicName);
        }
        return false;
    }

    public int hashCode() {
        return this.completeTopicName.hashCode();
    }

    @Override
    public boolean includes(TopicName otherTopicName) {
        return this.equals(otherTopicName);
    }

    public boolean isV2() {
        return this.cluster == null;
    }
}

