/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.compression;

import java.util.EnumMap;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecLZ4;
import org.apache.pulsar.common.compression.CompressionCodecNone;
import org.apache.pulsar.common.compression.CompressionCodecZLib;

public final class CompressionCodecProvider {
    private static final EnumMap<PulsarApi.CompressionType, CompressionCodec> codecs = new EnumMap(PulsarApi.CompressionType.class);

    public static CompressionCodec getCompressionCodec(PulsarApi.CompressionType type) {
        return codecs.get((Object)type);
    }

    private CompressionCodecProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        codecs.put(PulsarApi.CompressionType.NONE, new CompressionCodecNone());
        codecs.put(PulsarApi.CompressionType.LZ4, new CompressionCodecLZ4());
        codecs.put(PulsarApi.CompressionType.ZLIB, new CompressionCodecZLib());
    }
}

