/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.filter;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerFilter;
import org.apache.pulsar.common.naming.ServiceUnitId;

public class BrokerLoadManagerClassFilter
implements BrokerFilter {
    public static final String FILTER_NAME = "broker_load_manager_class_filter";

    @Override
    public String name() {
        return FILTER_NAME;
    }

    @Override
    public CompletableFuture<Map<String, BrokerLookupData>> filterAsync(Map<String, BrokerLookupData> brokers, ServiceUnitId serviceUnit, LoadManagerContext context) {
        if (brokers.isEmpty()) {
            return CompletableFuture.completedFuture(brokers);
        }
        brokers.entrySet().removeIf(entry -> {
            BrokerLookupData v = (BrokerLookupData)entry.getValue();
            return !Objects.equals(v.getLoadManagerClassName(), context.brokerConfiguration().getLoadManagerClassName());
        });
        return CompletableFuture.completedFuture(brokers);
    }
}

