/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.manager.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateChangeListeners {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateChangeListeners.class);
    private final List<StateChangeListener> stateChangeListeners = new CopyOnWriteArrayList<StateChangeListener>();

    public void addListener(StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.stateChangeListeners.add(listener);
    }

    public void close() {
        this.stateChangeListeners.clear();
    }

    public <T> CompletableFuture<T> notifyOnCompletion(CompletableFuture<T> future, String serviceUnit, ServiceUnitStateData data) {
        return future.whenComplete((r, ex) -> this.notify(serviceUnit, data, (Throwable)ex));
    }

    public void notify(String serviceUnit, ServiceUnitStateData data, Throwable t) {
        this.stateChangeListeners.forEach(listener -> {
            try {
                listener.handleEvent(serviceUnit, data, t);
            }
            catch (Throwable ex) {
                log.error("StateChangeListener: {} exception while handling {} for service unit {}", new Object[]{listener, data, serviceUnit, ex});
            }
        });
    }
}

