/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.EntryReadCountHandler;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.ReferenceCountedEntry;
import org.apache.bookkeeper.mledger.impl.EntryReadCountHandlerImpl;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.bookkeeper.mledger.util.AbstractCASReferenceCounted;

public final class EntryImpl
extends AbstractCASReferenceCounted
implements ReferenceCountedEntry,
Comparable<EntryImpl> {
    private static final Recycler<EntryImpl> RECYCLER = new Recycler<EntryImpl>(){

        protected EntryImpl newObject(Recycler.Handle<EntryImpl> handle) {
            return new EntryImpl(handle);
        }
    };
    private final Recycler.Handle<EntryImpl> recyclerHandle;
    private long ledgerId;
    private long entryId;
    private Position position;
    ByteBuf data;
    private EntryReadCountHandler readCountHandler;
    private boolean decreaseReadCountOnRelease = true;
    private Runnable onDeallocate;

    public static EntryImpl create(LedgerEntry ledgerEntry, int expectedReadCount) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.ledgerId = ledgerEntry.getLedgerId();
        entry.entryId = ledgerEntry.getEntryId();
        entry.data = ledgerEntry.getEntryBuffer();
        entry.data.retain();
        entry.readCountHandler = EntryReadCountHandlerImpl.maybeCreate(expectedReadCount);
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(LedgerEntry ledgerEntry, ManagedLedgerInterceptor interceptor, int expectedReadCount) {
        ManagedLedgerInterceptor.PayloadProcessorHandle processorHandle = null;
        if (interceptor != null) {
            ByteBuf duplicateBuffer = ledgerEntry.getEntryBuffer().retainedDuplicate();
            processorHandle = interceptor.processPayloadBeforeEntryCache(duplicateBuffer);
            if (processorHandle != null) {
                ledgerEntry = LedgerEntryImpl.create((long)ledgerEntry.getLedgerId(), (long)ledgerEntry.getEntryId(), (long)ledgerEntry.getLength(), (ByteBuf)processorHandle.getProcessedPayload());
            } else {
                duplicateBuffer.release();
            }
        }
        EntryImpl returnEntry = EntryImpl.create(ledgerEntry, expectedReadCount);
        if (processorHandle != null) {
            processorHandle.release();
            ledgerEntry.close();
        }
        return returnEntry;
    }

    @VisibleForTesting
    public static EntryImpl create(long ledgerId, long entryId, byte[] data) {
        return EntryImpl.create(ledgerId, entryId, data, 0);
    }

    @VisibleForTesting
    public static EntryImpl create(long ledgerId, long entryId, byte[] data, int expectedReadCount) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        entry.data = Unpooled.wrappedBuffer((byte[])data);
        entry.readCountHandler = EntryReadCountHandlerImpl.maybeCreate(expectedReadCount);
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(long ledgerId, long entryId, ByteBuf data) {
        return EntryImpl.create(ledgerId, entryId, data, 0);
    }

    public static EntryImpl create(long ledgerId, long entryId, ByteBuf data, int expectedReadCount) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        entry.data = data;
        entry.data.retain();
        entry.readCountHandler = EntryReadCountHandlerImpl.maybeCreate(expectedReadCount);
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(Position position, ByteBuf data, int expectedReadCount) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.position = PositionFactory.create(position);
        entry.ledgerId = position.getLedgerId();
        entry.entryId = position.getEntryId();
        entry.data = data;
        entry.data.retain();
        entry.readCountHandler = EntryReadCountHandlerImpl.maybeCreate(expectedReadCount);
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl createWithRetainedDuplicate(Position position, ByteBuf data, int expectedReadCount) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.position = PositionFactory.create(position);
        entry.ledgerId = position.getLedgerId();
        entry.entryId = position.getEntryId();
        entry.data = data.retainedDuplicate();
        entry.readCountHandler = EntryReadCountHandlerImpl.maybeCreate(expectedReadCount);
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl createWithRetainedDuplicate(Position position, ByteBuf data, EntryReadCountHandler entryReadCountHandler) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.position = PositionFactory.create(position);
        entry.ledgerId = position.getLedgerId();
        entry.entryId = position.getEntryId();
        entry.data = data.retainedDuplicate();
        entry.readCountHandler = entryReadCountHandler;
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(EntryImpl other) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.position = other.position != null ? PositionFactory.create(other.position) : null;
        entry.ledgerId = other.ledgerId;
        entry.entryId = other.entryId;
        entry.data = other.data.retainedDuplicate();
        entry.readCountHandler = other.readCountHandler;
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(Entry other) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.position = PositionFactory.create(other.getPosition());
        entry.ledgerId = other.getLedgerId();
        entry.entryId = other.getEntryId();
        entry.data = other.getDataBuffer().retainedDuplicate();
        entry.readCountHandler = other.getReadCountHandler();
        entry.setRefCnt(1);
        return entry;
    }

    private EntryImpl(Recycler.Handle<EntryImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void onDeallocate(Runnable r) {
        if (this.onDeallocate == null) {
            this.onDeallocate = r;
        } else {
            Runnable previous = this.onDeallocate;
            this.onDeallocate = () -> {
                try {
                    previous.run();
                }
                finally {
                    r.run();
                }
            };
        }
    }

    @Override
    public ByteBuf getDataBuffer() {
        return this.data;
    }

    @Override
    public byte[] getData() {
        byte[] array = new byte[this.data.readableBytes()];
        this.data.getBytes(this.data.readerIndex(), array);
        return array;
    }

    @Override
    public byte[] getDataAndRelease() {
        byte[] array = this.getData();
        this.release();
        return array;
    }

    @Override
    public int getLength() {
        return this.data.readableBytes();
    }

    @Override
    public Position getPosition() {
        if (this.position == null) {
            this.position = PositionFactory.create(this.ledgerId, this.entryId);
        }
        return this.position;
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public int compareTo(EntryImpl other) {
        if (this.ledgerId != other.ledgerId) {
            return this.ledgerId < other.ledgerId ? -1 : 1;
        }
        if (this.entryId != other.entryId) {
            return this.entryId < other.entryId ? -1 : 1;
        }
        return 0;
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    @Override
    protected void deallocate() {
        if (this.decreaseReadCountOnRelease && this.readCountHandler != null) {
            this.readCountHandler.markRead();
        }
        if (this.onDeallocate != null) {
            try {
                this.onDeallocate.run();
            }
            finally {
                this.onDeallocate = null;
            }
        }
        this.data.release();
        this.data = null;
        this.ledgerId = -1L;
        this.entryId = -1L;
        this.position = null;
        this.readCountHandler = null;
        this.decreaseReadCountOnRelease = true;
        this.recyclerHandle.recycle((Object)this);
    }

    @Override
    public boolean matchesPosition(Position key) {
        return key != null && key.compareTo(this.ledgerId, this.entryId) == 0;
    }

    @Override
    public EntryReadCountHandler getReadCountHandler() {
        return this.readCountHandler;
    }

    public void setDecreaseReadCountOnRelease(boolean enabled) {
        this.decreaseReadCountOnRelease = enabled;
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{ledgerId=" + this.ledgerId + ", entryId=" + this.entryId + "}";
    }
}

