/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.util.AbstractCASReferenceCounted;
import org.apache.bookkeeper.mledger.util.RangeCache;

public final class EntryImpl
extends AbstractCASReferenceCounted
implements Entry,
Comparable<EntryImpl>,
RangeCache.ValueWithKeyValidation<Position> {
    private static final Recycler<EntryImpl> RECYCLER = new Recycler<EntryImpl>(){

        protected EntryImpl newObject(Recycler.Handle<EntryImpl> handle) {
            return new EntryImpl(handle);
        }
    };
    private final Recycler.Handle<EntryImpl> recyclerHandle;
    private long timestamp;
    private long ledgerId;
    private long entryId;
    private Position position;
    ByteBuf data;
    private Runnable onDeallocate;

    public static EntryImpl create(LedgerEntry ledgerEntry) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = ledgerEntry.getLedgerId();
        entry.entryId = ledgerEntry.getEntryId();
        entry.data = ledgerEntry.getEntryBuffer();
        entry.data.retain();
        entry.setRefCnt(1);
        return entry;
    }

    @VisibleForTesting
    public static EntryImpl create(long ledgerId, long entryId, byte[] data) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        entry.data = Unpooled.wrappedBuffer((byte[])data);
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(long ledgerId, long entryId, ByteBuf data) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        entry.data = data;
        entry.data.retain();
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(Position position, ByteBuf data) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = position.getLedgerId();
        entry.entryId = position.getEntryId();
        entry.data = data;
        entry.data.retain();
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(EntryImpl other) {
        EntryImpl entry = (EntryImpl)RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = other.ledgerId;
        entry.entryId = other.entryId;
        entry.data = other.data.retainedDuplicate();
        entry.setRefCnt(1);
        return entry;
    }

    private EntryImpl(Recycler.Handle<EntryImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void onDeallocate(Runnable r) {
        if (this.onDeallocate == null) {
            this.onDeallocate = r;
        } else {
            Runnable previous = this.onDeallocate;
            this.onDeallocate = () -> {
                try {
                    previous.run();
                }
                finally {
                    r.run();
                }
            };
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public ByteBuf getDataBuffer() {
        return this.data;
    }

    @Override
    public byte[] getData() {
        byte[] array = new byte[this.data.readableBytes()];
        this.data.getBytes(this.data.readerIndex(), array);
        return array;
    }

    @Override
    public byte[] getDataAndRelease() {
        byte[] array = this.getData();
        this.release();
        return array;
    }

    @Override
    public int getLength() {
        return this.data.readableBytes();
    }

    @Override
    public Position getPosition() {
        if (this.position == null) {
            this.position = PositionFactory.create(this.ledgerId, this.entryId);
        }
        return this.position;
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public int compareTo(EntryImpl other) {
        if (this.ledgerId != other.ledgerId) {
            return this.ledgerId < other.ledgerId ? -1 : 1;
        }
        if (this.entryId != other.entryId) {
            return this.entryId < other.entryId ? -1 : 1;
        }
        return 0;
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    @Override
    protected void deallocate() {
        if (this.onDeallocate != null) {
            try {
                this.onDeallocate.run();
            }
            finally {
                this.onDeallocate = null;
            }
        }
        this.data.release();
        this.data = null;
        this.timestamp = -1L;
        this.ledgerId = -1L;
        this.entryId = -1L;
        this.position = null;
        this.recyclerHandle.recycle((Object)this);
    }

    @Override
    public boolean matchesKey(Position key) {
        return key.compareTo(this.ledgerId, this.entryId) == 0;
    }
}

