/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeCache<Key extends Comparable<Key>, Value extends ValueWithKeyValidation<Key>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangeCache.class);
    private final ConcurrentNavigableMap<Key, EntryWrapper<Key, Value>> entries;
    private AtomicLong size = new AtomicLong(0L);
    private final Weighter<Value> weighter;
    private final TimestampExtractor<Value> timestampExtractor;

    public RangeCache() {
        this(new DefaultWeighter(), x -> System.nanoTime());
    }

    public RangeCache(Weighter<Value> weighter, TimestampExtractor<Value> timestampExtractor) {
        this.entries = new ConcurrentSkipListMap<Key, EntryWrapper<Key, Value>>();
        this.weighter = weighter;
        this.timestampExtractor = timestampExtractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Key key, Value value) {
        value.retain();
        try {
            if (!value.matchesKey(key)) {
                throw new IllegalArgumentException("Value '" + String.valueOf(value) + "' does not match key '" + String.valueOf(key) + "'");
            }
            long entrySize = this.weighter.getSize(value);
            EntryWrapper<Key, Value> newWrapper = EntryWrapper.create(key, value, entrySize);
            if (this.entries.putIfAbsent(key, newWrapper) == null) {
                this.size.addAndGet(entrySize);
                boolean bl = true;
                return bl;
            }
            newWrapper.recycle();
            boolean bl = false;
            return bl;
        }
        finally {
            value.release();
        }
    }

    public boolean exists(Key key) {
        return key != null ? this.entries.containsKey(key) : true;
    }

    public Value get(Key key) {
        return this.getValueFromWrapper(key, (EntryWrapper)this.entries.get(key));
    }

    private Value getValueFromWrapper(Key key, EntryWrapper<Key, Value> valueWrapper) {
        if (valueWrapper == null) {
            return null;
        }
        ValueWithKeyValidation value = (ValueWithKeyValidation)valueWrapper.getValue(key);
        return (Value)this.getRetainedValueMatchingKey(key, value);
    }

    private Value getValueMatchingEntry(Map.Entry<Key, EntryWrapper<Key, Value>> entry) {
        ValueWithKeyValidation valueMatchingEntry = (ValueWithKeyValidation)EntryWrapper.getValueMatchingMapEntry(entry);
        return (Value)this.getRetainedValueMatchingKey((Comparable)entry.getKey(), valueMatchingEntry);
    }

    private Value getRetainedValueMatchingKey(Key key, Value value) {
        if (value == null) {
            return null;
        }
        try {
            value.retain();
        }
        catch (IllegalReferenceCountException e) {
            return null;
        }
        if (value.refCnt() > 1 && value.matchesKey(key)) {
            return value;
        }
        value.release();
        return null;
    }

    public Collection<Value> getRange(Key first, Key last) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry entry : this.entries.subMap((Object)first, true, (Object)last, true).entrySet()) {
            Value value = this.getValueMatchingEntry(entry);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public Pair<Integer, Long> removeRange(Key first, Key last, boolean lastInclusive) {
        if (log.isDebugEnabled()) {
            log.debug("Removing entries in range [{}, {}], lastInclusive: {}", new Object[]{first, last, lastInclusive});
        }
        RemovalCounters counters = RemovalCounters.create();
        NavigableMap subMap = this.entries.subMap((Object)first, true, (Object)last, lastInclusive);
        for (Map.Entry entry : subMap.entrySet()) {
            this.removeEntry(entry, counters);
        }
        return this.handleRemovalResult(counters);
    }

    private RemoveEntryResult removeEntry(Map.Entry<Key, EntryWrapper<Key, Value>> entry, RemovalCounters counters) {
        return this.removeEntry(entry, counters, x -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoveEntryResult removeEntry(Map.Entry<Key, EntryWrapper<Key, Value>> entry, RemovalCounters counters, Predicate<Value> removeCondition) {
        Comparable key = (Comparable)entry.getKey();
        EntryWrapper<Key, Value> entryWrapper = entry.getValue();
        Value value = this.getValueMatchingEntry(entry);
        if (value == null) {
            this.entries.remove(key, entryWrapper);
            return RemoveEntryResult.CONTINUE_LOOP;
        }
        try {
            if (!removeCondition.test(value)) {
                RemoveEntryResult removeEntryResult = RemoveEntryResult.BREAK_LOOP;
                return removeEntryResult;
            }
            boolean entryRemoved = this.entries.remove(key, entryWrapper);
            if (entryRemoved) {
                counters.entryRemoved(entryWrapper.getSize());
                if (value.refCnt() > 1) {
                    entryWrapper.recycle();
                    value.release();
                } else {
                    log.info("Unexpected refCnt {} for key {}, removed entry without releasing the value", (Object)value.refCnt(), (Object)key);
                }
                RemoveEntryResult removeEntryResult = RemoveEntryResult.ENTRY_REMOVED;
                return removeEntryResult;
            }
            RemoveEntryResult removeEntryResult = RemoveEntryResult.CONTINUE_LOOP;
            return removeEntryResult;
        }
        finally {
            value.release();
        }
    }

    private Pair<Integer, Long> handleRemovalResult(RemovalCounters counters) {
        this.size.addAndGet(-counters.removedSize);
        Pair result = Pair.of((Object)counters.removedEntries, (Object)counters.removedSize);
        counters.recycle();
        return result;
    }

    public Pair<Integer, Long> evictLeastAccessedEntries(long minSize) {
        Map.Entry entry;
        if (log.isDebugEnabled()) {
            log.debug("Evicting entries to reach a minimum size of {}", (Object)minSize);
        }
        Preconditions.checkArgument((minSize > 0L ? 1 : 0) != 0);
        RemovalCounters counters = RemovalCounters.create();
        while (counters.removedSize < minSize && !Thread.currentThread().isInterrupted() && (entry = this.entries.firstEntry()) != null) {
            this.removeEntry(entry, counters);
        }
        return this.handleRemovalResult(counters);
    }

    public Pair<Integer, Long> evictLEntriesBeforeTimestamp(long maxTimestamp) {
        Map.Entry entry;
        if (log.isDebugEnabled()) {
            log.debug("Evicting entries with timestamp <= {}", (Object)maxTimestamp);
        }
        RemovalCounters counters = RemovalCounters.create();
        while (!Thread.currentThread().isInterrupted() && (entry = this.entries.firstEntry()) != null && this.removeEntry(entry, counters, value -> this.timestampExtractor.getTimestamp(value) <= maxTimestamp) != RemoveEntryResult.BREAK_LOOP) {
        }
        return this.handleRemovalResult(counters);
    }

    protected long getNumberOfEntries() {
        return this.entries.size();
    }

    public long getSize() {
        return this.size.get();
    }

    public Pair<Integer, Long> clear() {
        Map.Entry entry;
        if (log.isDebugEnabled()) {
            log.debug("Clearing the cache with {} entries and size {}", (Object)this.entries.size(), (Object)this.size.get());
        }
        RemovalCounters counters = RemovalCounters.create();
        while (!Thread.currentThread().isInterrupted() && (entry = this.entries.firstEntry()) != null) {
            this.removeEntry(entry, counters);
        }
        return this.handleRemovalResult(counters);
    }

    private static class DefaultWeighter<Value>
    implements Weighter<Value> {
        private DefaultWeighter() {
        }

        @Override
        public long getSize(Value value) {
            return 1L;
        }
    }

    public static interface TimestampExtractor<ValueT> {
        public long getTimestamp(ValueT var1);
    }

    public static interface Weighter<ValueT> {
        public long getSize(ValueT var1);
    }

    public static interface ValueWithKeyValidation<T>
    extends ReferenceCounted {
        public boolean matchesKey(T var1);
    }

    private static class EntryWrapper<K, V> {
        private final Recycler.Handle<EntryWrapper> recyclerHandle;
        private static final Recycler<EntryWrapper> RECYCLER = new Recycler<EntryWrapper>(){

            protected EntryWrapper newObject(Recycler.Handle<EntryWrapper> recyclerHandle) {
                return new EntryWrapper(recyclerHandle);
            }
        };
        private final StampedLock lock = new StampedLock();
        private K key;
        private V value;
        long size;

        private EntryWrapper(Recycler.Handle<EntryWrapper> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static <K, V> EntryWrapper<K, V> create(K key, V value, long size) {
            EntryWrapper entryWrapper = (EntryWrapper)RECYCLER.get();
            long stamp = entryWrapper.lock.writeLock();
            entryWrapper.key = key;
            entryWrapper.value = value;
            entryWrapper.size = size;
            entryWrapper.lock.unlockWrite(stamp);
            return entryWrapper;
        }

        K getKey() {
            long stamp = this.lock.tryOptimisticRead();
            K localKey = this.key;
            if (!this.lock.validate(stamp)) {
                stamp = this.lock.readLock();
                localKey = this.key;
                this.lock.unlockRead(stamp);
            }
            return localKey;
        }

        V getValue(K key) {
            return this.getValueInternal(key, false);
        }

        static <K, V> V getValueMatchingMapEntry(Map.Entry<K, EntryWrapper<K, V>> entry) {
            return entry.getValue().getValueInternal(entry.getKey(), true);
        }

        private V getValueInternal(K key, boolean requireSameKeyInstance) {
            long stamp = this.lock.tryOptimisticRead();
            K localKey = this.key;
            V localValue = this.value;
            if (!this.lock.validate(stamp)) {
                stamp = this.lock.readLock();
                localKey = this.key;
                localValue = this.value;
                this.lock.unlockRead(stamp);
            }
            if (localKey != key && (requireSameKeyInstance || localKey == null || !localKey.equals(key))) {
                return null;
            }
            return localValue;
        }

        long getSize() {
            long stamp = this.lock.tryOptimisticRead();
            long localSize = this.size;
            if (!this.lock.validate(stamp)) {
                stamp = this.lock.readLock();
                localSize = this.size;
                this.lock.unlockRead(stamp);
            }
            return localSize;
        }

        void recycle() {
            this.key = null;
            this.value = null;
            this.size = 0L;
            this.recyclerHandle.recycle((Object)this);
        }
    }

    private static class RemovalCounters {
        private final Recycler.Handle<RemovalCounters> recyclerHandle;
        private static final Recycler<RemovalCounters> RECYCLER = new Recycler<RemovalCounters>(){

            protected RemovalCounters newObject(Recycler.Handle<RemovalCounters> recyclerHandle) {
                return new RemovalCounters(recyclerHandle);
            }
        };
        int removedEntries;
        long removedSize;

        private RemovalCounters(Recycler.Handle<RemovalCounters> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static <T> RemovalCounters create() {
            RemovalCounters results = (RemovalCounters)RECYCLER.get();
            results.removedEntries = 0;
            results.removedSize = 0L;
            return results;
        }

        void recycle() {
            this.removedEntries = 0;
            this.removedSize = 0L;
            this.recyclerHandle.recycle((Object)this);
        }

        public void entryRemoved(long size) {
            this.removedSize += size;
            ++this.removedEntries;
        }
    }

    static enum RemoveEntryResult {
        ENTRY_REMOVED,
        CONTINUE_LOOP,
        BREAK_LOOP;

    }
}

