/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import io.netty.util.Recycler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpReadEntry
implements AsyncCallbacks.ReadEntriesCallback {
    ManagedCursorImpl cursor;
    Position readPosition;
    private int count;
    private AsyncCallbacks.ReadEntriesCallback callback;
    Object ctx;
    private List<Entry> entries;
    private Position nextReadPosition;
    Position maxPosition;
    Predicate<Position> skipCondition;
    private final Recycler.Handle<OpReadEntry> recyclerHandle;
    private static final Recycler<OpReadEntry> RECYCLER = new Recycler<OpReadEntry>(){

        protected OpReadEntry newObject(Recycler.Handle<OpReadEntry> recyclerHandle) {
            return new OpReadEntry(recyclerHandle);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(OpReadEntry.class);

    public static OpReadEntry create(ManagedCursorImpl cursor, Position readPositionRef, int count, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, Position maxPosition, Predicate<Position> skipCondition) {
        OpReadEntry op = (OpReadEntry)RECYCLER.get();
        op.readPosition = cursor.ledger.startReadOperationOnLedger(readPositionRef);
        op.cursor = cursor;
        op.count = count;
        op.callback = callback;
        op.entries = new ArrayList<Entry>();
        if (maxPosition == null) {
            maxPosition = PositionFactory.LATEST;
        }
        op.maxPosition = maxPosition;
        op.skipCondition = skipCondition;
        op.ctx = ctx;
        op.nextReadPosition = PositionFactory.create(op.readPosition);
        return op;
    }

    void internalReadEntriesComplete(List<Entry> returnedEntries, Object ctx, Position lastPosition) {
        int entriesCount = returnedEntries.size();
        long entriesSize = 0L;
        for (int i = 0; i < entriesCount; ++i) {
            entriesSize += (long)returnedEntries.get(i).getLength();
        }
        this.cursor.updateReadStats(entriesCount, entriesSize);
        if (entriesCount != 0) {
            lastPosition = returnedEntries.get(entriesCount - 1).getPosition();
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Read entries succeeded batch_size={} cumulative_size={} requested_count={}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), returnedEntries.size(), this.entries.size(), this.count});
        }
        List<Object> filteredEntries = Collections.emptyList();
        if (entriesCount != 0) {
            filteredEntries = this.cursor.filterReadEntries(returnedEntries);
            this.entries.addAll(filteredEntries);
        }
        Position nexReadPosition = entriesCount != filteredEntries.size() ? this.cursor.getNextAvailablePosition(lastPosition) : lastPosition.getNext();
        this.updateReadPosition(nexReadPosition);
        this.checkReadCompletion();
    }

    @Override
    public void readEntriesComplete(List<Entry> returnedEntries, Object ctx) {
        this.internalReadEntriesComplete(returnedEntries, ctx, null);
    }

    @Override
    public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        this.cursor.readOperationCompleted();
        if (!this.entries.isEmpty()) {
            this.cursor.ledger.getExecutor().execute(() -> {
                this.callback.readEntriesComplete(this.entries, ctx);
                this.recycle();
            });
        } else if (this.cursor.getConfig().isAutoSkipNonRecoverableData() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException) {
            Position nexReadPosition;
            log.warn("[{}][{}] read failed from ledger at position:{} : {}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition, exception.getMessage()});
            ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.cursor.getManagedLedger();
            Long lostLedger = null;
            if (exception instanceof ManagedLedgerException.LedgerNotExistException) {
                nexReadPosition = this.cursor.getNextLedgerPosition(this.readPosition.getLedgerId());
                lostLedger = this.readPosition.getLedgerId();
            } else {
                nexReadPosition = ledger.getValidPositionAfterSkippedEntries(this.readPosition, this.count);
            }
            if (nexReadPosition == null) {
                this.callback.readEntriesFailed(exception, ctx);
                this.cursor.ledger.mbean.recordReadEntriesError();
                this.recycle();
                return;
            }
            this.updateReadPosition(nexReadPosition);
            if (lostLedger != null) {
                this.cursor.getManagedLedger().skipNonRecoverableLedger(lostLedger);
            } else {
                this.cursor.skipNonRecoverableEntries(this.readPosition, nexReadPosition);
            }
            this.checkReadCompletion();
        } else {
            if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
                log.warn("[{}][{}] read failed from ledger at position:{}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition, exception});
            } else if (log.isDebugEnabled()) {
                log.debug("[{}][{}] read throttled failed from ledger at position:{}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition});
            }
            this.callback.readEntriesFailed(exception, ctx);
            this.cursor.ledger.mbean.recordReadEntriesError();
            this.recycle();
        }
    }

    void updateReadPosition(Position newReadPosition) {
        this.nextReadPosition = newReadPosition;
        this.cursor.setReadPosition(this.nextReadPosition);
    }

    void checkReadCompletion() {
        if (this.entries.size() < this.count && this.cursor.hasMoreEntries() && this.maxPosition.compareTo(this.readPosition) > 0) {
            this.cursor.ledger.getExecutor().execute(() -> {
                this.readPosition = this.cursor.ledger.startReadOperationOnLedger(this.nextReadPosition);
                this.cursor.ledger.asyncReadEntries(this);
            });
        } else {
            try {
                this.cursor.readOperationCompleted();
            }
            finally {
                this.cursor.ledger.getExecutor().execute(() -> {
                    this.callback.readEntriesComplete(this.entries, this.ctx);
                    this.recycle();
                });
            }
        }
    }

    public int getNumberOfEntriesToRead() {
        return this.count - this.entries.size();
    }

    private OpReadEntry(Recycler.Handle<OpReadEntry> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.count = 0;
        this.cursor = null;
        this.readPosition = null;
        this.callback = null;
        this.ctx = null;
        this.entries = null;
        this.nextReadPosition = null;
        this.maxPosition = null;
        this.skipCondition = null;
        this.recyclerHandle.recycle((Object)this);
    }
}

