/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.intercept;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.impl.OpAddEntry;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface ManagedLedgerInterceptor {
    public OpAddEntry beforeAddEntry(OpAddEntry var1, int var2);

    default public void afterFailedAddEntry(int numberOfMessages) {
    }

    public void onManagedLedgerPropertiesInitialize(Map<String, String> var1);

    public CompletableFuture<Void> onManagedLedgerLastLedgerInitialize(String var1, LedgerHandle var2);

    public void onUpdateManagedLedgerInfo(Map<String, String> var1);

    default public PayloadProcessorHandle processPayloadBeforeEntryCache(ByteBuf dataReadFromLedger) {
        return null;
    }

    default public PayloadProcessorHandle processPayloadBeforeLedgerWrite(OpAddEntry ledgerWriteOp, ByteBuf dataToBeStoredInLedger) {
        return null;
    }

    public static interface PayloadProcessorHandle {
        public ByteBuf getProcessedPayload();

        public void release();
    }
}

