/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.StampedLock;
import lombok.Generated;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.tuple.Pair;

public class ManagedCursorContainer
implements Iterable<ManagedCursor> {
    private long version;
    private final ArrayList<Item> heap = new ArrayList();
    private final ConcurrentMap<String, Item> cursors = new ConcurrentSkipListMap<String, Item>();
    private final StampedLock rwLock = new StampedLock();
    private int durableCursorCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ManagedCursor cursor, Position position) {
        long stamp = this.rwLock.writeLock();
        try {
            Item item = new Item(cursor, (PositionImpl)position, position != null ? this.heap.size() : -1);
            this.cursors.put(cursor.getName(), item);
            if (position != null) {
                this.heap.add(item);
                if (this.heap.size() > 1) {
                    this.siftUp(item);
                }
            }
            if (cursor.isDurable()) {
                ++this.durableCursorCount;
            }
            this.version = DataVersion.getNextVersion(this.version);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedCursor get(String name) {
        long stamp = this.rwLock.readLock();
        try {
            Item item = (Item)this.cursors.get(name);
            ManagedCursor managedCursor = item != null ? item.cursor : null;
            return managedCursor;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCursor(String name) {
        long stamp = this.rwLock.writeLock();
        try {
            Item item = (Item)this.cursors.remove(name);
            if (item != null) {
                if (item.idx >= 0) {
                    if (this.heap.size() == 1) {
                        this.heap.clear();
                    } else {
                        Item lastItem = this.heap.get(this.heap.size() - 1);
                        this.swap(item, lastItem);
                        this.heap.remove(item.idx);
                        this.siftDown(lastItem);
                    }
                }
                if (item.cursor.isDurable()) {
                    --this.durableCursorCount;
                }
                this.version = DataVersion.getNextVersion(this.version);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<PositionImpl, PositionImpl> cursorUpdated(ManagedCursor cursor, Position newPosition) {
        Objects.requireNonNull(cursor);
        long stamp = this.rwLock.writeLock();
        try {
            Item item = (Item)this.cursors.get(cursor.getName());
            if (item == null || item.idx == -1) {
                Pair<PositionImpl, PositionImpl> pair = null;
                return pair;
            }
            PositionImpl previousSlowestConsumer = this.heap.get((int)0).position;
            item.position = (PositionImpl)newPosition;
            this.version = DataVersion.getNextVersion(this.version);
            if (this.heap.size() == 1) {
                Pair pair = Pair.of((Object)previousSlowestConsumer, (Object)item.position);
                return pair;
            }
            if (item.idx == 0 || this.getParent((Item)item).position.compareTo(item.position) <= 0) {
                this.siftDown(item);
            } else {
                this.siftUp(item);
            }
            PositionImpl newSlowestConsumer = this.heap.get((int)0).position;
            Pair pair = Pair.of((Object)previousSlowestConsumer, (Object)newSlowestConsumer);
            return pair;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionImpl getSlowestReaderPosition() {
        long stamp = this.rwLock.readLock();
        try {
            PositionImpl positionImpl = this.heap.isEmpty() ? null : this.heap.get((int)0).position;
            return positionImpl;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedCursor getSlowestReader() {
        long stamp = this.rwLock.readLock();
        try {
            ManagedCursor managedCursor = this.heap.isEmpty() ? null : this.heap.get((int)0).cursor;
            return managedCursor;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorInfo getCursorWithOldestPosition() {
        long stamp = this.rwLock.readLock();
        try {
            if (this.heap.isEmpty()) {
                CursorInfo cursorInfo = null;
                return cursorInfo;
            }
            Item item = this.heap.get(0);
            CursorInfo cursorInfo = new CursorInfo(item.cursor, item.position, this.version);
            return cursorInfo;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isEmpty = this.cursors.isEmpty();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isEmpty = this.cursors.isEmpty();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDurableCursors() {
        long stamp = this.rwLock.tryOptimisticRead();
        int count = this.durableCursorCount;
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                count = this.durableCursorCount;
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long stamp = this.rwLock.readLock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            boolean first = true;
            for (Item item : this.cursors.values()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(item.cursor);
            }
            sb.append(']');
            String string = sb.toString();
            return string;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    @Override
    public Iterator<ManagedCursor> iterator() {
        final Iterator it = this.cursors.entrySet().iterator();
        return new Iterator<ManagedCursor>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ManagedCursor next() {
                return ((Item)((Map.Entry)it.next()).getValue()).cursor;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("Cannot remove ManagedCursor from container");
            }
        };
    }

    private void siftUp(Item item) {
        Item parent = this.getParent(item);
        while (item.idx > 0 && parent.position.compareTo(item.position) > 0) {
            this.swap(item, parent);
            parent = this.getParent(item);
        }
    }

    private void siftDown(Item item) {
        while (true) {
            Item j = null;
            Item right = this.getRight(item);
            if (right != null && right.position.compareTo(item.position) < 0) {
                left = this.getLeft(item);
                j = left != null && left.position.compareTo(right.position) < 0 ? left : right;
            } else {
                left = this.getLeft(item);
                if (left != null && left.position.compareTo(item.position) < 0) {
                    j = left;
                }
            }
            if (j == null) break;
            this.swap(item, j);
        }
    }

    private void swap(Item item1, Item item2) {
        int idx1 = item1.idx;
        int idx2 = item2.idx;
        this.heap.set(idx2, item1);
        this.heap.set(idx1, item2);
        item1.idx = idx2;
        item2.idx = idx1;
    }

    private Item getParent(Item item) {
        return this.heap.get((item.idx - 1) / 2);
    }

    private Item getLeft(Item item) {
        int i = item.idx * 2 + 1;
        return i < this.heap.size() ? this.heap.get(i) : null;
    }

    private Item getRight(Item item) {
        int i = item.idx * 2 + 2;
        return i < this.heap.size() ? this.heap.get(i) : null;
    }

    private static class Item {
        final ManagedCursor cursor;
        PositionImpl position;
        int idx;

        Item(ManagedCursor cursor, PositionImpl position, int idx) {
            this.cursor = cursor;
            this.position = position;
            this.idx = idx;
        }
    }

    public static final class DataVersion {
        public static int compareVersions(long v1, long v2) {
            if (v1 == v2) {
                return 0;
            }
            if (v2 > v1) {
                long distance = v2 - v1;
                long wrapAroundDistance = Long.MAX_VALUE - v2 + v1;
                if (distance < wrapAroundDistance) {
                    return -1;
                }
                return 1;
            }
            long distance = v1 - v2;
            long wrapAroundDistance = Long.MAX_VALUE - v1 + v2;
            if (distance < wrapAroundDistance) {
                return 1;
            }
            return -1;
        }

        public static long getNextVersion(long existingVersion) {
            if (existingVersion == Long.MAX_VALUE) {
                return 0L;
            }
            return existingVersion + 1L;
        }

        @Generated
        private DataVersion() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class CursorInfo {
        private final ManagedCursor cursor;
        private final PositionImpl position;
        private final long version;

        @Generated
        public CursorInfo(ManagedCursor cursor, PositionImpl position, long version) {
            this.cursor = cursor;
            this.position = position;
            this.version = version;
        }

        @Generated
        public ManagedCursor getCursor() {
            return this.cursor;
        }

        @Generated
        public PositionImpl getPosition() {
            return this.position;
        }

        @Generated
        public long getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CursorInfo)) {
                return false;
            }
            CursorInfo other = (CursorInfo)o;
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            ManagedCursor this$cursor = this.getCursor();
            ManagedCursor other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            PositionImpl this$position = this.getPosition();
            PositionImpl other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $version = this.getVersion();
            result = result * 59 + (int)($version >>> 32 ^ $version);
            ManagedCursor $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            PositionImpl $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ManagedCursorContainer.CursorInfo(cursor=" + String.valueOf(this.getCursor()) + ", position=" + String.valueOf(this.getPosition()) + ", version=" + this.getVersion() + ")";
        }
    }
}

