/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Suppliers;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.jclouds.util.Throwables2;

public class Suppliers2 {
    public static <K, V> Supplier<V> getLastValueInMap(final Supplier<Map<K, Supplier<V>>> input) {
        return new Supplier<V>(){

            @Override
            public V get() {
                Supplier last = (Supplier)Iterables.getLast(((Map)input.get()).values());
                return last != null ? (Object)last.get() : null;
            }

            public String toString() {
                return "getLastValueInMap()";
            }
        };
    }

    public static <K, V> Supplier<V> getValueInMapOrNull(final Supplier<Map<K, Supplier<V>>> input, final K keyValue) {
        return new Supplier<V>(){

            @Override
            public V get() {
                Map map = (Map)input.get();
                return map.containsKey(keyValue) ? (Object)((Supplier)map.get(keyValue)).get() : null;
            }

            public String toString() {
                return String.format("getValueInMapOrNull('%1$s')", keyValue);
            }
        };
    }

    public static <X> Function<X, Supplier<X>> ofInstanceFunction() {
        return new Function<X, Supplier<X>>(){

            @Override
            public Supplier<X> apply(X arg0) {
                return Suppliers.ofInstance(arg0);
            }

            public String toString() {
                return "Suppliers.ofInstance()";
            }
        };
    }

    @Beta
    public static <T> Supplier<T> or(final Supplier<T> unlessNull, final Supplier<T> fallback) {
        return new Supplier<T>(){

            @Override
            public T get() {
                Object val = unlessNull.get();
                if (val != null) {
                    return val;
                }
                return fallback.get();
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("unlessNull", unlessNull).add("fallback", fallback).toString();
            }
        };
    }

    @Beta
    public static <T, X extends Throwable> Supplier<T> onThrowable(final Supplier<T> unlessThrowable, final Class<X> throwable, final Supplier<T> fallback) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return unlessThrowable.get();
                }
                catch (Throwable t) {
                    if (Throwables2.getFirstThrowableOfType(t, throwable) != null) {
                        return fallback.get();
                    }
                    throw Throwables.propagate(t);
                }
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("unlessThrowable", unlessThrowable).add("throwable", throwable.getSimpleName()).add("fallback", fallback).toString();
            }
        };
    }
}

