/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers.internal;

import java.util.Map;
import java.util.Properties;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;

public class UpdateProviderMetadataFromProperties
implements Function<Properties, ProviderMetadata> {
    private final ApiMetadata apiMetadata;
    private final Optional<ProviderMetadata> providerMetadata;

    public UpdateProviderMetadataFromProperties(ProviderMetadata providerMetadata) {
        this(Preconditions.checkNotNull(providerMetadata, "providerMetadata").getApiMetadata(), Optional.of(providerMetadata));
    }

    public UpdateProviderMetadataFromProperties(ApiMetadata apiMetadata) {
        this(Preconditions.checkNotNull(apiMetadata, "apiMetadata"), Optional.absent());
    }

    public UpdateProviderMetadataFromProperties(ApiMetadata apiMetadata, Optional<ProviderMetadata> providerMetadata) {
        this.apiMetadata = Preconditions.checkNotNull(apiMetadata, "apiMetadata");
        this.providerMetadata = Preconditions.checkNotNull(providerMetadata, "providerMetadata");
    }

    @Override
    public ProviderMetadata apply(Properties input) {
        Properties mutable = new Properties();
        mutable.putAll((Map<?, ?>)input);
        ApiMetadata apiMetadata = this.apiMetadata.toBuilder().name(UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.api", this.apiMetadata.getName())).version(UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.api-version", this.apiMetadata.getVersion())).buildVersion(UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.build-version", this.apiMetadata.getBuildVersion().orNull())).build();
        String endpoint = UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.endpoint", this.providerMetadata.isPresent() ? this.providerMetadata.get().getEndpoint() : null);
        String providerId = UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.provider", this.providerMetadata.isPresent() ? this.providerMetadata.get().getId() : apiMetadata.getId());
        String isoCodes = UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.iso3166-codes", this.providerMetadata.isPresent() ? Joiner.on(',').join(this.providerMetadata.get().getIso3166Codes()) : "");
        ProviderMetadata providerMetadata = this.providerMetadata.or(AnonymousProviderMetadata.forApiWithEndpoint(apiMetadata, Preconditions.checkNotNull(endpoint, "jclouds.endpoint"))).toBuilder().apiMetadata(apiMetadata).id(providerId).iso3166Codes(Splitter.on(',').omitEmptyStrings().split(isoCodes)).endpoint(endpoint).defaultProperties(mutable).build();
        return providerMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAndRemove(Properties expanded, String key, String defaultVal) {
        try {
            String string = expanded.getProperty(key, defaultVal);
            return string;
        }
        finally {
            expanded.remove(key);
        }
    }
}

