/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.FluentIterable;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.Invokable;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.Parameter;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.TypeToken;
import org.apache.pulsar.jcloud.shade.com.google.gson.FieldNamingStrategy;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.jclouds.json.SerializedNames;
import org.jclouds.reflect.Reflection2;

public class NamingStrategies {

    public static final class AnnotationConstructorNamingStrategy
    extends AnnotationBasedNamingStrategy {
        private final Predicate<Invokable<?, ?>> hasMarker;
        private final Collection<? extends Class<? extends Annotation>> markers;

        public AnnotationConstructorNamingStrategy(Collection<? extends Class<? extends Annotation>> markers, Iterable<? extends NameExtractor<?>> extractors) {
            super(extractors);
            this.markers = Preconditions.checkNotNull(markers, "you must supply at least one annotation to mark deserialization constructors");
            this.hasMarker = AnnotationConstructorNamingStrategy.hasAnnotationIn(markers);
        }

        private static Predicate<Invokable<?, ?>> hasAnnotationIn(final Collection<? extends Class<? extends Annotation>> markers) {
            return new Predicate<Invokable<?, ?>>(){

                @Override
                public boolean apply(Invokable<?, ?> input) {
                    return FluentIterable.from(Arrays.asList(input.getAnnotations())).transform(new Function<Annotation, Class<? extends Annotation>>(){

                        @Override
                        public Class<? extends Annotation> apply(Annotation input) {
                            return input.annotationType();
                        }
                    }).anyMatch(Predicates.in(markers));
                }
            };
        }

        @VisibleForTesting
        <T> Invokable<T, T> getDeserializer(TypeToken<T> token) {
            return Iterables.tryFind(Reflection2.constructors(token), this.hasMarker).orNull();
        }

        @VisibleForTesting
        <T> String translateName(Invokable<T, T> c, int index) {
            String name;
            block3: {
                block2: {
                    Object[] names;
                    name = null;
                    if ((!this.markers.contains(ConstructorProperties.class) || c.getAnnotation(ConstructorProperties.class) == null) && (!this.markers.contains(SerializedNames.class) || c.getAnnotation(SerializedNames.class) == null)) break block2;
                    Object[] objectArray = names = c.getAnnotation(SerializedNames.class) != null ? c.getAnnotation(SerializedNames.class).value() : c.getAnnotation(ConstructorProperties.class).value();
                    if (names.length != c.getParameters().size()) {
                        String message = "Incorrect count of names on annotation of %s. Class: [%s]. Annotation config: [%s]. Parameters; [%s]";
                        String types = Joiner.on(",").join(Iterables.transform(c.getParameters(), new Function<Parameter, String>(){

                            @Override
                            public String apply(Parameter input) {
                                return input.getClass().getName();
                            }
                        }));
                        throw new IllegalArgumentException(String.format(message, c, c.getDeclaringClass().getName(), Joiner.on(",").join(names), types));
                    }
                    if (names == null || names.length <= index) break block3;
                    name = names[index];
                    break block3;
                }
                for (Annotation annotation : ((Parameter)c.getParameters().get(index)).getAnnotations()) {
                    if (!this.annotationToNameExtractor.containsKey(annotation.annotationType())) continue;
                    name = ((NameExtractor)this.annotationToNameExtractor.get(annotation.annotationType())).apply(annotation);
                    break;
                }
            }
            return name;
        }
    }

    public static class AnnotationOrNameFieldNamingStrategy
    extends AnnotationFieldNamingStrategy
    implements FieldNamingStrategy {
        public AnnotationOrNameFieldNamingStrategy(Iterable<? extends NameExtractor<?>> extractors) {
            super(extractors);
        }

        @Override
        public String translateName(Field f) {
            String result = super.translateName(f);
            return result == null ? f.getName() : result;
        }
    }

    public static class AnnotationFieldNamingStrategy
    extends AnnotationBasedNamingStrategy
    implements FieldNamingStrategy {
        public AnnotationFieldNamingStrategy(Iterable<? extends NameExtractor<?>> extractors) {
            super(extractors);
            Preconditions.checkArgument(extractors.iterator().hasNext(), "you must supply at least one name extractor, for example: " + ExtractSerializedName.class.getSimpleName());
        }

        @Override
        public String translateName(Field f) {
            if (Modifier.isAbstract(f.getDeclaringClass().getSuperclass().getModifiers())) {
                for (Invokable invokable : Reflection2.constructors(TypeToken.of(f.getDeclaringClass().getSuperclass()))) {
                    SerializedNames names = invokable.getAnnotation(SerializedNames.class);
                    if (names == null || !invokable.isStatic()) continue;
                    List<Field> declaredFields = Arrays.asList(f.getDeclaringClass().getDeclaredFields());
                    Iterable<Field> fields = Iterables.filter(declaredFields, new Predicate<Field>(){

                        @Override
                        public boolean apply(Field input) {
                            return !input.isSynthetic();
                        }
                    });
                    int numFields = Iterables.size(fields);
                    if (numFields != names.value().length) {
                        String message = "Incorrect number of names on %s. Class [%s]. Annotation config: [%s]. Fields in object; [%s]";
                        String types = Joiner.on(",").join(Iterables.transform(fields, new Function<Field, String>(){

                            @Override
                            public String apply(Field input) {
                                return input.getType().getName();
                            }
                        }));
                        throw new IllegalStateException(String.format(message, names, f.getDeclaringClass().getName(), Joiner.on(",").join(names.value()), types));
                    }
                    for (int i = 0; i < numFields; ++i) {
                        if (!Iterables.get(fields, i).equals(f)) continue;
                        return names.value()[i];
                    }
                    throw new IllegalStateException("Inconsistent state. Ensure type is AutoValue on " + invokable);
                }
            }
            for (Annotation annotation : f.getAnnotations()) {
                if (!this.annotationToNameExtractor.containsKey(annotation.annotationType())) continue;
                return ((NameExtractor)this.annotationToNameExtractor.get(annotation.annotationType())).apply(annotation);
            }
            return null;
        }
    }

    public static abstract class AnnotationBasedNamingStrategy {
        protected final Map<Class<? extends Annotation>, ? extends NameExtractor<?>> annotationToNameExtractor;
        protected final String forToString;

        public AnnotationBasedNamingStrategy(Iterable<? extends NameExtractor<?>> extractors) {
            Preconditions.checkNotNull(extractors, "means to extract names by annotations");
            this.annotationToNameExtractor = Maps.uniqueIndex(extractors, new Function<NameExtractor<?>, Class<? extends Annotation>>(){

                @Override
                public Class<? extends Annotation> apply(NameExtractor<?> input) {
                    return input.annotationType();
                }
            });
            this.forToString = Joiner.on(",").join(Iterables.transform(extractors, new Function<NameExtractor<?>, String>(){

                @Override
                public String apply(NameExtractor<?> input) {
                    return input.annotationType().getName();
                }
            }));
        }

        public String toString() {
            return "AnnotationBasedNamingStrategy requiring one of " + this.forToString;
        }
    }

    public static class ExtractNamed
    extends NameExtractor<Named> {
        public ExtractNamed() {
            super(Named.class);
        }

        @Override
        public String extractName(Named in) {
            return Preconditions.checkNotNull(in, "input annotation").value();
        }
    }

    public static class ExtractSerializedName
    extends NameExtractor<SerializedName> {
        public ExtractSerializedName() {
            super(SerializedName.class);
        }

        @Override
        public String extractName(SerializedName in) {
            return Preconditions.checkNotNull(in, "input annotation").value();
        }
    }

    public static abstract class NameExtractor<A extends Annotation>
    implements Function<Annotation, String>,
    Supplier<Predicate<Annotation>> {
        protected final Class<A> annotationType;
        protected final Predicate<Annotation> predicate;

        protected NameExtractor(final Class<A> annotationType) {
            this.annotationType = Preconditions.checkNotNull(annotationType, "annotationType");
            this.predicate = new Predicate<Annotation>(){

                @Override
                public boolean apply(Annotation input) {
                    return input.getClass().equals(annotationType);
                }
            };
        }

        public Class<Annotation> annotationType() {
            return this.annotationType;
        }

        @Override
        public String apply(Annotation in) {
            return this.extractName((Annotation)this.annotationType.cast(in));
        }

        protected abstract String extractName(A var1);

        @Override
        public Predicate<Annotation> get() {
            return this.predicate;
        }

        public String toString() {
            return "nameExtractor(" + this.annotationType.getSimpleName() + ")";
        }

        public int hashCode() {
            return this.annotationType.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.annotationType.equals(((NameExtractor)NameExtractor.class.cast((Object)obj)).annotationType);
        }
    }
}

