/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain.internal;

import java.net.URI;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Ordering;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.javax.annotation.Nullable;

public abstract class ResourceMetadataImpl<T extends Enum<T>>
implements ResourceMetadata<T> {
    @Nullable
    private final String providerId;
    @Nullable
    private final String name;
    @Nullable
    private final Location location;
    @Nullable
    private final URI uri;
    private final Map<String, String> userMetadata = Maps.newLinkedHashMap();

    public ResourceMetadataImpl(@Nullable String providerId, @Nullable String name, @Nullable Location location, @Nullable URI uri, Map<String, String> userMetadata) {
        this.providerId = providerId;
        this.name = name;
        this.location = location;
        this.uri = uri;
        this.userMetadata.putAll(Preconditions.checkNotNull(userMetadata, "userMetadata"));
    }

    @Override
    public int compareTo(ResourceMetadata<T> that) {
        return ComparisonChain.start().compare(this.getName(), that.getName(), Ordering.natural().nullsLast()).result();
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceMetadataImpl that = (ResourceMetadataImpl)ResourceMetadataImpl.class.cast(o);
        return Objects.equal(this.getType(), that.getType()) && Objects.equal(this.providerId, that.providerId) && Objects.equal(this.name, that.name) && Objects.equal(this.location, that.location) && Objects.equal(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hashCode(this.getType(), this.providerId, this.name, this.location, this.uri);
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("type", this.getType()).add("providerId", this.providerId).add("name", this.name).add("location", this.location).add("uri", this.uri).add("userMetadata", this.userMetadata);
    }
}

