/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.glacier.domain.VaultMetadata;
import org.jclouds.glacier.options.PaginationOptions;

public class PaginatedVaultCollection
extends IterableWithMarker<VaultMetadata> {
    @SerializedName(value="VaultList")
    private final Iterable<VaultMetadata> vaults;
    @SerializedName(value="Marker")
    private final String marker;

    @ConstructorProperties(value={"VaultList", "Marker"})
    public PaginatedVaultCollection(Iterable<VaultMetadata> vaults, String marker) {
        this.vaults = Preconditions.checkNotNull(vaults, "vaults");
        this.marker = marker;
    }

    @Override
    public Iterator<VaultMetadata> iterator() {
        return this.vaults.iterator();
    }

    @Override
    public Optional<Object> nextMarker() {
        return Optional.fromNullable(this.marker);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)PaginationOptions.class.cast(this.nextMarker().get());
    }
}

