/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.filters;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multiset;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.TreeMultiset;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteProcessor;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteStreams;
import org.apache.pulsar.jcloud.shade.jakarta.annotation.Resource;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azure.storage.util.storageurl.StorageUrlSupplier;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.logging.Logger;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class SharedKeyLiteAuthentication
implements HttpRequestFilter {
    private static final Collection<String> FIRST_HEADERS_TO_SIGN = ImmutableList.of("Date");
    private static final Collection<String> FIRST_HEADERS_TO_SIGN_FOR_SHARED_KEY = ImmutableList.of("Date", "If-Modified-Since", "If-Match", "If-None-Match", "If-Unmodified-Since", "Range");
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final String credential;
    private final HttpUtils utils;
    private final URI storageUrl;
    private final boolean isSAS;
    private final AuthType authType;
    private final OAuthFilter oAuthFilter;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SharedKeyLiteAuthentication(SignatureWire signatureWire, @org.jclouds.location.Provider Supplier<Credentials> creds, @TimeStamp Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils, @Named(value="sasAuth") boolean sasAuthentication, StorageUrlSupplier storageUrlSupplier, AuthType authType, OAuthFilter oAuthFilter) {
        this.crypto = crypto;
        this.utils = utils;
        this.signatureWire = signatureWire;
        this.storageUrl = (URI)storageUrlSupplier.get();
        this.creds = creds;
        this.credential = creds.get().credential;
        this.timeStampProvider = timeStampProvider;
        this.isSAS = sasAuthentication;
        this.authType = authType;
        this.oAuthFilter = oAuthFilter;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        request = this.authType == AuthType.AZURE_AD ? this.oAuthFilter.filter(request) : (this.authType == AuthType.AZURE_SHARED_KEY ? (this.isSAS ? this.filterSAS(request, this.credential) : this.filterSharedKey(request)) : (this.isSAS ? this.filterSAS(request, this.credential) : this.filterKey(request)));
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    public HttpRequest filterSAS(HttpRequest request, String credential) throws HttpException, IllegalArgumentException {
        URI requestUri = request.getEndpoint();
        String formattedCredential = credential.startsWith("?") ? credential.substring(1) : credential;
        String initialQuery = requestUri.getQuery();
        String finalQuery = initialQuery == null ? formattedCredential : initialQuery + "&" + formattedCredential;
        String[] parametersArray = this.cutUri(requestUri);
        String containerName = parametersArray[1];
        Uris.UriBuilder endpoint = Uris.uriBuilder(this.storageUrl).appendPath(containerName);
        if (parametersArray.length >= 3) {
            Object[] blobNameParts = Arrays.copyOfRange(parametersArray, 2, parametersArray.length);
            String blobName = Joiner.on("/").join(blobNameParts);
            endpoint.appendPath(blobName).query(finalQuery);
        } else {
            endpoint.query("restype=container&" + finalQuery);
        }
        return this.removeAuthorizationHeader(this.replaceDateHeader(((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(endpoint.build())).build()));
    }

    public HttpRequest filterKey(HttpRequest request) throws HttpException {
        request = this.replaceDateHeader(request);
        String signature = this.calculateSignature(this.createStringToSign(request));
        return this.replaceAuthorizationHeader(request, signature);
    }

    public HttpRequest filterSharedKey(HttpRequest request) throws HttpException {
        request = this.replaceDateHeader(request);
        String signature = this.calculateSignature(this.createStringToSignForSharedKey(request));
        return this.replaceAuthorizationHeaderForSharedKey(request, signature);
    }

    HttpRequest replaceAuthorizationHeaderForSharedKey(HttpRequest request, String signature) {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", "SharedKey " + this.creds.get().identity + ":" + signature)).build();
    }

    HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", "SharedKeyLite " + this.creds.get().identity + ":" + signature)).build();
    }

    HttpRequest removeAuthorizationHeader(HttpRequest request) {
        return ((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).build();
    }

    HttpRequest replaceDateHeader(HttpRequest request) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        String date = this.timeStampProvider.get();
        builder.put("Date", date);
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders(Multimaps.forMap(builder.build()))).build();
        return request;
    }

    public String[] cutUri(URI uri) throws IllegalArgumentException {
        String path = uri.getPath();
        String[] result = path.split("/");
        if (result.length < 2) {
            throw new IllegalArgumentException("there is neither ContainerName nor BlobName in the URI path");
        }
        return result;
    }

    public String createStringToSignForSharedKey(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadataForSharedKey(request, buffer);
        this.appendHttpHeadersForSharedKey(request, buffer);
        this.appendCanonicalizedHeaders(request, buffer);
        this.appendCanonicalizedResourceForSharedKey(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(buffer.toString());
        }
        return buffer.toString();
    }

    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, buffer);
        this.appendCanonicalizedHeaders(request, buffer);
        this.appendCanonicalizedResource(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(buffer.toString());
        }
        return buffer.toString();
    }

    private void appendPayloadMetadataForSharedKey(HttpRequest request, StringBuilder buffer) {
        Payload payload = request.getPayload();
        if (payload == null) {
            buffer.append("\n\n\n\n\n");
            return;
        }
        MutableContentMetadata contentMetadata = payload.getContentMetadata();
        buffer.append(Strings.nullToEmpty(contentMetadata.getContentEncoding())).append("\n");
        buffer.append(Strings.nullToEmpty(contentMetadata.getContentLanguage())).append("\n");
        buffer.append(HttpUtils.nullOrZeroToEmpty(contentMetadata.getContentLength())).append("\n");
        buffer.append(HttpUtils.nullToEmpty(contentMetadata.getContentMD5())).append("\n");
        buffer.append(Strings.nullToEmpty(contentMetadata.getContentType())).append("\n");
    }

    private void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(HttpUtils.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentMD5())).append("\n");
        buffer.append(Strings.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentType())).append("\n");
    }

    public String calculateSignature(String toSign) throws HttpException {
        String signature = this.signString(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream(signature));
        }
        return signature;
    }

    public String signString(String toSign) {
        try {
            ByteProcessor<byte[]> hmacSHA256 = Macs.asByteProcessor(this.crypto.hmacSHA256(BaseEncoding.base64().decode(this.creds.get().credential)));
            return BaseEncoding.base64().encode(ByteStreams.readBytes(Strings2.toInputStream(toSign), hmacSHA256));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
    }

    private void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    private void appendCanonicalizedHeaders(HttpRequest request, StringBuilder toSign) {
        TreeMap<String, String> headers = Maps.newTreeMap();
        Multimap<String, String> requestHeaders = request.getHeaders();
        for (String string : requestHeaders.keySet()) {
            if (!string.startsWith("x-ms-")) continue;
            String value = Joiner.on(",").join(Iterables.transform(requestHeaders.get(string), new Function<String, Object>(){

                @Override
                public Object apply(String value) {
                    return Patterns.NEWLINE_PATTERN.matcher(value).replaceAll("");
                }
            }));
            headers.put(string.toLowerCase(), value);
        }
        for (Map.Entry entry : headers.entrySet()) {
            toSign.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
        }
    }

    private void appendHttpHeaders(HttpRequest request, StringBuilder toSign) {
        for (String header : FIRST_HEADERS_TO_SIGN) {
            toSign.append(HttpUtils.nullToEmpty(request.getHeaders().get(header))).append("\n");
        }
    }

    private void appendHttpHeadersForSharedKey(HttpRequest request, StringBuilder toSign) {
        for (String header : FIRST_HEADERS_TO_SIGN_FOR_SHARED_KEY) {
            toSign.append(HttpUtils.nullToEmpty(request.getHeaders().get(header))).append("\n");
        }
    }

    @VisibleForTesting
    void appendCanonicalizedResource(HttpRequest request, StringBuilder toSign) {
        toSign.append("/").append(this.creds.get().identity);
        this.appendUriPath(request, toSign);
    }

    void appendCanonicalizedResourceForSharedKey(HttpRequest request, StringBuilder toSign) {
        toSign.append("/").append(this.creds.get().identity);
        toSign.append(request.getEndpoint().getRawPath());
        this.appendQueryParametersForSharedKey(request, toSign);
    }

    void appendQueryParametersForSharedKey(HttpRequest request, StringBuilder toSign) {
        TreeMap sortedParams = Maps.newTreeMap();
        if (request.getEndpoint().getQuery() != null) {
            String[] params;
            for (String param : params = request.getEndpoint().getQuery().split("&")) {
                String value;
                String[] paramNameAndValue = param.split("=");
                String key = paramNameAndValue[0];
                String string = value = paramNameAndValue.length > 1 ? paramNameAndValue[1] : "";
                if (sortedParams.containsKey(key)) {
                    ((Multiset)sortedParams.get(key)).add(value);
                    continue;
                }
                TreeMultiset<String> values = TreeMultiset.create();
                values.add(value);
                sortedParams.put(key, values);
            }
        }
        for (Map.Entry entry : sortedParams.entrySet()) {
            String key = (String)entry.getKey();
            Multiset values = (Multiset)entry.getValue();
            toSign.append("\n");
            toSign.append(key);
            toSign.append(":");
            boolean first = true;
            for (String value : values) {
                if (!first) {
                    toSign.append(",");
                }
                toSign.append(value);
                first = false;
            }
        }
    }

    @VisibleForTesting
    void appendUriPath(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath());
        if (request.getEndpoint().getQuery() != null) {
            String[] params;
            StringBuilder paramsToSign = new StringBuilder("?");
            for (String param : params = request.getEndpoint().getQuery().split("&")) {
                String[] paramNameAndValue = param.split("=");
                if (!"comp".equals(paramNameAndValue[0])) continue;
                paramsToSign.append(param);
            }
            if (paramsToSign.length() > 1) {
                toSign.append((CharSequence)paramsToSign);
            }
        }
    }
}

